/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10225;
import net.minecraft.class_10804;
import net.minecraft.class_10821;
import net.minecraft.class_124;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2446;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4538;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4970;
import net.minecraft.class_5797;
import net.minecraft.class_5819;
import net.minecraft.class_7800;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.MishangucProperties;
import pers.solid.mishang.uc.block.AbstractRoadBlock;
import pers.solid.mishang.uc.block.Road;
import pers.solid.mishang.uc.block.RoadWithAngleLine;
import pers.solid.mishang.uc.block.RoadWithStraightLine;
import pers.solid.mishang.uc.blocks.RoadBlocks;
import pers.solid.mishang.uc.data.FasterTextureMap;
import pers.solid.mishang.uc.data.MishangucTextureKeys;
import pers.solid.mishang.uc.util.HorizontalCornerDirection;
import pers.solid.mishang.uc.util.LineColor;
import pers.solid.mishang.uc.util.LineType;
import pers.solid.mishang.uc.util.RoadConnectionState;
import pers.solid.mishang.uc.util.TextBridge;

public interface RoadWithStraightAndAngleLine
extends RoadWithAngleLine,
RoadWithStraightLine {
    public static final class_2746 BEVEL_TOP = MishangucProperties.BEVEL_TOP;

    @Override
    default public void appendRoadProperties(class_2689.class_2690<class_2248, class_2680> builder) {
        RoadWithAngleLine.super.appendRoadProperties(builder);
        RoadWithStraightLine.super.appendRoadProperties(builder);
    }

    @Override
    default public RoadConnectionState getConnectionStateOf(class_2680 state, class_2350 direction) {
        return RoadConnectionState.or(RoadWithStraightLine.super.getConnectionStateOf(state, direction), RoadWithAngleLine.super.getConnectionStateOf(state, direction));
    }

    @Override
    default public class_2680 mirrorRoad(class_2680 state, class_2415 mirror) {
        return RoadWithAngleLine.super.mirrorRoad(state, mirror);
    }

    @Override
    default public class_2680 rotateRoad(class_2680 state, class_2470 rotation) {
        return RoadWithStraightLine.super.rotateRoad(RoadWithAngleLine.super.rotateRoad(state, rotation), rotation);
    }

    @Override
    default public class_2680 withPlacementState(class_2680 state, class_1750 ctx) {
        return RoadWithStraightLine.super.withPlacementState(RoadWithAngleLine.super.withPlacementState(state, ctx), ctx);
    }

    @Override
    default public void appendRoadTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        RoadWithAngleLine.super.appendRoadTooltip(stack, context, tooltip, options);
        RoadWithStraightLine.super.appendRoadTooltip(stack, context, tooltip, options);
    }

    public static class Impl
    extends AbstractRoadBlock
    implements RoadWithStraightAndAngleLine {
        public static final MapCodec<Impl> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Impl.method_54096(), Impl.lineColorFieldCodec(), (App)LineColor.CODEC.fieldOf("line_color_side").forGetter(b -> b.lineColorSide), Impl.lineTypeFieldCodec(), (App)LineType.CODEC.fieldOf("line_type_side").forGetter(b -> b.lineTypeSide)).apply((Applicative)i, Impl::new));
        private static boolean hasBevelTopProperty;
        private final LineColor lineColorSide;
        private final LineType lineTypeSide;

        public Impl(class_4970.class_2251 settings, LineColor lineColor, LineColor lineColorSide, LineType lineType, LineType lineTypeSide) {
            super(settings, lineColor, ((Supplier<LineType>)() -> {
                hasBevelTopProperty = lineColor != lineColorSide;
                return lineType;
            }).get());
            this.lineColorSide = lineColorSide;
            this.lineTypeSide = lineTypeSide;
            if (hasBevelTopProperty) {
                this.method_9590((class_2680)this.method_9564().method_11657((class_2769)BEVEL_TOP, (Comparable)Boolean.valueOf(false)));
            }
        }

        public Impl(class_4970.class_2251 settings, LineColor lineColor, LineType lineType) {
            this(settings, lineColor, lineColor, lineType, lineType);
        }

        @Override
        public boolean isBevel() {
            return true;
        }

        @Override
        public void appendRoadProperties(class_2689.class_2690<class_2248, class_2680> builder) {
            RoadWithStraightAndAngleLine.super.appendRoadProperties(builder);
            if (hasBevelTopProperty) {
                builder.method_11667(new class_2769[]{BEVEL_TOP});
            }
        }

        @Override
        @Nullable
        public class_2680 method_9605(class_1750 ctx) {
            class_2680 placementState = super.method_9605(ctx);
            if (placementState == null) {
                return null;
            }
            class_2350 direction = ((HorizontalCornerDirection)((Object)placementState.method_11654((class_2769)FACING))).getDirectionInAxis((class_2350.class_2351)placementState.method_11654((class_2769)AXIS));
            class_2338 blockPos = ctx.method_8037();
            class_2338 neighborPos = blockPos.method_10093(direction);
            class_1937 world = ctx.method_8045();
            return this.method_9559(placementState, (class_4538)world, (class_10225)world, blockPos, direction, neighborPos, world.method_8320(neighborPos), world.field_9229);
        }

        @Override
        protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
            class_2680 stateForNeighborUpdate = super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
            if (stateForNeighborUpdate.method_28498((class_2769)BEVEL_TOP) && ((class_2350.class_2351)stateForNeighborUpdate.method_11654((class_2769)AXIS)).method_10176(direction) && ((HorizontalCornerDirection)((Object)stateForNeighborUpdate.method_11654((class_2769)FACING))).hasDirection(direction)) {
                Road road;
                Road road2;
                Road road3;
                boolean bevelTop;
                class_2248 neighborBlock = neighborState.method_26204();
                boolean bl = bevelTop = neighborBlock instanceof Road && (road3 = (Road)neighborBlock).getLineColor(neighborState, direction.method_10153()) == this.lineColorSide;
                if (bevelTop) {
                    return (class_2680)stateForNeighborUpdate.method_11657((class_2769)BEVEL_TOP, (Comparable)Boolean.valueOf(true));
                }
                class_2338 up = neighborPos.method_10084();
                class_2680 upState = world.method_8320(up);
                class_2248 class_22482 = upState.method_26204();
                if (class_22482 instanceof Road && (road2 = (Road)class_22482).getLineColor(upState, direction.method_10153()) == this.lineColorSide) {
                    return (class_2680)stateForNeighborUpdate.method_11657((class_2769)BEVEL_TOP, (Comparable)Boolean.valueOf(true));
                }
                class_2338 down = neighborPos.method_10074();
                class_2680 downState = world.method_8320(down);
                class_2248 class_22483 = downState.method_26204();
                if (class_22483 instanceof Road && (road = (Road)class_22483).getLineColor(downState, direction.method_10153()) == this.lineColorSide) {
                    return (class_2680)stateForNeighborUpdate.method_11657((class_2769)BEVEL_TOP, (Comparable)Boolean.valueOf(true));
                }
                return (class_2680)stateForNeighborUpdate.method_11657((class_2769)BEVEL_TOP, (Comparable)Boolean.valueOf(false));
            }
            return stateForNeighborUpdate;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        protected <B extends class_2248> void registerBaseOrSlabModels(B road, class_4910 blockStateModelGenerator) {
            class_2960 beveledTopMirroredModelId;
            class_2960 beveledTopModelId;
            String lineTopStraight = MishangUtils.composeStraightLineTexture(this.lineColor, this.lineType);
            String lineTopAngle = MishangUtils.composeAngleLineTexture(this.lineColorSide, LineType.NORMAL, true);
            String lineSide = lineTopStraight;
            String lineSide2 = MishangUtils.composeStraightLineTexture(this.lineColorSide, this.lineTypeSide);
            FasterTextureMap textures = new FasterTextureMap().base("asphalt").lineTop(lineTopAngle).lineTop2(lineTopStraight).lineSide(lineSide).lineSide2(lineSide2);
            class_2960 modelId = ((Road)road).uploadModel("_with_straight_and_angle_line", textures, blockStateModelGenerator, MishangucTextureKeys.BASE, MishangucTextureKeys.LINE_TOP, MishangucTextureKeys.LINE_TOP2, MishangucTextureKeys.LINE_SIDE, MishangucTextureKeys.LINE_SIDE2);
            class_2960 mirroredModelId = ((Road)road).uploadModel("_with_straight_and_angle_line_mirrored", "_mirrored", textures, blockStateModelGenerator, MishangucTextureKeys.BASE, MishangucTextureKeys.LINE_TOP, MishangucTextureKeys.LINE_TOP2, MishangucTextureKeys.LINE_SIDE, MishangucTextureKeys.LINE_SIDE2);
            if (this.field_10647.method_11659().contains(BEVEL_TOP)) {
                FasterTextureMap textures2 = new FasterTextureMap().base("asphalt").lineTop(lineTopStraight).lineTop2(lineTopAngle).lineSide(lineSide).lineSide2(lineSide2).varP(MishangucTextureKeys.LINE_SIDE3, lineSide2);
                beveledTopModelId = ((Road)road).uploadModel("_with_straight_and_angle_line", "_bevel_top", textures2, blockStateModelGenerator, MishangucTextureKeys.BASE, MishangucTextureKeys.LINE_TOP, MishangucTextureKeys.LINE_TOP2, MishangucTextureKeys.LINE_SIDE, MishangucTextureKeys.LINE_SIDE2, MishangucTextureKeys.LINE_SIDE3);
                beveledTopMirroredModelId = ((Road)road).uploadModel("_with_straight_and_angle_line_mirrored", "_bevel_top_mirrored", textures2, blockStateModelGenerator, MishangucTextureKeys.BASE, MishangucTextureKeys.LINE_TOP, MishangucTextureKeys.LINE_TOP2, MishangucTextureKeys.LINE_SIDE, MishangucTextureKeys.LINE_SIDE2, MishangucTextureKeys.LINE_SIDE3);
            } else {
                beveledTopMirroredModelId = null;
                beveledTopModelId = null;
            }
            boolean hasBevelTop = this.lineColor != this.lineColorSide;
            class_4926.class_4928 map1 = hasBevelTop ? null : class_4926.method_67865((class_2769)AXIS, (class_2769)FACING);
            class_4926.class_4929 map2 = hasBevelTop ? class_4926.method_67866((class_2769)AXIS, (class_2769)FACING, (class_2769)BEVEL_TOP) : null;
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_10821 axisRotation = switch (direction) {
                    case class_2350.field_11039 -> class_10821.field_57030;
                    case class_2350.field_11043 -> class_10821.field_57031;
                    case class_2350.field_11034 -> class_10821.field_57032;
                    default -> class_10821.field_57029;
                };
                class_10821 axisRotationCCW90 = switch (direction) {
                    case class_2350.field_11039 -> class_10821.field_57029;
                    case class_2350.field_11043 -> class_10821.field_57030;
                    case class_2350.field_11034 -> class_10821.field_57031;
                    default -> class_10821.field_57032;
                };
                class_2350.class_2351 axis = direction.method_10166();
                @NotNull HorizontalCornerDirection facing1 = HorizontalCornerDirection.fromDirections(direction, direction.method_10170());
                @NotNull HorizontalCornerDirection facing2 = HorizontalCornerDirection.fromDirections(direction, direction.method_10160());
                if (hasBevelTop) {
                    map2.method_25807((Comparable)axis, (Comparable)((Object)facing1), (Comparable)Boolean.valueOf(false), (Object)class_4910.method_67835((class_2960)modelId).method_67929(class_10804.field_56937.withValue((Object)axisRotation)));
                    map2.method_25807((Comparable)axis, (Comparable)((Object)facing1), (Comparable)Boolean.valueOf(true), (Object)class_4910.method_67835((class_2960)beveledTopModelId).method_67929(class_10804.field_56937.withValue((Object)axisRotation)));
                    map2.method_25807((Comparable)axis, (Comparable)((Object)facing2), (Comparable)Boolean.valueOf(false), (Object)class_4910.method_67835((class_2960)mirroredModelId).method_67929(class_10804.field_56937.withValue((Object)axisRotationCCW90)));
                    map2.method_25807((Comparable)axis, (Comparable)((Object)facing2), (Comparable)Boolean.valueOf(true), (Object)class_4910.method_67835((class_2960)beveledTopMirroredModelId).method_67929(class_10804.field_56937.withValue((Object)axisRotationCCW90)));
                    continue;
                }
                map1.method_25798((Comparable)axis, (Comparable)((Object)facing1), (Object)class_4910.method_67835((class_2960)modelId).method_67929(class_10804.field_56937.withValue((Object)axisRotation)));
                map1.method_25798((Comparable)axis, (Comparable)((Object)facing2), (Object)class_4910.method_67835((class_2960)mirroredModelId).method_67929(class_10804.field_56937.withValue((Object)axisRotationCCW90)));
            }
            blockStateModelGenerator.field_22830.accept(((Road)road).composeState((class_4917)class_4925.method_67852(road).method_67859((class_4926)(hasBevelTop ? map2 : map1))));
        }

        @Override
        public LineColor getLineColor(class_2680 state, class_2350 direction) {
            if (((HorizontalCornerDirection)((Object)state.method_11654((class_2769)FACING))).hasDirection(direction) && (state.method_28498((class_2769)BEVEL_TOP) && ((Boolean)state.method_11654((class_2769)BEVEL_TOP)).booleanValue() || !((class_2350.class_2351)state.method_11654((class_2769)AXIS)).method_10176(direction))) {
                return this.lineColorSide;
            }
            return super.getLineColor(state, direction);
        }

        @Override
        public LineType getLineType(class_2680 state, class_2350 direction) {
            if (((HorizontalCornerDirection)((Object)state.method_11654((class_2769)FACING))).hasDirection(direction) && !((class_2350.class_2351)state.method_11654((class_2769)AXIS)).method_10176(direction)) {
                return this.lineTypeSide;
            }
            return super.getLineType(state, direction);
        }

        @Override
        public void appendDescriptionTooltip(List<class_2561> tooltip, class_1792.class_9635 options) {
            if (this.lineColor == this.lineColorSide && this.lineType == this.lineTypeSide) {
                tooltip.add((class_2561)TextBridge.translatable("lineType.straightAndAngle.same", this.lineColor.getName(), this.lineType.getName()).method_27692(class_124.field_1078));
            } else {
                tooltip.add((class_2561)TextBridge.translatable("lineType.straightAndAngle.straight", this.lineColor.getName(), this.lineType.getName()).method_27692(class_124.field_1078));
                tooltip.add((class_2561)TextBridge.translatable("lineType.straightAndAngle.bevel", this.lineColorSide.getName(), this.lineTypeSide.getName()).method_27692(class_124.field_1078));
            }
        }

        protected MapCodec<? extends Impl> method_53969() {
            return CODEC;
        }

        @Override
        public class_5797 getPaintingRecipe(class_2248 base, class_2248 self, class_2446 recipeGenerator) {
            if (this.lineTypeSide != LineType.NORMAL) {
                throw new UnsupportedOperationException();
            }
            Road base2 = RoadBlocks.getRoadBlockWithLine(this.lineColor, this.lineType);
            if (base instanceof class_2482) {
                base2 = base2.getRoadSlab();
            }
            return recipeGenerator.method_62747(class_7800.field_40634, (class_1935)self, 3).method_10439(" *X").method_10439("*X ").method_10439("X  ").method_10433(Character.valueOf('*'), this.lineColorSide.getIngredient()).method_10434(Character.valueOf('X'), (class_1935)base2).method_10429("has_paint", recipeGenerator.method_10420(this.lineColorSide.getIngredient())).method_10429(class_2446.method_32807((class_1935)base2), recipeGenerator.method_10426((class_1935)base2));
        }
    }
}

