/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function3;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2446;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4970;
import net.minecraft.class_5797;
import net.minecraft.class_7800;
import net.minecraft.class_807;
import org.jetbrains.annotations.ApiStatus;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.block.AbstractRoadBlock;
import pers.solid.mishang.uc.block.Road;
import pers.solid.mishang.uc.blocks.RoadBlocks;
import pers.solid.mishang.uc.data.FasterTextureMap;
import pers.solid.mishang.uc.data.MishangucTextureKeys;
import pers.solid.mishang.uc.mixin.BlockStateModelGeneratorAccessor;
import pers.solid.mishang.uc.util.EightHorizontalDirection;
import pers.solid.mishang.uc.util.HorizontalCornerDirection;
import pers.solid.mishang.uc.util.LineColor;
import pers.solid.mishang.uc.util.LineType;
import pers.solid.mishang.uc.util.RoadConnectionState;
import pers.solid.mishang.uc.util.TextBridge;

@ApiStatus.AvailableSince(value="1.1.0")
public interface RoadWithTwoBevelAngleLines
extends Road {
    public static final class_2754<class_2350> FACING = class_2741.field_12481;

    @Override
    default public void appendRoadProperties(class_2689.class_2690<class_2248, class_2680> builder) {
        Road.super.appendRoadProperties(builder);
        builder.method_11667(new class_2769[]{FACING});
    }

    @Override
    default public void appendRoadTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        Road.super.appendRoadTooltip(stack, context, tooltip, options);
        tooltip.add((class_2561)TextBridge.translatable("block.mishanguc.tooltip.road_with_bi_bevel_angle_line.1").method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("block.mishanguc.tooltip.road_with_bi_bevel_angle_line.2").method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("block.mishanguc.tooltip.road_with_bi_bevel_angle_line.3").method_27692(class_124.field_1080));
    }

    @Override
    default public class_2680 rotateRoad(class_2680 state, class_2470 rotation) {
        return (class_2680)Road.super.rotateRoad(state, rotation).method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    @Override
    default public class_2680 mirrorRoad(class_2680 state, class_2415 mirror) {
        return (class_2680)Road.super.mirrorRoad(state, mirror).method_11657(FACING, (Comparable)mirror.method_10343((class_2350)state.method_11654(FACING)));
    }

    @Override
    default public class_2680 withPlacementState(class_2680 state, class_1750 ctx) {
        class_2350 playerFacing = ctx.method_8042();
        return (class_2680)Road.super.withPlacementState(state, ctx).method_11657(FACING, (Comparable)(ctx.method_8036() != null && ctx.method_8036().method_5715() ? playerFacing.method_10153() : playerFacing));
    }

    public static <B extends AbstractRoadBlock> MapCodec<B> createCodec(RecordCodecBuilder<B, class_4970.class_2251> settingsCodec, Function3<class_4970.class_2251, LineColor, LineType, B> function) {
        return RecordCodecBuilder.mapCodec(i -> i.group((App)settingsCodec, AbstractRoadBlock.lineColorFieldCodec(), AbstractRoadBlock.lineTypeFieldCodec()).apply((Applicative)i, function));
    }

    public static class ImplWithThreeLayerTexture
    extends AbstractRoadBlock
    implements RoadWithTwoBevelAngleLines {
        public static final MapCodec<ImplWithThreeLayerTexture> CODEC = RoadWithTwoBevelAngleLines.createCodec(ImplWithThreeLayerTexture.method_54096(), ImplWithThreeLayerTexture::new);

        public ImplWithThreeLayerTexture(class_4970.class_2251 settings, LineColor lineColor, LineType lineType) {
            super(settings, lineColor, lineType);
            this.method_9590((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11035));
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        protected <B extends class_2248> void registerBaseOrSlabModels(B road, class_4910 blockStateModelGenerator) {
            FasterTextureMap textures = new FasterTextureMap().base("asphalt").lineTop(MishangUtils.composeStraightLineTexture(this.lineColor, this.lineType)).lineSide(MishangUtils.composeStraightLineTexture(this.lineColor, this.lineType)).lineTop2(MishangUtils.composeAngleLineTexture(this.lineColor, this.lineType, true));
            class_2960 modelId = ((Road)road).uploadModel("_with_straight_and_bi_angle_line", textures, blockStateModelGenerator, MishangucTextureKeys.BASE, MishangucTextureKeys.LINE_TOP, MishangucTextureKeys.LINE_SIDE, MishangucTextureKeys.LINE_TOP2);
            blockStateModelGenerator.field_22830.accept(((Road)road).composeState((class_4917)class_4910.method_25644(road, (class_807)class_4910.method_67835((class_2960)modelId)).method_25775(BlockStateModelGeneratorAccessor.getSOUTH_DEFAULT_HORIZONTAL_ROTATION_OPERATIONS())));
        }

        @Override
        public RoadConnectionState getConnectionStateOf(class_2680 state, class_2350 direction) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
            if (facing == direction || facing == direction.method_10153()) {
                return new RoadConnectionState(RoadConnectionState.WhetherConnected.CONNECTED, this.lineColor, EightHorizontalDirection.of(direction), this.lineType);
            }
            return new RoadConnectionState(RoadConnectionState.WhetherConnected.CONNECTED, this.lineColor, EightHorizontalDirection.of(HorizontalCornerDirection.fromDirections(facing, direction.method_10153())), this.lineType);
        }

        @Override
        public void appendDescriptionTooltip(List<class_2561> tooltip, class_1792.class_9635 options) {
            tooltip.add((class_2561)TextBridge.translatable("lineType.biBevelAngleLine", this.lineColor.getName(), this.lineType.getName()).method_27692(class_124.field_1078));
        }

        protected MapCodec<? extends ImplWithThreeLayerTexture> method_53969() {
            return CODEC;
        }

        @Override
        public class_5797 getPaintingRecipe(class_2248 base, class_2248 self, class_2446 recipeGenerator) {
            Road base2 = RoadBlocks.getRoadBlockWithLine(this.lineColor, this.lineType);
            if (base instanceof class_2482) {
                base2 = base2.getRoadSlab();
            }
            return recipeGenerator.method_62747(class_7800.field_40634, (class_1935)self, 3).method_10439(" *X").method_10439("*X*").method_10439("X* ").method_10433(Character.valueOf('*'), this.lineColor.getIngredient()).method_10434(Character.valueOf('X'), (class_1935)base2).method_10429("has_paint", recipeGenerator.method_10420(this.lineColor.getIngredient())).method_10429(class_2446.method_32807((class_1935)base2), recipeGenerator.method_10426((class_1935)base2));
        }
    }

    public static class ImplWithTwoLayerTexture
    extends AbstractRoadBlock
    implements RoadWithTwoBevelAngleLines {
        public static final MapCodec<ImplWithTwoLayerTexture> CODEC = RoadWithTwoBevelAngleLines.createCodec(ImplWithTwoLayerTexture.method_54096(), ImplWithTwoLayerTexture::new);

        public ImplWithTwoLayerTexture(class_4970.class_2251 settings, LineColor lineColor, LineType lineType) {
            super(settings, lineColor, lineType);
            this.method_9590((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11035));
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        protected <B extends class_2248> void registerBaseOrSlabModels(B road, class_4910 blockStateModelGenerator) {
            FasterTextureMap textures = new FasterTextureMap().base("asphalt").lineTop(MishangUtils.composeAngleLineTexture(this.lineColor, this.lineType, true)).lineSide(MishangUtils.composeStraightLineTexture(this.lineColor, this.lineType));
            class_2960 modelId = ((Road)road).uploadModel("_with_bi_angle_line", textures, blockStateModelGenerator, MishangucTextureKeys.BASE, MishangucTextureKeys.LINE_TOP, MishangucTextureKeys.LINE_SIDE);
            blockStateModelGenerator.field_22830.accept(((Road)road).composeState((class_4917)class_4910.method_25644(road, (class_807)class_4910.method_67835((class_2960)modelId)).method_25775(BlockStateModelGeneratorAccessor.getSOUTH_DEFAULT_HORIZONTAL_ROTATION_OPERATIONS())));
        }

        @Override
        public RoadConnectionState getConnectionStateOf(class_2680 state, class_2350 direction) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
            if (facing == direction) {
                return new RoadConnectionState(RoadConnectionState.WhetherConnected.CONNECTED, this.lineColor, EightHorizontalDirection.of(direction), this.lineType);
            }
            if (facing != direction.method_10153()) {
                return new RoadConnectionState(RoadConnectionState.WhetherConnected.CONNECTED, this.lineColor, EightHorizontalDirection.of(HorizontalCornerDirection.fromDirections(facing, direction.method_10153())), this.lineType);
            }
            return super.getConnectionStateOf(state, direction);
        }

        @Override
        public void appendDescriptionTooltip(List<class_2561> tooltip, class_1792.class_9635 options) {
            tooltip.add((class_2561)TextBridge.translatable("lineType.biBevelAngleLine", this.lineColor.getName(), this.lineType.getName()).method_27692(class_124.field_1078));
        }

        protected MapCodec<? extends ImplWithTwoLayerTexture> method_53969() {
            return CODEC;
        }

        @Override
        public class_5797 getPaintingRecipe(class_2248 base, class_2248 self, class_2446 recipeGenerator) {
            return recipeGenerator.method_62747(class_7800.field_40634, (class_1935)self, 3).method_10439(" **").method_10439("** ").method_10439("XXX").method_10433(Character.valueOf('*'), this.lineColor.getIngredient()).method_10434(Character.valueOf('X'), (class_1935)base).method_10429("has_paint", recipeGenerator.method_10420(this.lineColor.getIngredient())).method_10429(class_2446.method_32807((class_1935)base), recipeGenerator.method_10426((class_1935)base));
        }
    }
}

