/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10410;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_3981;
import net.minecraft.class_4910;
import net.minecraft.class_4916;
import net.minecraft.class_4941;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5797;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.block.ColoredBlock;
import pers.solid.mishang.uc.block.HandrailBlock;
import pers.solid.mishang.uc.block.HandrailCentralBlock;
import pers.solid.mishang.uc.block.HandrailCornerBlock;
import pers.solid.mishang.uc.block.HandrailOuterBlock;
import pers.solid.mishang.uc.block.HandrailStairBlock;
import pers.solid.mishang.uc.data.MishangucModels;
import pers.solid.mishang.uc.util.TextBridge;

public class SimpleHandrailBlock
extends HandrailBlock {
    public static final MapCodec<SimpleHandrailBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("base_block").forGetter(b -> b.baseBlock), (App)SimpleHandrailBlock.method_54096()).apply((Applicative)instance, (block, settings1) -> new SimpleHandrailBlock((class_2248)block, (class_4970.class_2251)settings1, class_7923.field_41175.method_10221(block), false)));
    @Nullable
    public final class_2248 baseBlock;
    public final CentralBlock central;
    public final CornerBlock corner;
    public final StairBlock stair;
    public final OuterBlock outer;
    @Nullable
    public class_2960 texture;
    @Nullable
    public class_2960 top;
    @Nullable
    public class_2960 bottom;

    public SimpleHandrailBlock(@Nullable class_2248 baseBlock, class_4970.class_2251 settings, class_2960 identifier) {
        this(baseBlock, settings, identifier, true);
    }

    protected SimpleHandrailBlock(@Nullable class_2248 baseBlock, class_4970.class_2251 settings, class_2960 identifier, boolean createAffiliatedBlocks) {
        super(settings.method_22488().method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier)));
        this.baseBlock = baseBlock;
        this.central = createAffiliatedBlocks ? new CentralBlock(this, class_4970.class_2251.method_9630((class_4970)this).method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier.method_48331("_central")))) : null;
        this.corner = createAffiliatedBlocks ? new CornerBlock(this, class_4970.class_2251.method_9630((class_4970)this).method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier.method_48331("_corner")))) : null;
        this.stair = createAffiliatedBlocks ? new StairBlock(this, class_4970.class_2251.method_9630((class_4970)this).method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier.method_48331("_stair")))) : null;
        this.outer = createAffiliatedBlocks ? new OuterBlock(this, class_4970.class_2251.method_9630((class_4970)this).method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier.method_48331("_outer")))) : null;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
        class_4944 textures = this.getTextures();
        class_2960 modelId = MishangucModels.SIMPLE_HANDRAIL.method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
        class_2960 itemModelId = MishangucModels.SIMPLE_HANDRAIL_INVENTORY.method_25852(class_4941.method_25840((class_1792)this.method_8389()), textures, blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(this.createBlockStates(modelId));
        blockStateModelGenerator.field_55238.method_65460(this.method_8389(), class_10410.method_65481((class_2960)itemModelId));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @NotNull
    public class_4944 getTextures() {
        return class_4944.method_25875((class_2960)this.getTexture()).method_25868(class_4945.field_23015, this.top).method_25868(class_4945.field_23014, this.bottom);
    }

    public final HandrailCentralBlock<SimpleHandrailBlock> central() {
        return this.central;
    }

    @Override
    public HandrailCornerBlock<? extends HandrailBlock> corner() {
        return this.corner;
    }

    @Override
    public HandrailStairBlock<? extends HandrailBlock> stair() {
        return this.stair;
    }

    @Override
    public HandrailOuterBlock<? extends HandrailBlock> outer() {
        return this.outer;
    }

    @Override
    @Nullable
    public class_2248 baseBlock() {
        return this.baseBlock;
    }

    protected class_2960 getTexture() {
        return this.texture == null ? class_4944.method_25860((class_2248)this.baseBlock) : this.texture;
    }

    public class_5250 method_9518() {
        if (this.baseBlock != null) {
            return TextBridge.translatable("block.mishanguc.simple_handrail", this.baseBlock.method_9518());
        }
        return super.method_9518();
    }

    protected static <B extends class_2248> MapCodec<B> createSubCodec(Function<B, SimpleHandrailBlock> baseGetter, BiFunction<SimpleHandrailBlock, class_4970.class_2251, B> function) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("base_rail").flatXmap(block -> {
            DataResult dataResult;
            if (block instanceof SimpleHandrailBlock) {
                SimpleHandrailBlock simpleHandrailBlock = (SimpleHandrailBlock)block;
                dataResult = DataResult.success((Object)simpleHandrailBlock);
            } else {
                dataResult = DataResult.error(() -> String.valueOf(block) + "not instance of SimpleHandrailBlock");
            }
            return dataResult;
        }, DataResult::success).forGetter(baseGetter), (App)SimpleHandrailBlock.method_54096()).apply((Applicative)instance, function));
    }

    protected MapCodec<? extends SimpleHandrailBlock> method_53969() {
        return CODEC;
    }

    private String getRecipeGroup() {
        if (this.baseBlock instanceof ColoredBlock) {
            return null;
        }
        if (MishangUtils.isConcrete(this.baseBlock)) {
            return "mishanguc:simple_concrete_handrail";
        }
        if (MishangUtils.isTerracotta(this.baseBlock)) {
            return "mishanguc:simple_terracotta_handrail";
        }
        if (MishangUtils.isStained_glass(this.baseBlock)) {
            return "mishanguc:simple_stained_glass_handrail";
        }
        if (MishangUtils.isWood(this.baseBlock)) {
            return "mishanguc:simple_wood_handrail";
        }
        if (MishangUtils.isPlanks(this.baseBlock)) {
            return "mishanguc:simple_plank_handrail";
        }
        if (this.baseBlock == class_2246.field_10295 || this.baseBlock == class_2246.field_10225 || this.baseBlock == class_2246.field_10384) {
            return "mishanguc:simple_ice_handrail";
        }
        return null;
    }

    @Override
    public class_5797 getCraftingRecipe(class_2446 recipeGenerator) {
        return class_3981.method_17969((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{this.baseBlock}), (class_7800)class_7800.field_40635, (class_1935)this, (int)5).method_17970(class_2446.method_32807((class_1935)this.baseBlock), recipeGenerator.method_10426((class_1935)this.baseBlock)).method_35919(this.getRecipeGroup());
    }

    public static class CentralBlock
    extends HandrailCentralBlock<SimpleHandrailBlock> {
        public static final MapCodec<CentralBlock> CODEC = SimpleHandrailBlock.createSubCodec(b -> (SimpleHandrailBlock)b.baseHandrail, CentralBlock::new);

        public CentralBlock(@NotNull SimpleHandrailBlock baseBlock, class_4970.class_2251 settings) {
            super(baseBlock, settings);
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
            class_2960 postModelId = MishangucModels.SIMPLE_HANDRAIL_POST.method_25846((class_2248)this, ((SimpleHandrailBlock)this.baseHandrail).getTextures(), blockStateModelGenerator.field_22831);
            class_2960 sideModelId = MishangucModels.SIMPLE_HANDRAIL_SIDE.method_25846((class_2248)this, ((SimpleHandrailBlock)this.baseHandrail).getTextures(), blockStateModelGenerator.field_22831);
            class_2960 postSideModelId = MishangucModels.SIMPLE_HANDRAIL_POST_SIDE.method_25846((class_2248)this, ((SimpleHandrailBlock)this.baseHandrail).getTextures(), blockStateModelGenerator.field_22831);
            blockStateModelGenerator.field_22830.accept(this.createBlockStates(postModelId, postSideModelId, sideModelId));
        }

        public class_5250 method_9518() {
            class_2248 block = this.baseBlock();
            return block == null ? super.method_9518() : TextBridge.translatable("block.mishanguc.simple_handrail_central", block.method_9518());
        }

        @Override
        protected MapCodec<? extends CentralBlock> method_53969() {
            return CODEC;
        }
    }

    public static class CornerBlock
    extends HandrailCornerBlock<SimpleHandrailBlock> {
        public static final MapCodec<CornerBlock> CODEC = SimpleHandrailBlock.createSubCodec(b -> (SimpleHandrailBlock)b.baseHandrail, CornerBlock::new);

        public CornerBlock(@NotNull SimpleHandrailBlock baseHandrail, class_4970.class_2251 settings) {
            super(baseHandrail, settings);
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
            class_2960 modelId = MishangucModels.SIMPLE_HANDRAIL_CORNER.method_25846((class_2248)this, ((SimpleHandrailBlock)this.baseHandrail).getTextures(), blockStateModelGenerator.field_22831);
            blockStateModelGenerator.field_22830.accept(this.createBlockStates(modelId));
        }

        public class_5250 method_9518() {
            class_2248 block = this.baseBlock();
            return block == null ? super.method_9518() : TextBridge.translatable("block.mishanguc.simple_handrail_corner", block.method_9518());
        }

        @Override
        protected MapCodec<? extends CornerBlock> method_53969() {
            return CODEC;
        }
    }

    public static class StairBlock
    extends HandrailStairBlock<SimpleHandrailBlock> {
        public static final MapCodec<StairBlock> CODEC = SimpleHandrailBlock.createSubCodec(b -> (SimpleHandrailBlock)b.baseHandrail, StairBlock::new);

        public StairBlock(@NotNull SimpleHandrailBlock baseRail, class_4970.class_2251 settings) {
            super(baseRail, settings);
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
            class_4944 textures = ((SimpleHandrailBlock)this.baseHandrail).getTextures();
            class_2960 baseModelId = MishangucModels.createBlock("simple_handrail_stair_middle_center", class_4945.field_23011, class_4945.field_23015, class_4945.field_23014).method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
            for (HandrailStairBlock.Shape shape : HandrailStairBlock.Shape.values()) {
                for (HandrailStairBlock.Position position : HandrailStairBlock.Position.values()) {
                    MishangucModels.createBlock(String.format("simple_handrail_stair_%s_%s", shape.method_15434(), position.method_15434()), "_" + shape.method_15434() + "_" + position.method_15434(), class_4945.field_23011, class_4945.field_23015, class_4945.field_23014).method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
                }
            }
            blockStateModelGenerator.field_22830.accept(this.createBlockStates(baseModelId));
        }

        @Override
        public class_5250 method_9518() {
            class_2248 block = this.baseBlock();
            return block == null ? super.method_9518() : TextBridge.translatable("block.mishanguc.simple_handrail_stair", block.method_9518());
        }

        @Override
        protected MapCodec<? extends StairBlock> method_53969() {
            return CODEC;
        }
    }

    public static class OuterBlock
    extends HandrailOuterBlock<SimpleHandrailBlock> {
        public static final MapCodec<OuterBlock> CODEC = SimpleHandrailBlock.createSubCodec(b -> (SimpleHandrailBlock)b.baseHandrail, OuterBlock::new);

        public OuterBlock(@NotNull SimpleHandrailBlock baseRail, class_4970.class_2251 settings) {
            super(baseRail, settings);
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
            class_2960 modelId = MishangucModels.SIMPLE_HANDRAIL_OUTER.method_25846((class_2248)this, ((SimpleHandrailBlock)this.baseHandrail).getTextures(), blockStateModelGenerator.field_22831);
            blockStateModelGenerator.field_22830.accept(this.createBlockStates(modelId));
        }

        public class_5250 method_9518() {
            class_2248 block = this.baseBlock();
            return block == null ? super.method_9518() : TextBridge.translatable("block.mishanguc.simple_handrail_outer", block.method_9518());
        }

        @Override
        protected MapCodec<? extends OuterBlock> method_53969() {
            return CODEC;
        }
    }
}

