/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.block;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2446;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3981;
import net.minecraft.class_4538;
import net.minecraft.class_4910;
import net.minecraft.class_4916;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4970;
import net.minecraft.class_5797;
import net.minecraft.class_5819;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_807;
import org.jetbrains.annotations.NotNull;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.block.LightConnectable;
import pers.solid.mishang.uc.block.MishangucBlock;
import pers.solid.mishang.uc.data.MishangucModels;
import pers.solid.mishang.uc.data.MishangucTextureKeys;

public class WallLightBlock
extends class_2318
implements class_3737,
MishangucBlock {
    public static final MapCodec<WallLightBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("light_color").forGetter(b -> b.lightColor), (App)WallLightBlock.method_54096(), (App)Codec.BOOL.fieldOf("large_shape").forGetter(b -> b.largeShape)).apply((Applicative)instance, WallLightBlock::new));
    protected static final class_2746 WEST = class_2741.field_12527;
    protected static final class_2746 EAST = class_2741.field_12487;
    protected static final class_2746 SOUTH = class_2741.field_12540;
    protected static final class_2746 NORTH = class_2741.field_12489;
    protected static final class_2746 UP = class_2741.field_12519;
    protected static final class_2746 DOWN = class_2741.field_12546;
    protected static final BiMap<class_2350, class_2746> DIRECTION_TO_PROPERTY = new ImmutableBiMap.Builder().put((Object)class_2350.field_11039, (Object)WEST).put((Object)class_2350.field_11034, (Object)EAST).put((Object)class_2350.field_11035, (Object)SOUTH).put((Object)class_2350.field_11043, (Object)NORTH).put((Object)class_2350.field_11036, (Object)UP).put((Object)class_2350.field_11033, (Object)DOWN).build();
    private static final Map<class_2350, class_265> SHAPE_PER_DIRECTION = MishangUtils.createDirectionToShape(4.0, 0.0, 4.0, 12.0, 2.0, 12.0);
    private static final Map<class_2350, class_265> LARGE_SHAPE_PER_DIRECTION = MishangUtils.createDirectionToShape(2.0, 0.0, 2.0, 14.0, 2.0, 14.0);
    public final String lightColor;
    protected final boolean largeShape;

    public WallLightBlock(String lightColor, class_4970.class_2251 settings, boolean largeShape) {
        super(settings);
        this.lightColor = lightColor;
        this.largeShape = largeShape;
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)field_10927, (Comparable)class_2350.field_11036));
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_10927);
        class_2350 backDirection = facing.method_10153();
        class_2338 backPos = pos.method_10093(backDirection);
        class_265 centerShape = class_2248.method_9541((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0);
        class_2680 backState = world.method_8320(backPos);
        return !class_259.method_1074((class_265)backState.method_26222((class_1922)world, backPos).method_20538(facing), (class_265)centerShape, (class_247)class_247.field_16893) || !class_259.method_1074((class_265)backState.method_26220((class_1922)world, backPos).method_20538(facing), (class_265)centerShape, (class_247)class_247.field_16893);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_10927, class_2741.field_12508});
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            tickView.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)field_10927, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)field_10927)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657((class_2769)field_10927, (Comparable)mirror.method_10343((class_2350)state.method_11654((class_2769)field_10927)));
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 direction = ctx.method_8038();
        class_2680 blockState = ctx.method_8045().method_8320(ctx.method_8037().method_10093(direction.method_10153()));
        if (blockState.method_27852((class_2248)this)) {
            blockState.method_11654((class_2769)field_10927);
        }
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_10927, (Comparable)direction)).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(ctx.method_8045().method_8320(ctx.method_8037()).method_26227().method_15772() == class_3612.field_15910));
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return (this.largeShape ? LARGE_SHAPE_PER_DIRECTION : SHAPE_PER_DIRECTION).get(state.method_11654((class_2769)field_10927));
    }

    public void method_9517(class_2680 state, class_1936 world, class_2338 pos, int flags, int maxUpdateDepth) {
        super.method_9517(state, world, pos, flags, maxUpdateDepth);
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_10927);
        WallLightBlock wallLightBlock = this;
        if (wallLightBlock instanceof LightConnectable) {
            LightConnectable lightConnectable = (LightConnectable)((Object)wallLightBlock);
            lightConnectable.prepareConnection(state, world, pos, flags, maxUpdateDepth, facing);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
        class_2960 id = this.getModelType().method_25846((class_2248)this, this.getTextureMap(), blockStateModelGenerator.field_22831);
        class_4926.class_4927 map = class_4926.method_67869((class_2769)field_10927);
        map.method_25794((Comparable)class_2350.field_11036, (Object)class_4910.field_56780);
        map.method_25794((Comparable)class_2350.field_11033, (Object)class_4910.field_56783);
        map.method_25794((Comparable)class_2350.field_11035, (Object)class_4910.field_56784.then(class_4910.field_56780));
        map.method_25794((Comparable)class_2350.field_11039, (Object)class_4910.field_56784.then(class_4910.field_56785));
        map.method_25794((Comparable)class_2350.field_11043, (Object)class_4910.field_56784.then(class_4910.field_56786));
        map.method_25794((Comparable)class_2350.field_11034, (Object)class_4910.field_56784.then(class_4910.field_56787));
        blockStateModelGenerator.field_22830.accept(class_4925.method_67853((class_2248)this, (class_807)class_4910.method_67835((class_2960)id)).method_25775((class_4926)map).method_67856(class_4910.field_56781));
        blockStateModelGenerator.method_25623((class_2248)this, id);
    }

    protected class_4944 getTextureMap() {
        return class_4944.method_25883((class_4945)MishangucTextureKeys.LIGHT, (class_2960)MishangucModels.texture(this.lightColor + "_light"));
    }

    public class_4942 getModelType() {
        return this.getModelType("");
    }

    public class_4942 getModelType(String suffix) {
        class_2960 identifier = class_7923.field_41175.method_10221((Object)this);
        Object path = identifier.method_12832() + suffix;
        int i = this.lightColor.length();
        if (!((String)path).startsWith(this.lightColor) || ((String)path).charAt(i) != '_') {
            throw new AssertionError();
        }
        path = ((String)path).substring(i + 1);
        return MishangucModels.createBlock((String)path, suffix, MishangucTextureKeys.LIGHT);
    }

    @Override
    public class_5797 getCraftingRecipe(class_2446 recipeGenerator) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)this.method_8389());
        String itemPath = itemId.method_12832();
        if (itemPath.endsWith("_tube")) {
            int outputCount;
            @NotNull class_1792 fullLight = WallLightBlock.getBaseLight(itemId.method_12836(), this.lightColor, (class_2248)this);
            if (itemPath.contains("_small_")) {
                outputCount = 64;
            } else if (itemPath.contains("_medium_")) {
                outputCount = 32;
            } else if (itemPath.contains("_large_")) {
                outputCount = 16;
            } else if (itemPath.contains("_thin_strip_")) {
                outputCount = 36;
            } else if (itemPath.contains("_double_strip_")) {
                outputCount = 18;
            } else if (itemPath.contains("_thick_strip_")) {
                outputCount = 12;
            } else {
                throw new IllegalStateException(String.format("Can't generate recipes: Cannot determine the type of %s according to its id", this));
            }
            return class_3981.method_17969((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{fullLight}), (class_7800)class_7800.field_40635, (class_1935)this, (int)outputCount).method_17970(class_2446.method_32807((class_1935)fullLight), recipeGenerator.method_10426((class_1935)fullLight));
        }
        class_2960 tubeId = itemId.method_48331("_tube");
        @NotNull class_1792 tube = (class_1792)class_7923.field_41178.method_17966(tubeId).orElseThrow(() -> new IllegalArgumentException(String.format("Can't generate recipes: %s does not have a corresponding tube block (with id [%s])", this, tubeId)));
        return recipeGenerator.method_62750(class_7800.field_40635, (class_1935)this, 1).method_10454((class_1935)tube).method_10454((class_1935)class_1802.field_8333).method_10442(class_2446.method_32807((class_1935)tube), recipeGenerator.method_10426((class_1935)tube));
    }

    protected MapCodec<? extends WallLightBlock> method_53969() {
        return CODEC;
    }

    @NotNull
    public static class_1792 getBaseLight(String namespace, String lightColor, class_2248 self) {
        class_2960 fullLightId = class_2960.method_60655((String)namespace, (String)(lightColor + "_light"));
        return (class_1792)class_7923.field_41178.method_17966(fullLightId).orElseThrow(() -> new IllegalArgumentException(String.format("Can't generate recipes: %s does not have a corresponding base light block (with id [%s])", self, fullLightId)));
    }

    @Override
    public String customRecipeCategory() {
        return "light";
    }
}

