/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.blockentity;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.booleans.BooleanArraySet;
import it.unimi.dsi.fastutil.booleans.BooleanSet;
import it.unimi.dsi.fastutil.booleans.BooleanSets;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_9323;
import net.minecraft.class_9473;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import pers.solid.mishang.uc.blockentity.BlockEntityWithText;
import pers.solid.mishang.uc.blockentity.MishangucBlockEntities;
import pers.solid.mishang.uc.components.MishangucComponents;
import pers.solid.mishang.uc.text.TextContext;

@ApiStatus.AvailableSince(value="1.0.2")
public class StandingSignBlockEntity
extends BlockEntityWithText {
    public static final TextContext DEFAULT_TEXT_CONTEXT = (TextContext)class_156.method_654((Object)new TextContext(), textContext -> {
        textContext.size = 6.0f;
    });
    @NotNull
    public List<TextContext> frontTexts = ImmutableList.of();
    @NotNull
    public List<TextContext> backTexts = ImmutableList.of();
    @Nullable
    private class_1657 editor;
    @Nullable
    public Boolean editedSide;
    public BooleanSet waxed = BooleanSets.emptySet();
    public BooleanSet glowing = BooleanSets.emptySet();

    public StandingSignBlockEntity(class_2338 pos, class_2680 state) {
        super(MishangucBlockEntities.STANDING_SIGN_BLOCK_ENTITY, pos, state);
    }

    protected StandingSignBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        Codec<List<TextContext>> listCodec = TextContext.createListCodec(this::createDefaultTextContext);
        this.frontTexts = view.method_71426("frontTexts", listCodec).orElseGet(ImmutableList::of);
        this.backTexts = view.method_71426("backTexts", listCodec).orElseGet(ImmutableList::of);
        boolean frontWaxed = view.method_71433("frontWaxed", false);
        boolean backWaxed = view.method_71433("backWaxed", false);
        if (!frontWaxed && !backWaxed) {
            this.waxed = BooleanSets.emptySet();
        } else {
            this.waxed = new BooleanArraySet(2);
            if (frontWaxed) {
                this.waxed.add(true);
            }
            if (backWaxed) {
                this.waxed.add(false);
            }
        }
        boolean frontGlowing = view.method_71433("frontGlowing", false);
        boolean backGlowing = view.method_71433("backGlowing", false);
        if (!frontGlowing && !backGlowing) {
            this.glowing = BooleanSets.emptySet();
        } else {
            this.glowing = new BooleanArraySet(2);
            if (frontGlowing) {
                this.glowing.add(true);
            }
            if (backGlowing) {
                this.glowing.add(false);
            }
        }
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        Codec<List<TextContext>> listCodec = TextContext.createListCodec(this::createDefaultTextContext);
        view.method_71468("frontTexts", listCodec, this.frontTexts);
        view.method_71468("backTexts", listCodec, this.backTexts);
        view.method_71472("frontWaxed", this.waxed.contains(true));
        view.method_71472("backWaxed", this.waxed.contains(false));
        view.method_71472("frontGlowing", this.glowing.contains(true));
        view.method_71472("backGlowing", this.glowing.contains(false));
    }

    protected void method_57568(class_9473 components) {
        super.method_57568(components);
        this.frontTexts = (List)components.method_58695(MishangucComponents.FRONT_TEXTS, (Object)ImmutableList.of());
        this.backTexts = (List)components.method_58695(MishangucComponents.BACK_TEXTS, (Object)ImmutableList.of());
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(MishangucComponents.FRONT_TEXTS, this.frontTexts);
        componentMapBuilder.method_57840(MishangucComponents.BACK_TEXTS, this.backTexts);
    }

    public void method_57569(class_11372 view) {
        super.method_57569(view);
        view.method_71478("frontTexts");
        view.method_71478("backTexts");
    }

    @Override
    public @Range(from=0L, to=16L) float getHeight() {
        return 8.0f;
    }

    @Override
    public TextContext createDefaultTextContext() {
        return DEFAULT_TEXT_CONTEXT.clone();
    }

    @Override
    @Nullable
    public class_1657 getEditor() {
        return this.editor;
    }

    @Override
    public void setEditor(@Nullable class_1657 editor) {
        this.editor = editor;
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @Contract(pure=true)
    public List<TextContext> getTextsOnSide(boolean isFront) {
        return isFront ? this.frontTexts : this.backTexts;
    }

    @Contract(mutates="this")
    public void setTextsOnSide(boolean isFront, @NotNull List<TextContext> texts) {
        if (isFront) {
            this.frontTexts = texts;
        } else {
            this.backTexts = texts;
        }
    }
}

