/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.item;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.EnvironmentInterface;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.gamerule.v1.rule.EnumRule;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1508;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4538;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4844;
import net.minecraft.class_5552;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_8942;
import net.minecraft.class_9279;
import net.minecraft.class_9848;
import net.minecraft.class_9974;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.MishangucClient;
import pers.solid.mishang.uc.MishangucRules;
import pers.solid.mishang.uc.components.CarryingToolData;
import pers.solid.mishang.uc.components.MishangucComponents;
import pers.solid.mishang.uc.item.BlockToolItem;
import pers.solid.mishang.uc.item.InteractsWithEntity;
import pers.solid.mishang.uc.item.MishangucItem;
import pers.solid.mishang.uc.render.RendersBeforeOutline;
import pers.solid.mishang.uc.util.BlockPlacementContext;
import pers.solid.mishang.uc.util.TextBridge;
import pers.solid.mishang.uc.util.WithMishangTooltip;

@EnvironmentInterface(value=EnvType.CLIENT, itf=RendersBeforeOutline.class)
public class CarryingToolItem
extends BlockToolItem
implements MishangucItem,
InteractsWithEntity,
RendersBeforeOutline,
WithMishangTooltip {
    private static final int OUTLINE_COLOR_CYAN = class_9848.method_61318((float)0.8f, (float)0.0f, (float)1.0f, (float)1.0f);
    private static final int OUTLINE_COLOR_AO = class_9848.method_61318((float)0.5f, (float)0.0f, (float)0.5f, (float)1.0f);
    private static final int OUTLINE_COLOR_AKA = class_9848.method_61318((float)0.8f, (float)1.0f, (float)0.0f, (float)0.0f);
    private static final int OUTLINE_COLOR_ORANGE = class_9848.method_61318((float)0.5f, (float)1.0f, (float)0.5f, (float)0.0f);

    public CarryingToolItem(class_1792.class_1793 settings, @Nullable Boolean includesFluid) {
        super(settings, includesFluid);
    }

    @Contract(pure=true)
    @Nullable
    public static class_2680 getHoldingBlockState(@NotNull class_1799 stack, class_4538 world) {
        class_2680 class_26802;
        CarryingToolData carryingToolData = (CarryingToolData)stack.method_58694(MishangucComponents.CARRYING_TOOL_DATA);
        if (carryingToolData instanceof CarryingToolData.HoldingBlockState) {
            CarryingToolData.HoldingBlockState holdingBlockState = (CarryingToolData.HoldingBlockState)carryingToolData;
            class_26802 = holdingBlockState.state();
        } else {
            class_26802 = null;
        }
        return class_26802;
    }

    @Contract(mutates="param1")
    private static void setHoldingEntityUUID(class_1799 stack, UUID uuid) {
        class_2487 entityTag;
        CarryingToolData carryingToolData = (CarryingToolData)stack.method_58694(MishangucComponents.CARRYING_TOOL_DATA);
        if (carryingToolData instanceof CarryingToolData.HoldingEntity) {
            CarryingToolData.HoldingEntity holdingEntity = (CarryingToolData.HoldingEntity)carryingToolData;
            v0 = holdingEntity.entityTag().orElse(null);
        } else {
            v0 = entityTag = null;
        }
        if (entityTag != null) {
            entityTag.method_67494("UUID", class_4844.field_25122, (Object)uuid);
        }
    }

    @Contract(pure=true)
    @Nullable
    public static class_1297 createHoldingEntity(@NotNull CarryingToolData.HoldingEntity data, class_3218 world, class_1657 player) {
        class_1299<?> entityType = data.entityType();
        return entityType.method_5888(world, entity -> data.entityTag().ifPresent(nbtCompound -> class_9279.method_57456((class_2487)nbtCompound).method_57445(entity)), player.method_24515(), class_3730.field_16467, false, false);
    }

    private static class_2561 getEntityName(@NotNull class_1799 stack) {
        CarryingToolData carryingToolData = (CarryingToolData)stack.method_58694(MishangucComponents.CARRYING_TOOL_DATA);
        if (carryingToolData instanceof CarryingToolData.HoldingEntity) {
            CarryingToolData.HoldingEntity holdingEntity = (CarryingToolData.HoldingEntity)carryingToolData;
            return holdingEntity.name();
        }
        return TextBridge.empty();
    }

    public class_2561 method_7864(class_1799 stack) {
        class_2561 name = super.method_7864(stack);
        CarryingToolData carryingToolData = (CarryingToolData)stack.method_58694(MishangucComponents.CARRYING_TOOL_DATA);
        if (carryingToolData instanceof CarryingToolData.HoldingEntity) {
            CarryingToolData.HoldingEntity holdingEntity = (CarryingToolData.HoldingEntity)carryingToolData;
            return TextBridge.translatable("item.mishanguc.carrying_tool.holding", name, holdingEntity.name());
        }
        if (carryingToolData instanceof CarryingToolData.HoldingBlockState) {
            CarryingToolData.HoldingBlockState holdingBlockState = (CarryingToolData.HoldingBlockState)carryingToolData;
            return TextBridge.translatable("item.mishanguc.carrying_tool.holding", name, holdingBlockState.state().method_26204().method_9518());
        }
        return TextBridge.translatable("item.mishanguc.carrying_tool.empty", name);
    }

    @Override
    public void getMishangTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.tooltip.1").method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.tooltip.2").method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.tooltip.3").method_27692(class_124.field_1080));
    }

    @Override
    public class_1269 useOnBlock(class_1799 stack, class_1657 player, class_1937 world, class_3965 blockHitResult, class_1268 hand, boolean fluidIncluded) {
        if (!this.hasAccess(player, world, true)) {
            return class_1269.field_5811;
        }
        CarryingToolData carryingToolData = (CarryingToolData)stack.method_58694(MishangucComponents.CARRYING_TOOL_DATA);
        if (carryingToolData instanceof CarryingToolData.HoldingBlockState) {
            BlockPlacementContext blockPlacementContext = new BlockPlacementContext(world, blockHitResult.method_17777(), player, stack, blockHitResult, fluidIncluded);
            if (blockPlacementContext.canPlace()) {
                blockPlacementContext.setBlockState(3);
                blockPlacementContext.setBlockEntity();
                if (world.field_9236) {
                    blockPlacementContext.playSound();
                } else {
                    player.method_7353((class_2561)TextBridge.translatable(player.method_68878() ? "item.mishanguc.carrying_tool.message.placed_creative" : "item.mishanguc.carrying_tool.message.placed", blockPlacementContext.stateToPlace.method_26204().method_9518()), true);
                }
                if (!player.method_68878()) {
                    stack.method_57381(MishangucComponents.CARRYING_TOOL_DATA);
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        if (carryingToolData instanceof CarryingToolData.HoldingEntity) {
            CarryingToolData.HoldingEntity holdingEntity = (CarryingToolData.HoldingEntity)carryingToolData;
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                class_1297 entity = CarryingToolItem.createHoldingEntity(holdingEntity, serverWorld, player);
                if (entity == null) {
                    return class_1269.field_5811;
                }
                class_243 pos = blockHitResult.method_17784();
                entity.method_30634(pos.field_1352, pos.field_1351, pos.field_1350);
                boolean spawnEntity = world.method_8649(entity);
                if (spawnEntity) {
                    player.method_7353((class_2561)TextBridge.translatable(player.method_68878() ? "item.mishanguc.carrying_tool.message.spawned_creative" : "item.mishanguc.carrying_tool.message.spawned", CarryingToolItem.getEntityName(stack)), true);
                    if (!player.method_68878()) {
                        stack.method_57381(MishangucComponents.CARRYING_TOOL_DATA);
                    } else {
                        CarryingToolItem.setHoldingEntityUUID(stack, class_3532.method_15394());
                    }
                    return class_1269.field_5812;
                }
                return class_1269.field_5814;
            }
            return class_1269.field_5812;
        }
        class_2680 blockState = world.method_8320(blockHitResult.method_17777());
        class_1269 actionResult = blockState.method_55781(world, player, blockHitResult);
        if (actionResult.method_23665()) {
            return actionResult;
        }
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.no_placing").method_27692(class_124.field_1061), true);
        return class_1269.field_5814;
    }

    private boolean hasAccess(class_1657 player, class_1937 world, boolean warn) {
        if (!(world instanceof class_3218)) {
            return MishangucClient.CLIENT_CARRYING_TOOL_ACCESS.get().hasAccess(player);
        }
        class_3218 serverWorld = (class_3218)world;
        MishangucRules.ToolAccess toolAccess = (MishangucRules.ToolAccess)((EnumRule)serverWorld.method_64395().method_20746(MishangucRules.CARRYING_TOOL_ACCESS)).get();
        return toolAccess.hasAccess(player, warn);
    }

    @Override
    public class_1269 beginAttackBlock(class_1799 stack, class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction, boolean fluidIncluded) {
        class_2680 removed;
        if (!this.hasAccess(player, world, true)) {
            return class_1269.field_5811;
        }
        CarryingToolData carryingToolData = (CarryingToolData)stack.method_58694(MishangucComponents.CARRYING_TOOL_DATA);
        if (carryingToolData instanceof CarryingToolData.HoldingBlockState) {
            CarryingToolData.HoldingBlockState holdingBlockState = (CarryingToolData.HoldingBlockState)carryingToolData;
            if (!player.method_68878()) {
                if (!world.field_9236) {
                    player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.no_picking", Optional.of(holdingBlockState.state().method_26204()).map(class_2248::method_9518).orElse(TextBridge.empty())).method_27692(class_124.field_1061), true);
                    return class_1269.field_5814;
                }
                return class_1269.field_21466;
            }
        }
        if (carryingToolData instanceof CarryingToolData.HoldingEntity) {
            CarryingToolData.HoldingEntity holdingEntity = (CarryingToolData.HoldingEntity)carryingToolData;
            if (!player.method_68878()) {
                if (world.field_9236) {
                    return class_1269.field_21466;
                }
                player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.no_picking", holdingEntity.name()).method_27692(class_124.field_1061), true);
                return class_1269.field_5814;
            }
        }
        if ((removed = world.method_8320(pos)).method_26204() instanceof class_5552 && !player.method_64475(2)) {
            return class_1269.field_5814;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity != null) {
            stack.method_57379(MishangucComponents.CARRYING_TOOL_DATA, (Object)new CarryingToolData.HoldingBlockState(removed, Optional.of(blockEntity.method_58692((class_7225.class_7874)world.method_30349()))));
        } else {
            stack.method_57379(MishangucComponents.CARRYING_TOOL_DATA, (Object)new CarryingToolData.HoldingBlockState(removed, Optional.empty()));
        }
        world.method_8544(pos);
        world.method_8501(pos, class_2246.field_10124.method_9564());
        if (world.field_9236) {
            world.method_20290(2001, pos, class_2248.method_9507((class_2680)removed));
        }
        if (!world.field_9236) {
            if (carryingToolData instanceof CarryingToolData.HoldingEntity) {
                CarryingToolData.HoldingEntity holdingEntity = (CarryingToolData.HoldingEntity)carryingToolData;
                player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.picked_overriding", holdingEntity.name()), true);
            } else if (carryingToolData instanceof CarryingToolData.HoldingBlockState) {
                CarryingToolData.HoldingBlockState holdingBlockState = (CarryingToolData.HoldingBlockState)carryingToolData;
                player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.picked_overriding", removed.method_26204().method_9518(), holdingBlockState.state().method_26204().method_9518()), true);
            } else {
                player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.pick", removed.method_26204().method_9518()), true);
            }
        }
        return class_1269.field_5812;
    }

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1269 use = super.method_7836(world, user, hand);
        if (use.method_23665() || !this.hasAccess(user, world, true)) {
            return use;
        }
        class_1799 stack = user.method_5998(hand);
        CarryingToolData carryingToolData = (CarryingToolData)stack.method_58694(MishangucComponents.CARRYING_TOOL_DATA);
        if (carryingToolData instanceof CarryingToolData.HoldingBlockState) {
            CarryingToolData.HoldingBlockState holdingBlockState = (CarryingToolData.HoldingBlockState)carryingToolData;
            class_2680 state = holdingBlockState.state();
            if (state.method_26204() instanceof class_5552 && !user.method_64475(2)) {
                return class_1269.field_5814;
            }
            if (world.field_9236) {
                return class_1269.field_5812;
            }
            class_1540 fallingBlockEntity = new class_1540(class_1299.field_6089, world);
            class_2487 nbt = new class_2487();
            nbt.method_67494("BlockState", class_2680.field_24734, (Object)state);
            class_9279.method_57456((class_2487)nbt).method_57445((class_1297)fallingBlockEntity);
            class_243 eyePos = user.method_33571();
            fallingBlockEntity.method_5641(eyePos.field_1352, eyePos.field_1351, eyePos.field_1350, user.method_36454(), user.method_36455());
            fallingBlockEntity.method_18799(class_243.method_1030((float)user.method_36455(), (float)user.method_36454()).method_1021(2.0).method_1019(user.method_18798()));
            fallingBlockEntity.field_7193 = true;
            fallingBlockEntity.field_7194 = holdingBlockState.blockEntityTag().orElse(null);
            fallingBlockEntity.method_6965(state.method_26204().method_9520(), Integer.MAX_VALUE);
            boolean spawnEntity = world.method_8649((class_1297)fallingBlockEntity);
            if (spawnEntity) {
                if (!user.method_68878()) {
                    stack.method_57381(MishangucComponents.CARRYING_TOOL_DATA);
                }
                user.method_7353((class_2561)TextBridge.translatable(user.method_68878() ? "item.mishanguc.carrying_tool.message.block_thrown_creative" : "item.mishanguc.carrying_tool.message.block_thrown", state.method_26204().method_9518()), true);
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }
        if (carryingToolData instanceof CarryingToolData.HoldingEntity) {
            CarryingToolData.HoldingEntity holdingEntity = (CarryingToolData.HoldingEntity)carryingToolData;
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                class_1297 entity = CarryingToolItem.createHoldingEntity(holdingEntity, serverWorld, user);
                if (entity == null) {
                    return use;
                }
                class_243 pos = user.method_19538();
                entity.method_5641(pos.field_1352, pos.field_1351, pos.field_1350, user.method_36454(), user.method_36455());
                entity.method_18799(class_243.method_1030((float)user.method_36455(), (float)user.method_36454()).method_1021(2.0).method_1019(user.method_18798()));
                boolean spawnEntity = world.method_8649(entity);
                if (spawnEntity) {
                    user.method_7353((class_2561)TextBridge.translatable(user.method_68878() ? "item.mishanguc.carrying_tool.message.entity_thrown_creative" : "item.mishanguc.carrying_tool.message.entity_thrown", CarryingToolItem.getEntityName(stack)), true);
                    if (!user.method_68878()) {
                        stack.method_57381(MishangucComponents.CARRYING_TOOL_DATA);
                    } else {
                        CarryingToolItem.setHoldingEntityUUID(stack, class_3532.method_15394());
                    }
                    return class_1269.field_5812;
                }
                return class_1269.field_5814;
            }
            return class_1269.field_5812;
        }
        return use;
    }

    @Override
    @NotNull
    public class_1269 attackEntityCallback(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        if (!this.hasAccess(player, world, true) || player.method_7325()) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        CarryingToolData carryingToolData = (CarryingToolData)stack.method_58694(MishangucComponents.CARRYING_TOOL_DATA);
        if (entity instanceof class_1657) {
            if (world.field_9236) {
                return class_1269.field_5811;
            }
            player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.pick_player").method_27692(class_124.field_1061), false);
            return class_1269.field_5814;
        }
        if (carryingToolData instanceof CarryingToolData.HoldingEntity) {
            CarryingToolData.HoldingEntity holdingEntity = (CarryingToolData.HoldingEntity)carryingToolData;
            if (!player.method_68878()) {
                if (world.field_9236) {
                    return class_1269.field_5812;
                }
                player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.no_picking", holdingEntity.name()).method_27692(class_124.field_1061), true);
                return class_1269.field_5814;
            }
        }
        if (carryingToolData instanceof CarryingToolData.HoldingBlockState) {
            CarryingToolData.HoldingBlockState holdingBlockState = (CarryingToolData.HoldingBlockState)carryingToolData;
            if (!player.method_68878()) {
                if (world.field_9236) {
                    return class_1269.field_5812;
                }
                player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.no_picking", Optional.ofNullable(holdingBlockState.state().method_26204()).map(class_2248::method_9518).orElse(TextBridge.empty())).method_27692(class_124.field_1061), true);
                return class_1269.field_5814;
            }
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (carryingToolData instanceof CarryingToolData.HoldingEntity) {
                CarryingToolData.HoldingEntity holdingEntity = (CarryingToolData.HoldingEntity)carryingToolData;
                player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.pick_entity_overriding", entity.method_5477(), holdingEntity.name()), true);
            } else if (carryingToolData instanceof CarryingToolData.HoldingBlockState) {
                CarryingToolData.HoldingBlockState holdingBlockState = (CarryingToolData.HoldingBlockState)carryingToolData;
                player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.pick_entity_overriding", entity.method_5477(), holdingBlockState.state().method_26204().method_9518()), true);
            } else {
                player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.pick_entity", entity.method_5477()), true);
            }
            class_11362 nbtWriteView = class_11362.method_71459((class_8942)class_8942.field_60348, (class_7225.class_7874)entity.method_56673());
            entity.method_5647((class_11372)nbtWriteView);
            stack.method_57379(MishangucComponents.CARRYING_TOOL_DATA, (Object)new CarryingToolData.HoldingEntity(entity.method_5864(), Optional.of(nbtWriteView.method_71475()), entity.method_5477(), entity.method_17681(), entity.method_17682()));
            entity.method_5650(class_1297.class_5529.field_26999);
            if (entity instanceof class_1508) {
                class_1508 enderDragonPart = (class_1508)entity;
                enderDragonPart.field_7007.method_5768(serverWorld);
            }
        }
        return class_1269.field_5812;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlockOutline(class_1657 player, class_1799 itemStack, WorldRenderContext worldRenderContext, WorldRenderContext.BlockOutlineContext blockOutlineContext, class_1268 hand) {
        BlockPlacementContext blockPlacementContext;
        if (!this.hasAccess(player, (class_1937)worldRenderContext.world(), true)) {
            return true;
        }
        class_310 client = class_310.method_1551();
        class_4597 consumers = worldRenderContext.consumers();
        if (consumers == null) {
            return true;
        }
        class_4588 vertexConsumer = consumers.getBuffer((class_1921)class_1921.field_21695);
        class_4587 matrices = worldRenderContext.matrixStack();
        class_239 crosshairTarget = client.field_1765;
        if (!(crosshairTarget instanceof class_3965)) {
            return true;
        }
        class_3965 blockHitResult = (class_3965)crosshairTarget;
        boolean includesFluid = this.includesFluid(itemStack, player.method_5715());
        class_2338 pos = blockOutlineContext.blockPos();
        CarryingToolData carryingToolData = (CarryingToolData)itemStack.method_58694(MishangucComponents.CARRYING_TOOL_DATA);
        if (carryingToolData instanceof CarryingToolData.HoldingBlockState && (blockPlacementContext = new BlockPlacementContext((class_1937)worldRenderContext.world(), pos, player, itemStack, blockHitResult, includesFluid)).canPlace()) {
            class_9974.method_62296((class_4587)matrices, (class_4588)vertexConsumer, (class_265)blockPlacementContext.stateToPlace.method_26172((class_1922)blockPlacementContext.world, blockPlacementContext.posToPlace, class_3726.method_16195((class_1297)player)), (double)((double)blockPlacementContext.posToPlace.method_10263() - blockOutlineContext.cameraX()), (double)((double)blockPlacementContext.posToPlace.method_10264() - blockOutlineContext.cameraY()), (double)((double)blockPlacementContext.posToPlace.method_10260() - blockOutlineContext.cameraZ()), (int)OUTLINE_COLOR_CYAN);
            class_9974.method_62296((class_4587)matrices, (class_4588)vertexConsumer, (class_265)blockPlacementContext.stateToPlace.method_26227().method_17776((class_1922)blockPlacementContext.world, blockPlacementContext.posToPlace), (double)((double)blockPlacementContext.posToPlace.method_10263() - blockOutlineContext.cameraX()), (double)((double)blockPlacementContext.posToPlace.method_10264() - blockOutlineContext.cameraY()), (double)((double)blockPlacementContext.posToPlace.method_10260() - blockOutlineContext.cameraZ()), (int)OUTLINE_COLOR_AO);
        }
        if (hand == class_1268.field_5808 && (carryingToolData == null || player.method_68878())) {
            class_2680 hitState = worldRenderContext.world().method_8320(pos);
            class_9974.method_62296((class_4587)matrices, (class_4588)vertexConsumer, (class_265)hitState.method_26172((class_1922)worldRenderContext.world(), pos, class_3726.method_16195((class_1297)player)), (double)((double)pos.method_10263() - blockOutlineContext.cameraX()), (double)((double)pos.method_10264() - blockOutlineContext.cameraY()), (double)((double)pos.method_10260() - blockOutlineContext.cameraZ()), (int)OUTLINE_COLOR_AKA);
            class_9974.method_62296((class_4587)matrices, (class_4588)vertexConsumer, (class_265)hitState.method_26227().method_17776((class_1922)worldRenderContext.world(), pos), (double)((double)pos.method_10263() - blockOutlineContext.cameraX()), (double)((double)pos.method_10264() - blockOutlineContext.cameraY()), (double)((double)pos.method_10260() - blockOutlineContext.cameraZ()), (int)OUTLINE_COLOR_ORANGE);
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBeforeOutline(WorldRenderContext context, class_239 hitResult, class_746 player, class_1268 hand) {
        if (hand != class_1268.field_5808 || player.method_7325() || !this.hasAccess((class_1657)player, (class_1937)context.world(), true)) {
            return;
        }
        class_1799 stack = player.method_6047();
        class_4597 consumers = context.consumers();
        class_4587 matrices = context.matrixStack();
        if (consumers == null) {
            return;
        }
        class_4588 vertexConsumer = consumers.getBuffer(class_1921.method_23594());
        class_243 cameraPos = context.camera().method_19326();
        CarryingToolData carryingToolData = (CarryingToolData)stack.method_58694(MishangucComponents.CARRYING_TOOL_DATA);
        if (hitResult.method_17783() == class_239.class_240.field_1332 && carryingToolData instanceof CarryingToolData.HoldingEntity) {
            CarryingToolData.HoldingEntity holdingEntity = (CarryingToolData.HoldingEntity)carryingToolData;
            float width = holdingEntity.width();
            float height = holdingEntity.height();
            class_243 pos = hitResult.method_17784();
            class_9974.method_62296((class_4587)matrices, (class_4588)vertexConsumer, (class_265)class_259.method_1081((double)(pos.field_1352 - (double)(width / 2.0f)), (double)pos.field_1351, (double)(pos.field_1350 - (double)(width / 2.0f)), (double)(pos.field_1352 + (double)(width / 2.0f)), (double)(pos.field_1351 + (double)height), (double)(pos.field_1350 + (double)(width / 2.0f))), (double)(-cameraPos.field_1352), (double)(-cameraPos.field_1351), (double)(-cameraPos.field_1350), (int)OUTLINE_COLOR_CYAN);
        }
        if (!player.method_68878() && carryingToolData != null) {
            return;
        }
        if (hitResult instanceof class_3966) {
            class_3966 entityHitResult = (class_3966)hitResult;
            class_1297 entity = entityHitResult.method_17782();
            class_9974.method_62296((class_4587)matrices, (class_4588)vertexConsumer, (class_265)class_259.method_1078((class_238)entity.method_5829()), (double)(-cameraPos.field_1352), (double)(-cameraPos.field_1351), (double)(-cameraPos.field_1350), (int)OUTLINE_COLOR_AKA);
        }
    }
}

