/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.item;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10712;
import net.minecraft.class_11352;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.block.ColoredBlock;
import pers.solid.mishang.uc.blockentity.ColoredBlockEntity;
import pers.solid.mishang.uc.components.MishangucComponents;
import pers.solid.mishang.uc.item.BlockToolItem;
import pers.solid.mishang.uc.item.MishangucItem;
import pers.solid.mishang.uc.util.ColorMixtureType;
import pers.solid.mishang.uc.util.TextBridge;
import pers.solid.mishang.uc.util.WithMishangTooltip;

public class ColorToolItem
extends BlockToolItem
implements MishangucItem,
WithMishangTooltip {
    public ColorToolItem(class_1792.class_1793 settings, @Nullable Boolean includesFluid) {
        super(settings, includesFluid);
    }

    public class_2561 method_7864(class_1799 stack) {
        Integer color = (Integer)stack.method_58694(MishangucComponents.COLOR);
        Float opacity = (Float)stack.method_58695(MishangucComponents.OPACITY, (Object)Float.valueOf(1.0f));
        ColorMixtureType mixtureType = (ColorMixtureType)((Object)stack.method_58695(MishangucComponents.COLOR_MIXTURE_TYPE, (Object)ColorMixtureType.NORMAL));
        ArrayList<class_5250> propertyTexts = new ArrayList<class_5250>();
        if (!opacity.equals(Float.valueOf(1.0f))) {
            propertyTexts.add(TextBridge.translatable("item.mishanguc.color_tool.properties.opacity", String.format("%.2f", opacity)));
        }
        if (color != null) {
            propertyTexts.add(TextBridge.translatable("item.mishanguc.color_tool.properties.color", MishangUtils.describeColor(color)));
        }
        if (mixtureType != ColorMixtureType.NORMAL) {
            propertyTexts.add(TextBridge.translatable("item.mishanguc.color_tool.properties.mixture_type", mixtureType.getName()));
        }
        if (propertyTexts.isEmpty()) {
            return super.method_7864(stack);
        }
        return TextBridge.translatable("item.mishanguc.color_tool.properties", super.method_7864(stack), class_2564.method_37112(propertyTexts, (class_2561)class_2564.field_33538));
    }

    @Override
    public void getMishangTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        Float opacity;
        class_10712 displayComponent = (class_10712)stack.method_58695(class_9334.field_56400, (Object)class_10712.field_56318);
        Integer color = (Integer)stack.method_58694(MishangucComponents.COLOR);
        ColorMixtureType mixtureType = (ColorMixtureType)((Object)stack.method_58695(MishangucComponents.COLOR_MIXTURE_TYPE, (Object)ColorMixtureType.NORMAL));
        if (mixtureType.requiresTargetColor()) {
            tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.color_tool.tooltip.1", TextBridge.keybind("key.attack").method_27694(style -> style.method_36139(0xDDDDDD))).method_27692(class_124.field_1080));
        }
        switch (mixtureType) {
            case HUE_ROTATE: {
                tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.color_tool.tooltip.hue_rotate", TextBridge.keybind("key.use").method_27694(style -> style.method_36139(0xDDDDDD))).method_27692(class_124.field_1080));
                break;
            }
            case SATURATION_CHANGE: {
                tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.color_tool.tooltip.saturation", TextBridge.keybind("key.use").method_27694(style -> style.method_36139(0xDDDDDD))).method_27692(class_124.field_1080));
                break;
            }
            case BRIGHTNESS_CHANGE: {
                tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.color_tool.tooltip.brightness", TextBridge.keybind("key.use").method_27694(style -> style.method_36139(0xDDDDDD))).method_27692(class_124.field_1080));
                break;
            }
            default: {
                tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.color_tool.tooltip.2", TextBridge.keybind("key.use").method_27694(style -> style.method_36139(0xDDDDDD))).method_27692(class_124.field_1080));
            }
        }
        if (mixtureType.hasInvertEffect()) {
            tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.color_tool.tooltip.invert_when_sneaking").method_27692(class_124.field_1080));
        }
        if (color != null && displayComponent.method_67214(MishangucComponents.COLOR)) {
            Color colorObject = new Color(color);
            tooltip.add((class_2561)TextBridge.translatable("block.mishanguc.colored_block.tooltip.color", MishangUtils.describeColor(color)).method_27692(class_124.field_1080));
            tooltip.add((class_2561)TextBridge.translatable("block.mishanguc.colored_block.tooltip.color_components", colorObject.getRed(), colorObject.getGreen(), colorObject.getBlue(), colorObject.getAlpha()).method_27692(class_124.field_1080));
        }
        if (!(opacity = (Float)stack.method_58695(MishangucComponents.OPACITY, (Object)Float.valueOf(1.0f))).equals(Float.valueOf(1.0f)) && displayComponent.method_67214(MishangucComponents.OPACITY)) {
            tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.color_tool.tooltip.opacity", opacity).method_27692(class_124.field_1080));
        }
        if (displayComponent.method_67214(MishangucComponents.COLOR_MIXTURE_TYPE)) {
            tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.color_tool.tooltip.mixture_type", mixtureType.getName()).method_27692(class_124.field_1080));
        }
    }

    @Override
    public class_1269 useOnBlock(class_1799 stack, class_1657 player, class_1937 world, class_3965 blockHitResult, class_1268 hand, boolean fluidIncluded) {
        ColoredBlockEntity coloredBlockEntity;
        class_2338 blockPos = blockHitResult.method_17777();
        class_2586 blockEntity = world.method_8321(blockPos);
        Integer color = (Integer)stack.method_58694(MishangucComponents.COLOR);
        ColorMixtureType mixtureType = (ColorMixtureType)((Object)stack.method_58695(MishangucComponents.COLOR_MIXTURE_TYPE, (Object)ColorMixtureType.NORMAL));
        if (color == null && mixtureType.requiresTargetColor()) {
            if (!world.field_9236) {
                player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.color_tool.message.no_data").method_27692(class_124.field_1061), true);
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        }
        int prevColorRgb = 0;
        if (!(blockEntity instanceof ColoredBlockEntity)) {
            class_2680 blockState = world.method_8320(blockPos);
            class_2248 block = blockState.method_26204();
            class_2248 coloredBlock = ColoredBlock.BASE_TO_COLORED.containsKey((Object)block) ? (class_2248)ColoredBlock.BASE_TO_COLORED.get((Object)block) : (class_2248)ColoredBlock.BASE_TAG_TO_COLORED.entrySet().stream().filter(entry -> blockState.method_26164((class_6862)entry.getKey())).findAny().map(Map.Entry::getValue).orElse(null);
            if (!(coloredBlock == null || mixtureType == ColorMixtureType.RANDOM && world.field_9236)) {
                prevColorRgb = blockState.method_26205((class_1922)world, (class_2338)blockPos).field_16011;
                class_2680 coloredState = coloredBlock.method_34725(blockState);
                world.method_8501(blockPos, coloredState);
                class_2586 oldBlockEntity = blockEntity;
                blockEntity = world.method_8321(blockPos);
                if (oldBlockEntity != null && blockEntity != null) {
                    blockEntity.method_58690(class_11352.method_71417(null, (class_7225.class_7874)world.method_30349(), (class_2487)oldBlockEntity.method_38244((class_7225.class_7874)world.method_30349())));
                }
            }
        } else {
            coloredBlockEntity = (ColoredBlockEntity)blockEntity;
            prevColorRgb = coloredBlockEntity.getColor();
        }
        if (blockEntity instanceof ColoredBlockEntity) {
            coloredBlockEntity = (ColoredBlockEntity)blockEntity;
            Float opacity = (Float)stack.method_58695(MishangucComponents.OPACITY, (Object)Float.valueOf(1.0f));
            float amount = ((Float)stack.method_58695(MishangucComponents.COLOR_CHANGE_AMOUNT, (Object)Float.valueOf(0.05f))).floatValue() * (float)(player.method_5715() ? -1 : 1);
            int target = mixtureType.handle(prevColorRgb, color == null ? 0 : color, amount, world.method_8409());
            if (mixtureType != ColorMixtureType.RANDOM || !world.field_9236) {
                int mixed;
                if (opacity.equals(Float.valueOf(1.0f))) {
                    mixed = target;
                    coloredBlockEntity.setColor(mixed);
                } else {
                    Color prevColor = new Color(prevColorRgb);
                    Color targetColor = new Color(target);
                    Color mixedColor = new Color(class_3532.method_48781((float)opacity.floatValue(), (int)prevColor.getRed(), (int)targetColor.getRed()), class_3532.method_48781((float)opacity.floatValue(), (int)prevColor.getGreen(), (int)targetColor.getGreen()), class_3532.method_48781((float)opacity.floatValue(), (int)prevColor.getBlue(), (int)targetColor.getBlue()), 0);
                    mixed = mixedColor.getRGB();
                    coloredBlockEntity.setColor(mixed);
                }
                blockEntity.method_5431();
                if (!world.field_9236) {
                    world.method_8413(blockPos, blockEntity.method_11010(), blockEntity.method_11010(), 2);
                    world.method_8396(null, blockPos, class_3417.field_28391, class_3419.field_15245, 1.0f, 1.0f);
                    player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.color_tool.message.success_set", MishangUtils.describeColor(mixed)), true);
                }
            }
            stack.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)hand));
            return class_1269.field_5812;
        }
        if (!world.field_9236) {
            player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.color_tool.message.not_colored").method_27692(class_124.field_1061), true);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    @Override
    public class_1269 beginAttackBlock(class_1799 stack, class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction, boolean fluidIncluded) {
        int color;
        ColorMixtureType mixtureType = (ColorMixtureType)((Object)stack.method_58695(MishangucComponents.COLOR_MIXTURE_TYPE, (Object)ColorMixtureType.NORMAL));
        if (!mixtureType.requiresTargetColor()) {
            return class_1269.field_5812;
        }
        class_2680 blockState = world.method_8320(pos);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof ColoredBlockEntity) {
            ColoredBlockEntity coloredBlockEntity = (ColoredBlockEntity)blockEntity;
            color = coloredBlockEntity.getColor();
        } else {
            color = blockState.method_26205((class_1922)world, (class_2338)pos).field_16011;
        }
        stack.method_57379(MishangucComponents.COLOR, (Object)color);
        if (!world.field_9236) {
            player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.color_tool.message.success_copied", MishangUtils.describeColor(color)), true);
        }
        return null;
    }

    public void appendToEntries(class_1761.class_7704 entries) {
        entries.method_45420(this.createStack(1.0f, ColorMixtureType.NORMAL, null));
        entries.method_45420(this.createStack(0.5f, ColorMixtureType.NORMAL, null));
        entries.method_45420(this.createStack(0.25f, ColorMixtureType.NORMAL, null));
        entries.method_45420(this.createStack(0.1f, ColorMixtureType.NORMAL, null));
        entries.method_45420(this.createStack(1.0f, ColorMixtureType.RANDOM, null));
        entries.method_45420(this.createStack(1.0f, ColorMixtureType.INVERT, null));
        entries.method_45420(this.createStack(1.0f, ColorMixtureType.HUE, null));
        entries.method_45420(this.createStack(1.0f, ColorMixtureType.HUE_AND_SATURATION, null));
        entries.method_45420(this.createStack(1.0f, ColorMixtureType.HUE_ROTATE, Float.valueOf(0.041666668f)));
        entries.method_45420(this.createStack(1.0f, ColorMixtureType.SATURATION_CHANGE, Float.valueOf(0.1f)));
        entries.method_45420(this.createStack(1.0f, ColorMixtureType.BRIGHTNESS_CHANGE, Float.valueOf(0.1f)));
    }

    private class_1799 createStack(float opacity, ColorMixtureType mixtureType, @Nullable Float amount) {
        class_1799 defaultStack = this.method_7854();
        defaultStack.method_57379(MishangucComponents.OPACITY, (Object)Float.valueOf(opacity));
        defaultStack.method_57379(MishangucComponents.COLOR_MIXTURE_TYPE, (Object)mixtureType);
        defaultStack.method_57379(MishangucComponents.COLOR_CHANGE_AMOUNT, (Object)amount);
        return defaultStack;
    }
}

