/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.item;

import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3513;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5552;
import net.minecraft.class_638;
import net.minecraft.class_9848;
import net.minecraft.class_9974;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.components.FastBuildingToolData;
import pers.solid.mishang.uc.components.MishangucComponents;
import pers.solid.mishang.uc.item.BlockToolItem;
import pers.solid.mishang.uc.item.HotbarScrollInteraction;
import pers.solid.mishang.uc.util.BlockMatchingRule;
import pers.solid.mishang.uc.util.BlockPlacementContext;
import pers.solid.mishang.uc.util.TextBridge;
import pers.solid.mishang.uc.util.WithMishangTooltip;

public class FastBuildingToolItem
extends BlockToolItem
implements HotbarScrollInteraction,
WithMishangTooltip {
    private static final class_3513<BlockMatchingRule> RULES_TO_CYCLE = (class_3513)class_156.method_654((Object)class_3513.method_37913((int)4), map -> {
        map.method_15225((Object)BlockMatchingRule.SAME_STATE);
        map.method_15225((Object)BlockMatchingRule.SAME_BLOCK);
        map.method_15225((Object)BlockMatchingRule.SAME_MATERIAL);
        map.method_15225((Object)BlockMatchingRule.ANY);
    });

    public FastBuildingToolItem(class_1792.class_1793 settings, @Nullable Boolean includesFluid) {
        super(settings.method_57349(MishangucComponents.FAST_BUILDING_TOOL_DATA, (Object)FastBuildingToolData.DEFAULT), includesFluid);
    }

    @Override
    public class_1269 useOnBlock(class_1799 stack, class_1657 player, class_1937 world, class_3965 blockHitResult, class_1268 hand, boolean fluidIncluded) {
        if (!player.method_68878()) {
            return class_1269.field_5811;
        }
        class_2350 side = blockHitResult.method_17780();
        class_2338 centerBlockPos = blockHitResult.method_17777();
        class_2680 centerState = world.method_8320(centerBlockPos);
        BlockPlacementContext blockPlacementContext = new BlockPlacementContext(world, centerBlockPos, player, stack, blockHitResult, fluidIncluded);
        FastBuildingToolData data = (FastBuildingToolData)stack.method_58695(MishangucComponents.FAST_BUILDING_TOOL_DATA, (Object)FastBuildingToolData.DEFAULT);
        int range = data.range();
        BlockMatchingRule matchingRule = data.matchingRule();
        boolean soundPlayed = false;
        for (class_2338 pos : matchingRule.getPlainValidBlockPoss(world, centerBlockPos, side, range)) {
            BlockPlacementContext offsetBlockPlacementContext;
            class_2680 state = world.method_8320(pos);
            if (!matchingRule.match(centerState, state) || !(offsetBlockPlacementContext = new BlockPlacementContext(blockPlacementContext, pos)).canPlace() || !offsetBlockPlacementContext.canReplace()) continue;
            if (!world.field_9236) {
                offsetBlockPlacementContext.setBlockState(11);
                offsetBlockPlacementContext.setBlockEntity();
            }
            if (!soundPlayed) {
                offsetBlockPlacementContext.playSound();
            }
            soundPlayed = true;
        }
        return class_1269.field_5812;
    }

    @Override
    public class_1269 beginAttackBlock(class_1799 stack, class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction, boolean fluidIncluded) {
        if (!player.method_68878()) {
            return class_1269.field_5811;
        }
        if (!world.method_8608()) {
            FastBuildingToolData data = (FastBuildingToolData)stack.method_58695(MishangucComponents.FAST_BUILDING_TOOL_DATA, (Object)FastBuildingToolData.DEFAULT);
            int range = data.range();
            BlockMatchingRule matchingRule = data.matchingRule();
            for (class_2338 pos1 : matchingRule.getPlainValidBlockPoss(world, pos, direction, range)) {
                if (world.method_8320(pos1).method_26204() instanceof class_5552 && !player.method_64475(2)) continue;
                if (fluidIncluded) {
                    world.method_8501(pos1, class_2246.field_10124.method_9564());
                    continue;
                }
                world.method_8650(pos1, false);
            }
        }
        world.method_8444((class_1297)player, 2001, pos, class_2248.method_9507((class_2680)world.method_8320(pos)));
        return class_1269.field_5812;
    }

    @Override
    public void getMishangTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.fast_building_tool.tooltip.1").method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.fast_building_tool.tooltip.2").method_27692(class_124.field_1080));
    }

    protected class_1799 createStack(int range, BlockMatchingRule blockMatchingRule) {
        class_1799 stack = this.method_7854();
        stack.method_57379(MishangucComponents.FAST_BUILDING_TOOL_DATA, (Object)new FastBuildingToolData(range, blockMatchingRule));
        return stack;
    }

    public void appendToEntries(class_1761.class_7704 stacks) {
        stacks.method_45420(this.createStack(1, BlockMatchingRule.SAME_BLOCK));
        stacks.method_45420(this.createStack(16, BlockMatchingRule.SAME_BLOCK));
        stacks.method_45420(this.createStack(32, BlockMatchingRule.SAME_BLOCK));
        stacks.method_45420(this.createStack(64, BlockMatchingRule.SAME_BLOCK));
    }

    public class_2561 method_7864(class_1799 stack) {
        FastBuildingToolData data = (FastBuildingToolData)stack.method_58695(MishangucComponents.FAST_BUILDING_TOOL_DATA, (Object)FastBuildingToolData.DEFAULT);
        return TextBridge.translatable("item.mishanguc.fast_building_tool.format", this.method_63680(), Integer.toString(data.range()), data.matchingRule().getName());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlockOutline(class_1657 player, class_1799 itemStack, WorldRenderContext worldRenderContext, WorldRenderContext.BlockOutlineContext blockOutlineContext, class_1268 hand) {
        class_3965 blockHitResult;
        class_310 client = class_310.method_1551();
        if (!player.method_68878()) {
            return true;
        }
        if (hand == class_1268.field_5810 && player.method_6047().method_7909() instanceof class_1747) {
            return true;
        }
        class_4597 consumers = worldRenderContext.consumers();
        if (consumers == null) {
            return true;
        }
        class_4588 vertexConsumer = consumers.getBuffer((class_1921)class_1921.field_21695);
        boolean includesFluid = this.includesFluid(itemStack, player.method_5715());
        FastBuildingToolData data = (FastBuildingToolData)itemStack.method_58695(MishangucComponents.FAST_BUILDING_TOOL_DATA, (Object)FastBuildingToolData.DEFAULT);
        BlockMatchingRule matchingRule = data.matchingRule();
        int range = data.range();
        class_239 class_2392 = client.field_1765;
        if (!(class_2392 instanceof class_3965) || (blockHitResult = (class_3965)class_2392).method_17783() != class_239.class_240.field_1332) {
            return true;
        }
        class_3965 raycast = blockHitResult;
        class_638 world = worldRenderContext.world();
        BlockPlacementContext blockPlacementContext = new BlockPlacementContext((class_1937)world, blockOutlineContext.blockPos(), player, itemStack, raycast, includesFluid);
        for (class_2338 pos : matchingRule.getPlainValidBlockPoss((class_1937)world, raycast.method_17777(), raycast.method_17780(), range)) {
            class_2680 state = world.method_8320(pos);
            BlockPlacementContext offsetBlockPlacementContext = new BlockPlacementContext(blockPlacementContext, pos);
            if (offsetBlockPlacementContext.canPlace() && offsetBlockPlacementContext.canReplace()) {
                class_9974.method_62296((class_4587)worldRenderContext.matrixStack(), (class_4588)vertexConsumer, (class_265)offsetBlockPlacementContext.stateToPlace.method_26172((class_1922)world, pos, class_3726.method_16195((class_1297)player)), (double)((double)offsetBlockPlacementContext.posToPlace.method_10263() - blockOutlineContext.cameraX()), (double)((double)offsetBlockPlacementContext.posToPlace.method_10264() - blockOutlineContext.cameraY()), (double)((double)offsetBlockPlacementContext.posToPlace.method_10260() - blockOutlineContext.cameraZ()), (int)class_9848.method_61318((float)0.8f, (float)0.0f, (float)1.0f, (float)1.0f));
                if (includesFluid) {
                    class_9974.method_62296((class_4587)worldRenderContext.matrixStack(), (class_4588)vertexConsumer, (class_265)offsetBlockPlacementContext.stateToPlace.method_26227().method_17776((class_1922)world, pos), (double)((double)offsetBlockPlacementContext.posToPlace.method_10263() - blockOutlineContext.cameraX()), (double)((double)offsetBlockPlacementContext.posToPlace.method_10264() - blockOutlineContext.cameraY()), (double)((double)offsetBlockPlacementContext.posToPlace.method_10260() - blockOutlineContext.cameraZ()), (int)class_9848.method_61318((float)0.5f, (float)0.0f, (float)0.5f, (float)1.0f));
                }
            }
            if (hand != class_1268.field_5808 || state.method_26204() instanceof class_5552 && !player.method_64475(2)) continue;
            class_9974.method_62296((class_4587)worldRenderContext.matrixStack(), (class_4588)vertexConsumer, (class_265)state.method_26172((class_1922)world, pos, class_3726.method_16195((class_1297)player)), (double)((double)pos.method_10263() - blockOutlineContext.cameraX()), (double)((double)pos.method_10264() - blockOutlineContext.cameraY()), (double)((double)pos.method_10260() - blockOutlineContext.cameraZ()), (int)class_9848.method_61318((float)0.8f, (float)1.0f, (float)0.0f, (float)0.0f));
            if (!includesFluid) continue;
            class_9974.method_62296((class_4587)worldRenderContext.matrixStack(), (class_4588)vertexConsumer, (class_265)state.method_26227().method_17776((class_1922)world, pos), (double)((double)pos.method_10263() - blockOutlineContext.cameraX()), (double)((double)pos.method_10264() - blockOutlineContext.cameraY()), (double)((double)pos.method_10260() - blockOutlineContext.cameraZ()), (int)class_9848.method_61318((float)0.5f, (float)1.0f, (float)0.5f, (float)0.0f));
        }
        return false;
    }

    @Override
    public void onScroll(int selectedSlot, double scrollAmount, class_3222 player, class_1799 stack) {
        FastBuildingToolData data = (FastBuildingToolData)stack.method_58695(MishangucComponents.FAST_BUILDING_TOOL_DATA, (Object)FastBuildingToolData.DEFAULT);
        BlockMatchingRule currentRule = data.matchingRule();
        int i = RULES_TO_CYCLE.method_10206((Object)currentRule);
        if (i == -1) {
            return;
        }
        int j = (int)class_3532.method_15367((double)((double)i - scrollAmount), (double)RULES_TO_CYCLE.method_10204());
        BlockMatchingRule newRule = (BlockMatchingRule)RULES_TO_CYCLE.method_10200(j);
        if (newRule != null) {
            stack.method_57379(MishangucComponents.FAST_BUILDING_TOOL_DATA, (Object)new FastBuildingToolData(data.range(), newRule));
            class_5250 text = TextBridge.literal("[ ");
            Iterator iterator = RULES_TO_CYCLE.iterator();
            while (iterator.hasNext()) {
                BlockMatchingRule rule = (BlockMatchingRule)iterator.next();
                class_5250 name = rule.getName();
                if (rule == newRule) {
                    name.method_27695(new class_124[]{class_124.field_1054, class_124.field_1073});
                }
                text.method_10852((class_2561)name);
                if (!iterator.hasNext()) continue;
                text.method_27693(" | ");
            }
            text.method_27693(" ]");
            player.method_7353((class_2561)text, true);
        }
    }
}

