/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.item;

import java.util.List;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2374;
import net.minecraft.class_2386;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2488;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import pers.solid.mishang.uc.components.MishangucComponents;
import pers.solid.mishang.uc.item.HotbarScrollInteraction;
import pers.solid.mishang.uc.item.MishangucItem;
import pers.solid.mishang.uc.util.TextBridge;
import pers.solid.mishang.uc.util.WithMishangTooltip;

public class IceSnowTool
extends class_1792
implements MishangucItem,
class_2357,
HotbarScrollInteraction,
WithMishangTooltip {
    public IceSnowTool(class_1792.class_1793 settings) {
        super(settings.method_57349(MishangucComponents.STRENGTH, (Object)4));
        class_2315.method_10009((class_1935)this, (class_2357)this);
    }

    public class_2561 method_7864(class_1799 stack) {
        return TextBridge.translatable("item.mishanguc.ice_snow_tool.format", this.method_63680(), Integer.toString(IceSnowTool.getStrength(stack)));
    }

    @Override
    public void getMishangTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.ice_snow_tool.tooltip.1").method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.ice_snow_tool.tooltip.2").method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.ice_snow_tool.tooltip.3").method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.ice_snow_tool.tooltip.4").method_27692(class_124.field_1080));
        if (((class_10712)stack.method_58695(class_9334.field_56400, (Object)class_10712.field_56318)).method_67214(MishangucComponents.STRENGTH)) {
            tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.ice_snow_tool.tooltip.strength", TextBridge.literal(Integer.toString(IceSnowTool.getStrength(stack))).method_27692(class_124.field_1054)).method_27692(class_124.field_1080));
        }
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (!(world instanceof class_3218)) {
            return class_1269.field_5812;
        }
        class_3218 serverWorld = (class_3218)world;
        class_239 hitResult = user.method_5745(64.0, 0.0f, false);
        if (hitResult.method_17783() == class_239.class_240.field_1333) {
            return class_1269.field_5814;
        }
        class_243 pos = hitResult.method_17784();
        int strength = IceSnowTool.getStrength(stack);
        if (user.method_5715()) {
            this.applyHeat(serverWorld, pos, strength);
        } else {
            this.applyIce(serverWorld, pos, strength);
        }
        stack.method_7970(strength + 1, (class_1309)user, class_1309.method_56079((class_1268)hand));
        return class_1269.field_5812;
    }

    public void applyIce(@NotNull class_3218 world, @NotNull class_243 pos, int strength) {
        float probability = IceSnowTool.getProbability(strength);
        int range = IceSnowTool.getRange(strength);
        class_2338 centerBlockPos = class_2338.method_49638((class_2374)pos);
        for (class_2338 blockPos : class_2338.method_25996((class_2338)centerBlockPos, (int)range, (int)0, (int)range)) {
            boolean isSnowInRange;
            boolean isWater;
            if (world.field_9229.method_43057() > probability) continue;
            class_2338 topBlockPos = world.method_8598(class_2902.class_2903.field_13197, blockPos);
            boolean isInsufficientBlockLight = world.method_8314(class_1944.field_9282, topBlockPos) < 10;
            class_2338 waterBlockPos = topBlockPos.method_10074();
            boolean isWaterInRange = centerBlockPos.method_10264() - range <= waterBlockPos.method_10264() && blockPos.method_10264() <= centerBlockPos.method_10264() + range;
            boolean bl = isWater = isWaterInRange && isInsufficientBlockLight && world.method_8320(waterBlockPos).method_26204() instanceof class_2404 && world.method_8316(waterBlockPos).method_15772() == class_3612.field_15910;
            if (isWater) {
                world.method_8501(waterBlockPos, class_2246.field_10295.method_9564());
            }
            boolean bl2 = isSnowInRange = centerBlockPos.method_10264() - range <= topBlockPos.method_10264() && topBlockPos.method_10264() <= centerBlockPos.method_10264() + range;
            int snowAccumulationHeight = world.method_64395().method_8356(class_1928.field_40883);
            if (snowAccumulationHeight <= 0 || !isInsufficientBlockLight || !isSnowInRange || !class_2246.field_10477.method_9564().method_26184((class_4538)world, topBlockPos)) continue;
            class_2680 blockState = world.method_8320(topBlockPos);
            if (blockState.method_27852(class_2246.field_10477)) {
                int layers = (Integer)blockState.method_11654((class_2769)class_2488.field_11518);
                if (layers >= Math.min(snowAccumulationHeight, 8)) continue;
                class_2680 blockState2 = (class_2680)blockState.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(layers + 1));
                class_2248.method_9582((class_2680)blockState, (class_2680)blockState2, (class_1936)world, (class_2338)topBlockPos);
                world.method_8501(topBlockPos, blockState2);
                continue;
            }
            if (!blockState.method_26215()) continue;
            world.method_8501(topBlockPos, class_2246.field_10477.method_9564());
        }
        world.method_65096((class_2394)class_2398.field_28013, pos.field_1352, pos.field_1351, pos.field_1350, (int)Math.pow(range * 2 + 1, 3.0) / 16, (double)range, (double)range, (double)range, 0.0);
    }

    public void applyHeat(@NotNull class_3218 world, @NotNull class_243 pos, int strength) {
        float probability = IceSnowTool.getProbability(strength);
        int range = IceSnowTool.getRange(strength);
        for (class_2338 blockPos : class_2338.method_25996((class_2338)class_2338.method_49638((class_2374)pos), (int)range, (int)range, (int)range)) {
            if (world.field_9229.method_43057() > probability) continue;
            class_2680 blockState = world.method_8320(blockPos);
            if (blockState.method_26204() instanceof class_2386) {
                if (world.method_8597().comp_644()) {
                    world.method_8650(blockPos, false);
                } else {
                    world.method_8501(blockPos, class_2386.method_51170());
                    world.method_8492(blockPos, class_2386.method_51170().method_26204(), null);
                }
            }
            if (!blockState.method_27852(class_2246.field_10477)) continue;
            class_2488.method_9497((class_2680)blockState, (class_1937)world, (class_2338)blockPos);
            world.method_8650(blockPos, false);
        }
        world.method_65096((class_2394)class_2398.field_11251, pos.field_1352, pos.field_1351, pos.field_1350, (int)Math.pow(range * 2 + 1, 3.0) / 16, (double)range, (double)range, (double)range, 0.0);
    }

    public class_1799 dispense(class_2342 pointer, class_1799 stack) {
        int strength = IceSnowTool.getStrength(stack);
        this.applyIce(pointer.comp_1967(), pointer.comp_1968().method_10079((class_2350)pointer.comp_1969().method_11654((class_2769)class_2315.field_10918), IceSnowTool.getRange(strength)).method_46558(), strength);
        stack.method_7956(strength + 1, pointer.comp_1967(), null, item -> {});
        return stack;
    }

    public static int getStrength(class_1799 stack) {
        return (Integer)stack.method_58695(MishangucComponents.STRENGTH, (Object)4);
    }

    public static float getProbability(int strength) {
        return class_3532.method_15363((float)(0.7f + (float)strength * 0.1f), (float)0.7f, (float)1.0f);
    }

    public static int getRange(int strength) {
        return class_3532.method_15340((int)(4 + strength * strength / 2), (int)4, (int)64);
    }

    @Override
    public void onScroll(int selectedSlot, double scrollAmount, class_3222 player, class_1799 stack) {
        int strength = IceSnowTool.getStrength(stack);
        int newStrength = class_3532.method_15387((int)(strength - (int)scrollAmount), (int)8);
        stack.method_57379(MishangucComponents.STRENGTH, (Object)newStrength);
    }
}

