/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.text;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2487;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_382;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_9848;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Matrix4f;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.mixin.TextRendererAccessor;
import pers.solid.mishang.uc.text.OutlineColorType;
import pers.solid.mishang.uc.text.SpecialDrawable;
import pers.solid.mishang.uc.text.SpecialDrawableType;
import pers.solid.mishang.uc.text.SpecialDrawableTypes;
import pers.solid.mishang.uc.text.TextContext;

public record PatternSpecialDrawable(TextContext textContext, String shapeName, @Unmodifiable float[][] rectangles) implements SpecialDrawable
{
    private final @Unmodifiable float[][] rectangles;
    private static final float[][] EMPTY = new float[0][];
    private static final float[][] ARROW_LEFT = new float[][]{{0.0f, 3.0f, 7.0f, 4.0f}, {2.0f, 1.0f, 3.0f, 3.0f}, {1.0f, 2.0f, 2.0f, 3.0f}, {1.0f, 4.0f, 2.0f, 5.0f}, {2.0f, 4.0f, 3.0f, 6.0f}};
    private static final float[][] ARROW_RIGHT = new float[][]{{0.0f, 3.0f, 7.0f, 4.0f}, {4.0f, 1.0f, 5.0f, 3.0f}, {5.0f, 2.0f, 6.0f, 3.0f}, {5.0f, 4.0f, 6.0f, 5.0f}, {4.0f, 4.0f, 5.0f, 6.0f}};
    private static final float[][] ARROW_TOP = new float[][]{{3.0f, 0.0f, 4.0f, 7.0f}, {2.0f, 1.0f, 3.0f, 2.0f}, {1.0f, 2.0f, 3.0f, 3.0f}, {4.0f, 1.0f, 5.0f, 2.0f}, {4.0f, 2.0f, 6.0f, 3.0f}};
    private static final float[][] ARROW_BOTTOM = new float[][]{{3.0f, 0.0f, 4.0f, 7.0f}, {2.0f, 5.0f, 3.0f, 6.0f}, {1.0f, 4.0f, 3.0f, 5.0f}, {4.0f, 5.0f, 5.0f, 6.0f}, {4.0f, 4.0f, 6.0f, 5.0f}};
    private static final float[][] ARROW_LEFT_TOP = new float[][]{{1.0f, 1.0f, 2.0f, 5.0f}, {2.0f, 1.0f, 5.0f, 2.0f}, {2.0f, 2.0f, 3.0f, 3.0f}, {3.0f, 3.0f, 4.0f, 4.0f}, {4.0f, 4.0f, 5.0f, 5.0f}, {5.0f, 5.0f, 6.0f, 6.0f}, {6.0f, 6.0f, 7.0f, 7.0f}};
    private static final float[][] ARROW_RIGHT_TOP = new float[][]{{5.0f, 1.0f, 6.0f, 5.0f}, {2.0f, 1.0f, 5.0f, 2.0f}, {4.0f, 2.0f, 5.0f, 3.0f}, {3.0f, 3.0f, 4.0f, 4.0f}, {2.0f, 4.0f, 3.0f, 5.0f}, {1.0f, 5.0f, 2.0f, 6.0f}, {0.0f, 6.0f, 1.0f, 7.0f}};
    private static final float[][] ARROW_LEFT_BOTTOM = new float[][]{{1.0f, 2.0f, 2.0f, 6.0f}, {2.0f, 5.0f, 5.0f, 6.0f}, {2.0f, 4.0f, 3.0f, 5.0f}, {3.0f, 3.0f, 4.0f, 4.0f}, {4.0f, 2.0f, 5.0f, 3.0f}, {5.0f, 1.0f, 6.0f, 2.0f}, {6.0f, 0.0f, 7.0f, 1.0f}};
    private static final float[][] ARROW_RIGHT_BOTTOM = new float[][]{{5.0f, 2.0f, 6.0f, 6.0f}, {2.0f, 5.0f, 5.0f, 6.0f}, {4.0f, 4.0f, 5.0f, 5.0f}, {3.0f, 3.0f, 4.0f, 4.0f}, {2.0f, 2.0f, 3.0f, 3.0f}, {1.0f, 1.0f, 2.0f, 2.0f}, {0.0f, 0.0f, 1.0f, 1.0f}};
    private static final float[][] CIRCLE = new float[][]{{2.0f, 0.0f, 5.0f, 1.0f}, {2.0f, 6.0f, 5.0f, 7.0f}, {0.0f, 2.0f, 1.0f, 5.0f}, {6.0f, 2.0f, 7.0f, 5.0f}, {1.0f, 1.0f, 2.0f, 2.0f}, {5.0f, 1.0f, 6.0f, 2.0f}, {1.0f, 5.0f, 2.0f, 6.0f}, {5.0f, 5.0f, 6.0f, 6.0f}};
    private static final float[][] BAN = new float[][]{{2.0f, 0.0f, 5.0f, 1.0f}, {2.0f, 6.0f, 5.0f, 7.0f}, {0.0f, 2.0f, 1.0f, 5.0f}, {6.0f, 2.0f, 7.0f, 5.0f}, {1.0f, 1.0f, 2.0f, 2.0f}, {5.0f, 1.0f, 6.0f, 2.0f}, {1.0f, 5.0f, 2.0f, 6.0f}, {5.0f, 5.0f, 6.0f, 6.0f}, {2.0f, 2.0f, 3.0f, 3.0f}, {3.0f, 3.0f, 4.0f, 4.0f}, {4.0f, 4.0f, 5.0f, 5.0f}};
    @ApiStatus.AvailableSince(value="0.2.2")
    private static final float[][] U_TURN_LEFT_BOTTOM = new float[][]{{3.0f, 0.0f, 6.0f, 1.0f}, {6.0f, 1.0f, 7.0f, 6.0f}, {2.0f, 1.0f, 3.0f, 7.0f}, {0.0f, 4.0f, 1.0f, 5.0f}, {1.0f, 5.0f, 2.0f, 6.0f}, {4.0f, 4.0f, 5.0f, 5.0f}, {3.0f, 5.0f, 4.0f, 6.0f}};
    @ApiStatus.AvailableSince(value="0.2.2")
    private static final float[][] U_TURN_RIGHT_BOTTOM = PatternSpecialDrawable.flipLeftRight(U_TURN_LEFT_BOTTOM);
    @ApiStatus.AvailableSince(value="0.2.2")
    private static final float[][] U_TURN_LEFT_TOP = PatternSpecialDrawable.flipUpDown(U_TURN_LEFT_BOTTOM);
    @ApiStatus.AvailableSince(value="0.2.2")
    private static final float[][] U_TURN_RIGHT_TOP = PatternSpecialDrawable.flipUpDown(U_TURN_RIGHT_BOTTOM);
    @ApiStatus.AvailableSince(value="0.2.2")
    private static final float[][] CROSS = new float[][]{{1.0f, 1.0f, 2.0f, 2.0f}, {2.0f, 2.0f, 3.0f, 3.0f}, {3.0f, 3.0f, 4.0f, 4.0f}, {4.0f, 4.0f, 5.0f, 5.0f}, {5.0f, 5.0f, 6.0f, 6.0f}, {4.0f, 2.0f, 5.0f, 3.0f}, {5.0f, 1.0f, 6.0f, 2.0f}, {2.0f, 4.0f, 3.0f, 5.0f}, {1.0f, 5.0f, 2.0f, 6.0f}};
    private static final @Unmodifiable Map<String, float[][]> NAME_TO_SHAPE = new ImmutableMap.Builder().put((Object)"al", (Object)ARROW_LEFT).put((Object)"ar", (Object)ARROW_RIGHT).put((Object)"at", (Object)ARROW_TOP).put((Object)"ab", (Object)ARROW_BOTTOM).put((Object)"alt", (Object)ARROW_LEFT_TOP).put((Object)"art", (Object)ARROW_RIGHT_TOP).put((Object)"alb", (Object)ARROW_LEFT_BOTTOM).put((Object)"arb", (Object)ARROW_RIGHT_BOTTOM).put((Object)"circle", (Object)CIRCLE).put((Object)"ban", (Object)BAN).put((Object)"ulb", (Object)U_TURN_LEFT_BOTTOM).put((Object)"urb", (Object)U_TURN_RIGHT_BOTTOM).put((Object)"ult", (Object)U_TURN_LEFT_TOP).put((Object)"urt", (Object)U_TURN_RIGHT_TOP).put((Object)"cross", (Object)CROSS).build();

    @Contract(value="-> new", pure=true)
    public float[][] rectangles() {
        float[][] newArray = new float[this.rectangles.length][];
        for (int i = 0; i < this.rectangles.length; ++i) {
            newArray[i] = (float[])this.rectangles[i].clone();
        }
        return newArray;
    }

    @Contract(pure=true)
    public boolean isEmpty() {
        return this.rectangles == EMPTY;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawExtra(class_327 textRenderer, class_4587 matrixStack, class_4597 vertexConsumers, int light, float x, float y) {
        int color = this.textContext.color;
        class_382 bakedGlyph = ((TextRendererAccessor)textRenderer).invokeGetFontStorage(class_2583.field_24359).method_22943();
        float sizeMultiplier = 1.0f;
        class_1921 layer = bakedGlyph.method_24045(this.textContext.outlineColorType != OutlineColorType.NONE ? class_327.class_6415.field_33995 : (this.textContext.seeThrough ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993));
        boolean shadow = this.textContext.outlineColorType == OutlineColorType.NONE && this.textContext.shadow;
        ArrayList<class_382.class_328> rectanglesToDraw = new ArrayList<class_382.class_328>();
        ArrayList<class_382.class_328> outlineRectangles = this.textContext.outlineColorType == OutlineColorType.NONE ? null : new ArrayList<class_382.class_328>();
        for (Object rectangle : this.rectangles) {
            float minX = (rectangle[0] + x) * 1.0f;
            float minY = (rectangle[1] + y) * 1.0f;
            float maxX = (rectangle[2] + x) * 1.0f;
            float maxY = (rectangle[3] + y) * 1.0f;
            if (shadow) {
                rectanglesToDraw.add(new class_382.class_328(minX + 1.0f, minY + 1.0f, maxX + 1.0f, maxY + 1.0f, 0.0f, class_9848.method_61321((int)color, (float)0.25f)));
            }
            if (outlineRectangles != null) {
                int outlineColor = this.textContext.outlineColorType == OutlineColorType.AUTO ? MishangUtils.toSignOutlineColor(color) : this.textContext.outlineColor;
                int outlineAlpha = (outlineColor & 0xFC000000) == 0 ? 255 : outlineColor >> 24 & 0xFF;
                outlineRectangles.add(new class_382.class_328(minX - 1.0f, minY - 1.0f, maxX + 1.0f, maxY + 1.0f, 0.0f, class_9848.method_61330((int)outlineAlpha, (int)outlineColor)));
            }
            rectanglesToDraw.add(new class_382.class_328(minX, minY, maxX, maxY, shadow ? 0.03f : (this.textContext.outlineColorType != OutlineColorType.NONE ? 0.02f : 0.0f), color));
        }
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        class_4588 vertexConsumer = vertexConsumers.getBuffer(layer);
        Iterator iterator = rectanglesToDraw.iterator();
        while (iterator.hasNext()) {
            Object rectangle;
            rectangle = (class_382.class_328)iterator.next();
            bakedGlyph.method_22944((class_382.class_328)rectangle, matrix4f, vertexConsumer, light, false);
        }
        if (outlineRectangles != null) {
            class_4588 vertexConsumerOutline = vertexConsumers.getBuffer(bakedGlyph.method_24045(class_327.class_6415.field_33993));
            for (class_382.class_328 outlineRectangle : outlineRectangles) {
                bakedGlyph.method_22944(outlineRectangle, matrix4f, vertexConsumerOutline, light, false);
            }
        }
    }

    @Override
    public float height() {
        return 0.875f;
    }

    @Override
    public float width() {
        return 0.875f;
    }

    @Override
    @NotNull
    public String getId() {
        return "pattern";
    }

    @NotNull
    public SpecialDrawableType<PatternSpecialDrawable> getType() {
        return SpecialDrawableTypes.PATTERN;
    }

    @Override
    public SpecialDrawable cloneWithNewTextContext(@NotNull TextContext textContext) {
        return new PatternSpecialDrawable(textContext, this.shapeName, this.rectangles);
    }

    @Override
    public String asStringArgs() {
        return this.shapeName;
    }

    @Contract(value="_,_ -> new", pure=true)
    public static PatternSpecialDrawable fromNbt(TextContext textContext, class_2487 nbt) {
        String shapeName = nbt.method_68564("shapeName", null);
        return PatternSpecialDrawable.fromName(textContext, shapeName);
    }

    @Override
    public void writeNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        SpecialDrawable.super.writeNbt(nbt, registryLookup);
        nbt.method_10582("shapeName", this.shapeName);
    }

    public static PatternSpecialDrawable fromName(TextContext textContext, String shapeName) {
        return new PatternSpecialDrawable(textContext, shapeName, NAME_TO_SHAPE.getOrDefault(shapeName, EMPTY));
    }

    @ApiStatus.AvailableSince(value="0.2.1")
    @Contract(value="_ -> new", pure=true)
    private static float[][] flipLeftRight(float[][] original) {
        float[][] flipped = new float[original.length][];
        for (int i = 0; i < original.length; ++i) {
            float[] originalPiece = original[i];
            flipped[i] = new float[]{7.0f - originalPiece[2], originalPiece[1], 7.0f - originalPiece[0], originalPiece[3]};
        }
        return flipped;
    }

    @ApiStatus.AvailableSince(value="0.2.1")
    @Contract(value="_ -> new", pure=true)
    private static float[][] flipUpDown(float[][] original) {
        float[][] flipped = new float[original.length][];
        for (int i = 0; i < original.length; ++i) {
            float[] originalPiece = original[i];
            flipped[i] = new float[]{originalPiece[0], 7.0f - originalPiece[3], originalPiece[2], 7.0f - originalPiece[1]};
        }
        return flipped;
    }

    @ApiStatus.AvailableSince(value="0.2.1")
    @Contract(value="_ -> new", pure=true)
    private static float[][] flipAll(float[][] original) {
        float[][] flipped = new float[original.length][];
        for (int i = 0; i < original.length; ++i) {
            float[] originalPiece = original[i];
            flipped[i] = new float[]{7.0f - originalPiece[2], 7.0f - originalPiece[3], 7.0f - originalPiece[0], 7.0f - originalPiece[1]};
        }
        return flipped;
    }

    @Override
    @NotNull
    public class_5250 asStyledText() {
        return SpecialDrawable.super.asStyledText().method_27694(style -> style.method_36139(this.textContext.color));
    }
}

