/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.text;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_382;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.mixin.TextRendererAccessor;
import pers.solid.mishang.uc.text.OutlineColorType;
import pers.solid.mishang.uc.text.SpecialDrawable;
import pers.solid.mishang.uc.text.SpecialDrawableType;
import pers.solid.mishang.uc.text.SpecialDrawableTypes;
import pers.solid.mishang.uc.text.TextContext;
import pers.solid.mishang.uc.util.TextBridge;

public record RectSpecialDrawable(float width, float height, @NotNull TextContext textContext) implements SpecialDrawable
{
    private final float width;
    private final float height;

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawExtra(class_327 textRenderer, class_4587 matrixStack, class_4597 vertexConsumers, int light, float x, float y) {
        boolean shadow;
        int color = this.textContext.color;
        class_382 bakedGlyph = ((TextRendererAccessor)textRenderer).invokeGetFontStorage(class_2583.field_24359).method_22943();
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        class_1921 layer = bakedGlyph.method_24045(this.textContext.outlineColorType != OutlineColorType.NONE ? class_327.class_6415.field_33995 : (this.textContext.seeThrough ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993));
        class_4588 vertexConsumer = vertexConsumers.getBuffer(layer);
        boolean bl = shadow = this.textContext.outlineColorType == OutlineColorType.NONE && this.textContext.shadow;
        if (shadow) {
            class_382.class_328 shadowRectangle = new class_382.class_328(x + 1.0f, y + 1.0f, this.width + x + 1.0f, y + this.height + 1.0f, 0.0f, class_9848.method_61321((int)color, (float)0.25f));
            bakedGlyph.method_22944(shadowRectangle, matrix4f, vertexConsumer, light, false);
        }
        if (this.textContext.outlineColorType != OutlineColorType.NONE) {
            int outlineColor = this.textContext.outlineColorType == OutlineColorType.AUTO ? MishangUtils.toSignOutlineColor(color) : this.textContext.outlineColor;
            int outlineAlpha = (outlineColor & 0xFC000000) == 0 ? 255 : outlineColor >> 24 & 0xFF;
            class_382.class_328 outlineRectangle = new class_382.class_328(x - 1.0f, y - 1.0f, this.width + x + 1.0f, y + this.height + 1.0f, 0.0f, class_9848.method_61330((int)outlineAlpha, (int)outlineColor));
            bakedGlyph.method_22944(outlineRectangle, matrix4f, vertexConsumers.getBuffer(bakedGlyph.method_24045(class_327.class_6415.field_33993)), light, false);
        }
        class_4588 vertexConsumer2 = vertexConsumers.getBuffer(layer);
        class_382.class_328 rectangle = new class_382.class_328(x, y, this.width + x, y + this.height, shadow ? 0.03f : (this.textContext.outlineColorType != OutlineColorType.NONE ? 0.02f : 0.0f), color);
        bakedGlyph.method_22944(rectangle, matrix4f, vertexConsumer2, light, false);
    }

    @Override
    @NotNull
    public String getId() {
        return "rect";
    }

    @NotNull
    public SpecialDrawableType<RectSpecialDrawable> getType() {
        return SpecialDrawableTypes.RECT;
    }

    public static RectSpecialDrawable fromNbt(@NotNull TextContext textContext, @NotNull class_2487 nbt) {
        return new RectSpecialDrawable(nbt.method_66563("width", 0.0f), nbt.method_66563("height", 0.0f), textContext);
    }

    public static RectSpecialDrawable fromStringArgs(TextContext textContext, String args) {
        RectSpecialDrawable rect;
        String[] split = args.split(" ");
        if (split.length < 2) {
            return null;
        }
        try {
            float width = Float.parseFloat(split[0]);
            float height = Float.parseFloat(split[1]);
            rect = new RectSpecialDrawable(width, height, textContext);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return rect;
    }

    @Override
    public void writeNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        SpecialDrawable.super.writeNbt(nbt, registryLookup);
        nbt.method_10548("width", this.width);
        nbt.method_10548("height", this.height);
    }

    @Override
    public String asStringArgs() {
        return String.format("%s %s", this.width % 1.0f == 0.0f ? Integer.toString((int)this.width) : Float.toString(this.width), this.height % 1.0f == 0.0f ? Integer.toString((int)this.height) : Float.toString(this.height));
    }

    @Override
    public float width() {
        return this.width / 8.0f;
    }

    @Override
    public float height() {
        return this.height / 8.0f;
    }

    public RectSpecialDrawable clone() {
        try {
            return (RectSpecialDrawable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SpecialDrawable cloneWithNewTextContext(@NotNull TextContext textContext) {
        return new RectSpecialDrawable(this.width, this.height, textContext);
    }

    @Override
    @NotNull
    public class_5250 asStyledText() {
        return TextBridge.empty().method_10852((class_2561)TextBridge.literal("\u25a0").method_27694(style -> style.method_36139(this.textContext.color))).method_27693(" (" + this.width + "\u00d7" + this.height + ")");
    }
}

