/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.text;

import com.google.common.collect.ImmutableBiMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.Strictness;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.chars.Char2CharArrayMap;
import it.unimi.dsi.fastutil.chars.Char2CharMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import joptsimple.internal.Strings;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_7225;
import net.minecraft.class_7417;
import net.minecraft.class_8824;
import net.minecraft.class_8828;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.text.OutlineColorType;
import pers.solid.mishang.uc.text.PatternSpecialDrawable;
import pers.solid.mishang.uc.text.SpecialDrawable;
import pers.solid.mishang.uc.util.HorizontalAlign;
import pers.solid.mishang.uc.util.TextBridge;
import pers.solid.mishang.uc.util.VerticalAlign;

public class TextContext
implements Cloneable {
    public static final Codec<TextContext> CODEC = class_2487.field_25128.xmap(nbtCompound -> TextContext.fromNbt((class_2520)nbtCompound, null), textContext -> textContext.createNbt(null));
    public static final Gson GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).create();
    public static final class_9139<class_9129, TextContext> PACKET_CODEC = class_9139.method_56438((value, buf) -> buf.method_10794((class_2520)value.createNbt((class_7225.class_7874)buf.method_56349())), buf -> TextContext.fromNbt((class_2520)buf.method_10798(), (class_7225.class_7874)buf.method_56349()));
    private static final Char2CharMap flipStringReplacement = (Char2CharMap)class_156.method_654((Object)new Char2CharArrayMap(), map -> {
        map.put('\u2190', '\u2192');
        map.put('\u2192', '\u2190');
        map.put('\u2196', '\u2197');
        map.put('\u2197', '\u2196');
        map.put('\u2198', '\u2199');
        map.put('\u2199', '\u2198');
    });
    @ApiStatus.AvailableSince(value="0.2.0")
    private static final @Unmodifiable ImmutableBiMap<String, String> flipPatternNameReplacement = new ImmutableBiMap.Builder().put((Object)"al", (Object)"ar").put((Object)"alt", (Object)"art").put((Object)"alb", (Object)"arb").put((Object)"ulb", (Object)"urb").put((Object)"ult", (Object)"urt").build();
    @Nullable
    public class_5250 text;
    public HorizontalAlign horizontalAlign = HorizontalAlign.CENTER;
    public VerticalAlign verticalAlign = VerticalAlign.MIDDLE;
    public int color = -1;
    public boolean shadow = false;
    public boolean seeThrough = false;
    public float offsetX = 0.0f;
    public float offsetY = 0.0f;
    public float offsetZ = 0.0f;
    public float rotationX = 0.0f;
    public float rotationY = 0.0f;
    public float rotationZ = 0.0f;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public boolean bold = false;
    public boolean italic = false;
    public boolean underline = false;
    public boolean strikethrough = false;
    public boolean obfuscated = false;
    public boolean absolute = false;
    public float size = 8.0f;
    @ApiStatus.AvailableSince(value="0.1.6-mc1.17")
    public int outlineColor = -2;
    @ApiStatus.AvailableSince(value="1.4.2")
    @NotNull
    public OutlineColorType outlineColorType = OutlineColorType.NONE;
    @ApiStatus.AvailableSince(value="0.2.0")
    @Nullable
    public SpecialDrawable extra = null;
    @ApiStatus.AvailableSince(value="0.2.1")
    private transient boolean[] cachedStyles = null;
    @ApiStatus.AvailableSince(value="0.2.1")
    private transient class_2561 cachedText = null;
    @ApiStatus.AvailableSince(value="0.2.1")
    private transient class_5250 formattedText = null;

    public static Codec<List<TextContext>> createListCodec(Supplier<TextContext> defaultSupplier) {
        return Codec.either((Codec)Codec.STRING, (Codec)Codec.either(CODEC, (Codec)CODEC.listOf())).xmap(e -> (List)e.map(arg_0 -> TextContext.lambda$createListCodec$2((Supplier)defaultSupplier, arg_0), ei -> (List)ei.map(Collections::singletonList, textContexts -> textContexts)), x -> x.size() == 1 ? Either.right((Object)Either.left((Object)((TextContext)x.get(0)))) : Either.right((Object)Either.right((Object)x)));
    }

    @NotNull
    public static TextContext fromNbt(class_2520 nbt, class_7225.class_7874 registryLookup) {
        return TextContext.fromNbt(nbt, new TextContext(), registryLookup);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Contract(value="_, _, _ -> param2", mutates="param2")
    @NotNull
    public static TextContext fromNbt(class_2520 nbt, TextContext defaults, class_7225.class_7874 registryLookup) {
        if (nbt instanceof class_2519) {
            String value;
            class_2519 class_25192 = (class_2519)nbt;
            try {
                String string;
                value = string = class_25192.comp_3831();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            defaults.text = class_2561.method_43470((String)value);
            return defaults;
        }
        if (nbt instanceof class_2487) {
            class_2487 nbtCompound = (class_2487)nbt;
            defaults.readNbt(nbtCompound, registryLookup);
            return defaults;
        }
        if (!(nbt instanceof class_2514)) return defaults;
        class_2514 nbtNumber = (class_2514)nbt;
        defaults.text = class_2561.method_43470((String)nbtNumber.method_10702().toString());
        return defaults;
    }

    private static void putBooleanParam(class_2487 nbt, String name, boolean value) {
        if (value) {
            nbt.method_10556(name, true);
        } else {
            nbt.method_10551(name);
        }
    }

    @Contract(mutates="this")
    public void readNbt(@NotNull class_2487 nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable class_7225.class_7874 registryLookup) {
        block9: {
            String textJson = nbt.method_68564("textJson", null);
            if (!Strings.isNullOrEmpty((String)textJson)) {
                try {
                    JsonElement jsonElement = (JsonElement)GSON.fromJson(textJson, JsonElement.class);
                    if (registryLookup == null) {
                        this.text = (class_5250)class_8824.field_46597.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow();
                        break block9;
                    }
                    this.text = (class_5250)class_8824.field_46597.parse((DynamicOps)registryLookup.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)jsonElement).getOrThrow();
                }
                catch (JsonParseException e) {
                    this.text = TextBridge.translatable("message.mishanguc.invalid_json", e.getMessage());
                }
            } else {
                this.text = nbt.method_10545("text") ? (class_5250)nbt.method_67492("text", class_8824.field_46597, (DynamicOps)(registryLookup == null ? class_2509.field_11560 : registryLookup.method_57093((DynamicOps)class_2509.field_11560))).orElseGet(() -> class_2561.method_43470((String)nbt.method_10580("text").toString()).method_27692(class_124.field_1061)) : null;
            }
        }
        this.horizontalAlign = HorizontalAlign.byName(nbt.method_68564("horizontalAlign", null));
        if (this.horizontalAlign == null) {
            this.horizontalAlign = HorizontalAlign.CENTER;
        }
        this.verticalAlign = VerticalAlign.byName(nbt.method_68564("verticalAlign", null));
        if (this.verticalAlign == null) {
            this.verticalAlign = VerticalAlign.MIDDLE;
        }
        if (nbt.method_10545("color")) {
            this.color = MishangUtils.readColorFromNbtElement(nbt.method_10580("color"));
        }
        OutlineColorType outlineColorType = nbt.method_10545("outlineColorType") ? (OutlineColorType)OutlineColorType.CODEC.method_42633(nbt.method_68564("outlineColorType", null)) : null;
        if (nbt.method_10545("outlineColor")) {
            this.outlineColor = MishangUtils.readColorFromNbtElement(nbt.method_10580("outlineColor"));
        }
        this.outlineColorType = outlineColorType == null ? OutlineColorType.fromCompatibilityValue(this.outlineColor) : outlineColorType;
        this.shadow = nbt.method_68566("shadow", false);
        this.seeThrough = nbt.method_68566("seeThrough", false);
        this.offsetX = nbt.method_66563("offsetX", 0.0f);
        this.offsetY = nbt.method_66563("offsetY", 0.0f);
        this.offsetZ = nbt.method_66563("offsetZ", 0.0f);
        this.rotationX = nbt.method_66563("rotationX", 0.0f);
        this.rotationY = nbt.method_66563("rotationY", 0.0f);
        this.rotationZ = nbt.method_66563("rotationZ", 0.0f);
        this.scaleX = nbt.method_66563("scaleX", 1.0f);
        this.scaleY = nbt.method_66563("scaleY", 1.0f);
        this.size = nbt.method_10545("size") ? nbt.method_66563("size", 0.0f) : this.size;
        this.bold = nbt.method_68566("bold", false);
        this.italic = nbt.method_68566("italic", false);
        this.underline = nbt.method_68566("underline", false);
        this.strikethrough = nbt.method_68566("strikethrough", false);
        this.obfuscated = nbt.method_68566("obfuscated", false);
        this.absolute = nbt.method_68566("absolute", false);
        this.extra = nbt.method_10545("extra") ? SpecialDrawable.fromNbt(this, nbt.method_68568("extra")) : null;
    }

    @Environment(value=EnvType.CLIENT)
    @Contract(pure=true)
    public void draw(class_327 textRenderer, class_4587 matrixStack, class_4597 vertexConsumers, int light, float width, float height) {
        if (this.text == null && this.extra == null) {
            return;
        }
        if (!Arrays.equals(this.cachedStyles, new boolean[]{this.bold, this.italic, this.underline, this.strikethrough, this.obfuscated}) || this.text != this.cachedText) {
            this.reformatText();
        }
        class_5481 orderedText = this.formattedText == null ? null : this.formattedText.method_30937();
        matrixStack.method_22903();
        matrixStack.method_46416(this.offsetX, this.offsetY, this.offsetZ);
        if (this.rotationX != 0.0f || this.rotationY != 0.0f || this.rotationZ != 0.0f) {
            matrixStack.method_22907((Quaternionfc)new Quaternionf().rotateXYZ((float)Math.PI / 180 * this.rotationX, (float)Math.PI / 180 * this.rotationY, (float)Math.PI / 180 * this.rotationZ));
        }
        float x = 0.0f;
        switch (this.horizontalAlign == null ? HorizontalAlign.CENTER : this.horizontalAlign) {
            case LEFT: {
                matrixStack.method_46416(-width / 2.0f, 0.0f, 0.0f);
                break;
            }
            case CENTER: {
                matrixStack.method_46416(-this.getWidth(textRenderer, orderedText) / 4.0f, 0.0f, 0.0f);
                break;
            }
            case RIGHT: {
                matrixStack.method_46416(width / 2.0f - this.getWidth(textRenderer, orderedText) / 2.0f, 0.0f, 0.0f);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.horizontalAlign));
            }
        }
        float y = 0.0f;
        switch (this.verticalAlign == null ? VerticalAlign.MIDDLE : this.verticalAlign) {
            case TOP: {
                matrixStack.method_46416(0.0f, -height / 2.0f, 0.0f);
                break;
            }
            case MIDDLE: {
                matrixStack.method_46416(0.0f, -this.getHeight() / 4.0f, 0.0f);
                break;
            }
            case BOTTOM: {
                matrixStack.method_46416(0.0f, height / 2.0f - this.getHeight() / 2.0f, 0.0f);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.verticalAlign));
            }
        }
        matrixStack.method_22905(this.size / 16.0f, this.size / 16.0f, this.size / 16.0f);
        matrixStack.method_22905(this.scaleX, this.scaleY, 1.0f);
        if (orderedText != null) {
            this.drawText(textRenderer, matrixStack, vertexConsumers, light, orderedText, x, y);
        }
        if (this.extra != null) {
            this.extra.drawExtra(textRenderer, matrixStack, vertexConsumers, light, x, y);
        }
        matrixStack.method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    @ApiStatus.AvailableSince(value="0.2.1")
    private void reformatText() {
        if (this.text == null) {
            this.cachedText = null;
            this.formattedText = null;
            return;
        }
        this.cachedText = this.text;
        this.formattedText = this.text.method_27661();
        if (this.bold) {
            this.formattedText.method_27692(class_124.field_1067);
        }
        if (this.italic) {
            this.formattedText.method_27692(class_124.field_1056);
        }
        if (this.underline) {
            this.formattedText.method_27692(class_124.field_1073);
        }
        if (this.strikethrough) {
            this.formattedText.method_27692(class_124.field_1055);
        }
        if (this.obfuscated) {
            this.formattedText.method_27692(class_124.field_1051);
        }
        this.cachedStyles = new boolean[]{this.bold, this.italic, this.underline, this.strikethrough, this.obfuscated};
    }

    private float getWidth(class_327 textRenderer, @Nullable class_5481 text) {
        float width = text == null ? 0.0f : (float)textRenderer.method_30880(text) * this.size / 8.0f * this.scaleX;
        return this.extra != null ? Math.max(width, this.extra.width() * this.size * this.scaleX) : width;
    }

    public float getHeight() {
        return (this.extra != null ? this.extra.height() * this.size : this.size) * this.scaleY;
    }

    public float getMarginTop() {
        return this.extra != null ? 0.0f : this.size / 8.0f;
    }

    @Environment(value=EnvType.CLIENT)
    @Contract(pure=true)
    protected void drawText(class_327 textRenderer, class_4587 matrixStack, class_4597 vertexConsumers, int light, class_5481 text, float x, float y) {
        if (this.outlineColorType == OutlineColorType.NONE) {
            textRenderer.method_22942(text, x, y, this.color, this.shadow, matrixStack.method_23760().method_23761(), vertexConsumers, this.seeThrough ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, 0, light);
        } else {
            textRenderer.method_37296(text, x, y, this.color, this.outlineColorType == OutlineColorType.AUTO ? MishangUtils.toSignOutlineColor(this.color) : this.outlineColor, matrixStack.method_23760().method_23761(), vertexConsumers, light);
        }
    }

    @Contract(mutates="param1")
    public void writeNbt(@NotNull class_2487 nbt, class_7225.class_7874 registryLookup) {
        if (this.text != null) {
            nbt.method_67493("text", class_8824.field_46597, (DynamicOps)(registryLookup == null ? class_2509.field_11560 : registryLookup.method_57093((DynamicOps)class_2509.field_11560)), (Object)this.text);
        } else {
            nbt.method_10551("text");
        }
        if (this.horizontalAlign != HorizontalAlign.CENTER) {
            nbt.method_10582("horizontalAlign", this.horizontalAlign.method_15434());
        } else {
            nbt.method_10551("horizontalAlign");
        }
        if (this.verticalAlign != VerticalAlign.MIDDLE) {
            nbt.method_10582("verticalAlign", this.verticalAlign.method_15434());
        } else {
            nbt.method_10551("verticalAlign");
        }
        nbt.method_10569("color", this.color);
        nbt.method_10582("outlineColorType", this.outlineColorType.method_15434());
        nbt.method_10569("outlineColor", this.outlineColor);
        TextContext.putBooleanParam(nbt, "shadow", this.shadow);
        TextContext.putBooleanParam(nbt, "seeThrough", this.seeThrough);
        nbt.method_10548("size", this.size);
        if (this.offsetX != 0.0f) {
            nbt.method_10548("offsetX", this.offsetX);
        } else {
            nbt.method_10551("offsetX");
        }
        if (this.offsetY != 0.0f) {
            nbt.method_10548("offsetY", this.offsetY);
        } else {
            nbt.method_10551("offsetY");
        }
        if (this.offsetZ != 0.0f) {
            nbt.method_10548("offsetZ", this.offsetZ);
        } else {
            nbt.method_10551("offsetZ");
        }
        if (this.rotationX != 0.0f) {
            nbt.method_10548("rotationX", this.rotationX);
        } else {
            nbt.method_10551("rotationX");
        }
        if (this.rotationY != 0.0f) {
            nbt.method_10548("rotationY", this.rotationY);
        } else {
            nbt.method_10551("rotationY");
        }
        if (this.rotationZ != 0.0f) {
            nbt.method_10548("rotationZ", this.rotationZ);
        } else {
            nbt.method_10551("rotationZ");
        }
        if (this.scaleX != 1.0f) {
            nbt.method_10548("scaleX", this.scaleX);
        } else {
            nbt.method_10551("scaleX");
        }
        if (this.scaleY != 1.0f) {
            nbt.method_10548("scaleY", this.scaleY);
        } else {
            nbt.method_10551("scaleY");
        }
        TextContext.putBooleanParam(nbt, "bold", this.bold);
        TextContext.putBooleanParam(nbt, "italic", this.italic);
        TextContext.putBooleanParam(nbt, "underline", this.underline);
        TextContext.putBooleanParam(nbt, "strikethrough", this.strikethrough);
        TextContext.putBooleanParam(nbt, "obfuscated", this.obfuscated);
        TextContext.putBooleanParam(nbt, "absolute", this.absolute);
        if (this.extra == null) {
            nbt.method_10551("extra");
        } else {
            nbt.method_10566("extra", (class_2520)this.extra.createNbt(registryLookup));
        }
    }

    @Contract(value="_ -> new")
    public final class_2487 createNbt(class_7225.class_7874 registryLookup) {
        class_2487 nbtCompound = new class_2487();
        this.writeNbt(nbtCompound, registryLookup);
        return nbtCompound;
    }

    public TextContext clone() {
        try {
            TextContext clone = (TextContext)super.clone();
            clone.extra = clone.extra != null ? clone.extra.cloneWithNewTextContext(clone) : null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @NotNull
    public class_5250 asStyledText() {
        class_5250 text;
        class_5250 class_52502 = text = this.text == null ? TextBridge.empty() : this.text.method_27661();
        if (this.bold) {
            text.method_27692(class_124.field_1067);
        }
        if (this.italic) {
            text.method_27692(class_124.field_1056);
        }
        if (this.underline) {
            text.method_27692(class_124.field_1073);
        }
        if (this.strikethrough) {
            text.method_27692(class_124.field_1055);
        }
        if (this.obfuscated) {
            text.method_27692(class_124.field_1051);
        }
        if (text.method_10866().method_10973() == null) {
            text.method_27694(style -> style.method_36139(this.color));
        }
        if (this.extra != null) {
            return this.extra.asStyledText();
        }
        return text;
    }

    @Contract(mutates="this")
    public TextContext flip() {
        Object rawString;
        class_7417 class_74172;
        this.offsetX = -this.offsetX;
        this.horizontalAlign = this.horizontalAlign.flip();
        if (this.text != null && (class_74172 = this.text.method_10851()) instanceof class_8828) {
            class_8828 plainTextContent = (class_8828)class_74172;
            rawString = plainTextContent.comp_737();
            StringBuilder stringBuilder = new StringBuilder((String)rawString);
            for (int i = 0; i < stringBuilder.length(); ++i) {
                char c = stringBuilder.charAt(i);
                if (!flipStringReplacement.containsKey(c)) continue;
                stringBuilder.setCharAt(i, flipStringReplacement.get(c));
            }
            this.text = TextBridge.literal(stringBuilder.toString());
        }
        if ((rawString = this.extra) instanceof PatternSpecialDrawable) {
            PatternSpecialDrawable patternTextSpecial = (PatternSpecialDrawable)rawString;
            String shapeName = patternTextSpecial.shapeName();
            if (flipPatternNameReplacement.containsKey((Object)shapeName)) {
                this.extra = PatternSpecialDrawable.fromName(this, (String)flipPatternNameReplacement.get((Object)shapeName));
            } else if (flipPatternNameReplacement.inverse().containsKey((Object)shapeName)) {
                this.extra = PatternSpecialDrawable.fromName(this, (String)flipPatternNameReplacement.inverse().get((Object)shapeName));
            }
        }
        return this;
    }

    private static /* synthetic */ List lambda$createListCodec$2(Supplier defaultSupplier, String string) {
        TextContext textContext = (TextContext)defaultSupplier.get();
        textContext.text = class_2561.method_43470((String)string);
        return Collections.singletonList(textContext);
    }
}

