/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.util;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.function.IntFunction;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_5819;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Contract;
import pers.solid.mishang.uc.util.ColorUtils;

public enum ColorMixtureType implements class_3542
{
    NORMAL("normal"){

        @Override
        public int handle(int original, int target, float amount, class_5819 random) {
            return target;
        }
    }
    ,
    RANDOM("random"){

        @Override
        public int handle(int original, int target, float amount, class_5819 random) {
            return random.method_43048(0x1000000);
        }
    }
    ,
    INVERT("invert"){

        @Override
        public int handle(int original, int target, float amount, class_5819 random) {
            return 0xFFFFFF - (0xFFFFFF & original);
        }
    }
    ,
    HUE("hue"){

        @Override
        public int handle(int original, int target, float amount, class_5819 random) {
            Color originalColor = new Color(original);
            Color targetColor = new Color(target);
            float[] originalHsl = ColorUtils.rgbToHsl(originalColor.getRed(), originalColor.getGreen(), originalColor.getBlue());
            float[] targetHsl = ColorUtils.rgbToHsl(targetColor.getRed(), targetColor.getGreen(), targetColor.getBlue());
            return ColorUtils.hslToRgb(targetHsl[0], originalHsl[1], originalHsl[2]) & 0xFFFFFF;
        }
    }
    ,
    HUE_AND_SATURATION("hue_and_saturation"){

        @Override
        public int handle(int original, int target, float amount, class_5819 random) {
            Color originalColor = new Color(original);
            Color targetColor = new Color(target);
            float[] originalHsl = ColorUtils.rgbToHsl(originalColor.getRed(), originalColor.getGreen(), originalColor.getBlue());
            float[] targetHsl = ColorUtils.rgbToHsl(targetColor.getRed(), targetColor.getGreen(), targetColor.getBlue());
            return ColorUtils.hslToRgb(targetHsl[0], targetHsl[1], originalHsl[2]) & 0xFFFFFF;
        }
    }
    ,
    HUE_ROTATE("hue_rotate"){

        @Override
        public int handle(int original, int target, float amount, class_5819 random) {
            Color originalColor = new Color(original);
            float[] originalHsl = ColorUtils.rgbToHsl(originalColor.getRed(), originalColor.getGreen(), originalColor.getBlue());
            return ColorUtils.hslToRgb(originalHsl[0] + amount, originalHsl[1], originalHsl[2]) & 0xFFFFFF;
        }
    }
    ,
    SATURATION_CHANGE("saturation_change"){

        @Override
        public int handle(int original, int target, float amount, class_5819 random) {
            Color originalColor = new Color(original);
            float[] originalHsl = ColorUtils.rgbToHsl(originalColor.getRed(), originalColor.getGreen(), originalColor.getBlue());
            return ColorUtils.hslToRgb(originalHsl[0], Math.clamp(originalHsl[1] + amount, 0.0f, 1.0f), originalHsl[2]) & 0xFFFFFF;
        }
    }
    ,
    BRIGHTNESS_CHANGE("brightness_change"){

        @Override
        public int handle(int original, int target, float amount, class_5819 random) {
            Color originalColor = new Color(original);
            float[] originalHsl = ColorUtils.rgbToHsl(originalColor.getRed(), originalColor.getGreen(), originalColor.getBlue());
            return ColorUtils.hslToRgb(originalHsl[0], originalHsl[1], Math.clamp(originalHsl[2] + amount, 0.0f, 1.0f)) & 0xFFFFFF;
        }
    };

    public static final Codec<ColorMixtureType> CODEC;
    public static final class_9139<ByteBuf, ColorMixtureType> PACKET_CODEC;
    private final String name;
    private final class_2561 translatableName;

    private ColorMixtureType(String name) {
        this.name = name;
        this.translatableName = class_2561.method_43471((String)("item.mishanguc.color_tool.mixture_type." + name));
    }

    public String method_15434() {
        return this.name;
    }

    public abstract int handle(int var1, int var2, float var3, class_5819 var4);

    public class_2561 getName() {
        return this.translatableName;
    }

    @Contract(pure=true)
    public boolean requiresTargetColor() {
        return switch (this.ordinal()) {
            case 0, 3, 4 -> true;
            default -> false;
        };
    }

    @Contract(pure=true)
    public boolean hasInvertEffect() {
        return switch (this.ordinal()) {
            case 5, 6, 7 -> true;
            default -> false;
        };
    }

    static {
        CODEC = class_3542.method_28140(ColorMixtureType::values);
        PACKET_CODEC = class_9135.method_56375((IntFunction)class_7995.method_47914(Enum::ordinal, (Object[])ColorMixtureType.values(), (class_7995.class_7996)class_7995.class_7996.field_41665), Enum::ordinal);
    }
}

