/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.util;

import net.minecraft.class_3532;
import pers.solid.mishang.uc.Mishanguc;

public final class ColorUtils {
    public static final float MaxRGB = 255.0f;

    public static float[] rgbToHsl(int red, int green, int blue) {
        float r = (float)red / 255.0f;
        float g = (float)green / 255.0f;
        float b = (float)blue / 255.0f;
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        float hue = 0.0f;
        float saturation = 0.0f;
        float luminosity = (min + max) / 2.0f;
        float delta = max - min;
        if ((double)delta == 0.0) {
            return new float[]{hue, saturation, luminosity};
        }
        saturation = delta / (luminosity <= 0.5f ? min + max : 2.0f - max - min);
        hue = r == max ? (g == min ? 5.0f + (max - b) / delta : 1.0f - (max - g) / delta) : (g == max ? (b == min ? 1.0f + (max - r) / delta : 3.0f - (max - b) / delta) : (r == min ? 3.0f + (max - g) / delta : 5.0f - (max - r) / delta));
        return new float[]{hue /= 6.0f, saturation, luminosity};
    }

    public static int hslToRgb(float hue, float saturation, float luminosity) {
        int blue;
        int green;
        int red;
        float v;
        float f = v = luminosity <= 0.5f ? luminosity * (1.0f + saturation) : luminosity + saturation - luminosity * saturation;
        if ((double)saturation == 0.0) {
            red = (int)(255.0f * luminosity + 0.5f);
            green = (int)(255.0f * luminosity + 0.5f);
            blue = (int)(255.0f * luminosity + 0.5f);
        } else {
            float g;
            float r;
            float y = 2.0f * luminosity - v;
            hue = class_3532.method_15341((float)hue, (float)1.0f);
            float x = y + (v - y) * (6.0f * hue - (float)class_3532.method_15375((float)(6.0f * hue)));
            float z = v - (v - y) * (6.0f * hue - (float)class_3532.method_15375((float)(6.0f * hue)));
            float b = switch ((int)(6.0f * hue)) {
                case 1 -> {
                    r = z;
                    g = v;
                    yield y;
                }
                case 2 -> {
                    r = y;
                    g = v;
                    yield x;
                }
                case 3 -> {
                    r = y;
                    g = z;
                    yield v;
                }
                case 4 -> {
                    r = x;
                    g = y;
                    yield v;
                }
                case 5 -> {
                    r = v;
                    g = y;
                    yield z;
                }
                default -> {
                    r = v;
                    g = x;
                    yield y;
                }
            };
            red = (int)((double)(255.0f * r) + 0.5);
            green = (int)((double)(255.0f * g) + 0.5);
            blue = (int)((double)(255.0f * b) + 0.5);
        }
        if (red > 255 || green > 255 || blue > 255) {
            Mishanguc.MISHANG_LOGGER.warn("rgb = {} {} {}", new Object[]{red, green, blue});
        }
        return red << 16 | green << 8 | blue;
    }
}

