/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.itemcolorizer.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.numbits.itemcolorizer.screen.ColorPickerScreen;
import dev.numbits.itemcolorizer.utils.GuiOpener;
import dev.numbits.itemcolorizer.utils.ItemColorRegistry;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2287;
import net.minecraft.class_2290;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7157;

public final class ItemColorizerCommands {
    private ItemColorizerCommands() {
    }

    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register(ItemColorizerCommands::registerImpl);
        System.out.println("[ItemColorizer] ClientCommandRegistrationCallback registered");
    }

    private static void registerImpl(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        System.out.println("[ItemColorizer] registerImpl called");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"itemcolorizer").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"item", (ArgumentType)class_2287.method_9776((class_7157)registryAccess)).executes(ctx -> {
            class_1792 item = ItemColorizerCommands.getItemFromCtx((FabricClientCommandSource)ctx.getSource(), "add", (CommandContext<FabricClientCommandSource>)ctx);
            if (item == null) {
                return 0;
            }
            ItemColorizerCommands.openPicker(item);
            String name = ItemColorizerCommands.getReadableItemName(item);
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77[ItemColorizer\u00a77] \u00a7fEditing color for \u00a7b" + name)));
            return 1;
        })))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"item", (ArgumentType)class_2287.method_9776((class_7157)registryAccess)).executes(ctx -> {
            class_1792 item = ItemColorizerCommands.getItemFromCtx((FabricClientCommandSource)ctx.getSource(), "remove", (CommandContext<FabricClientCommandSource>)ctx);
            if (item == null) {
                return 0;
            }
            ItemColorRegistry.remove(item);
            String name = ItemColorizerCommands.getReadableItemName(item);
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77[ItemColorizer\u00a77] \u00a7fRemoved color for \u00a7b" + name)));
            return 1;
        })))).then(ClientCommandManager.literal((String)"on").then(ClientCommandManager.argument((String)"item", (ArgumentType)class_2287.method_9776((class_7157)registryAccess)).executes(ctx -> {
            class_1792 item = ItemColorizerCommands.getItemFromCtx((FabricClientCommandSource)ctx.getSource(), "on", (CommandContext<FabricClientCommandSource>)ctx);
            if (item == null) {
                return 0;
            }
            ItemColorRegistry.setEnabled(item, true);
            String name = ItemColorizerCommands.getReadableItemName(item);
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77[ItemColorizer\u00a77] \u00a7aEnabled \u00a7fcolor for \u00a7b" + name)));
            return 1;
        })))).then(ClientCommandManager.literal((String)"off").then(ClientCommandManager.argument((String)"item", (ArgumentType)class_2287.method_9776((class_7157)registryAccess)).executes(ctx -> {
            class_1792 item = ItemColorizerCommands.getItemFromCtx((FabricClientCommandSource)ctx.getSource(), "off", (CommandContext<FabricClientCommandSource>)ctx);
            if (item == null) {
                return 0;
            }
            ItemColorRegistry.setEnabled(item, false);
            String name = ItemColorizerCommands.getReadableItemName(item);
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77[ItemColorizer\u00a77] \u00a7cDisabled \u00a7fcolor for \u00a7b" + name)));
            return 1;
        }))));
    }

    private static class_1792 getItemFromCtx(FabricClientCommandSource source, String sub, CommandContext<FabricClientCommandSource> ctx) {
        try {
            System.out.println("[ItemColorizer] /itemcolorizer " + sub + " executes");
            class_2290 arg = class_2287.method_9777(ctx, (String)"item");
            class_1792 item = arg.method_9785();
            if (item == null) {
                source.sendError((class_2561)class_2561.method_43470((String)"\u00a77[ItemColorizer\u00a77] \u00a7cInvalid item"));
                return null;
            }
            return item;
        }
        catch (Exception e) {
            e.printStackTrace();
            source.sendError((class_2561)class_2561.method_43470((String)("\u00a77[ItemColorizer\u00a77] \u00a7cUnexpected error: \u00a7f" + e.getClass().getSimpleName())));
            return null;
        }
    }

    private static String getReadableItemName(class_1792 item) {
        return new class_1799((class_1935)item).method_7964().getString();
    }

    private static void openPicker(class_1792 item) {
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            System.err.println("[ItemColorizer] MinecraftClient is null; cannot open screen");
            return;
        }
        GuiOpener.openWhenIdle(new ColorPickerScreen(item));
    }
}

