/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.itemcolorizer.screen;

import dev.numbits.itemcolorizer.utils.ItemColorRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7923;

public class ColorPickerScreen
extends class_437 {
    private final class_1792 targetItem;
    private int paletteX;
    private int paletteY;
    private final int paletteW = 160;
    private final int paletteH = 160;
    private final int hueBarW = 12;
    private final int hueBarGap = 6;
    private final int previewW = 24;
    private final int previewMargin = 12;
    private double hue = 0.0;
    private double sat = 1.0;
    private double val = 1.0;
    private float alpha = 1.0f;
    private int argb = -65536;
    private boolean draggingSV = false;
    private boolean draggingHue = false;

    public ColorPickerScreen(class_1792 targetItem) {
        super((class_2561)class_2561.method_43470((String)"Item Color Picker"));
        this.targetItem = targetItem;
        System.out.println("[ItemColorizer] ColorPickerScreen ctor for " + String.valueOf(class_7923.field_41178.method_10221((Object)targetItem)));
    }

    protected void method_25426() {
        super.method_25426();
        System.out.println("[ItemColorizer] ColorPickerScreen init, size " + this.field_22789 + "x" + this.field_22790);
        this.recalcPalettePos();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save & Exit"), b -> {
            ItemColorRegistry.setColor(this.targetItem, this.argb);
            if (this.field_22787 != null) {
                this.field_22787.method_1507(null);
            }
        }).method_46434(this.field_22789 / 2 - 45, this.paletteY + 160 + 10, 90, 20).method_46431());
    }

    private void recalcPalettePos() {
        this.paletteX = (this.field_22789 - 214) / 2;
        this.paletteY = (this.field_22790 - 160) / 2;
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.recalcPalettePos();
    }

    public void method_25420(class_332 ctx, int mouseX, int mouseY, float delta) {
        int hueX = this.paletteX + 160 + 6;
        int px = hueX + 12 + 12;
        int py = this.paletteY;
        int btnW = 90;
        int btnH = 20;
        int btnX = this.field_22789 / 2 - 45;
        int btnY = this.paletteY + 160 + 10;
        int pad = 8;
        int previewRight = px + 24;
        int contentLeft = Math.min(this.paletteX, btnX) - 8;
        int contentTop = this.paletteY - 32;
        int contentRight = Math.max(previewRight, btnX + 90) + 8;
        int contentBottom = Math.max(this.paletteY + 160, btnY + 20) + 8;
        this.dimOutside(ctx, contentLeft, contentTop, contentRight, contentBottom, -1610612736);
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        super.method_25420(ctx, mouseX, mouseY, delta);
        int hueX = this.paletteX + 160 + 6;
        int px = hueX + 12 + 12;
        int py = this.paletteY;
        int btnW = 90;
        int btnH = 20;
        int btnX = this.field_22789 / 2 - 45;
        int btnY = this.paletteY + 160 + 10;
        int pad = 8;
        int previewRight = px + 24;
        int contentLeft = Math.min(this.paletteX, btnX) - 8;
        int contentTop = this.paletteY - 32;
        int contentRight = Math.max(previewRight, btnX + 90) + 8;
        int contentBottom = Math.max(this.paletteY + 160, btnY + 20) + 8;
        ctx.method_25294(contentLeft, contentTop, contentRight, contentBottom, -267382768);
        ctx.method_25294(this.paletteX - 2, this.paletteY - 2, this.paletteX + 160 + 2, this.paletteY + 160 + 2, -14671840);
        this.renderSVPalette(ctx);
        ctx.method_25294(hueX - 2, this.paletteY - 2, hueX + 12 + 2, this.paletteY + 160 + 2, -14671840);
        this.renderHueBar(ctx, hueX);
        this.renderCheckerboard(ctx, px, py, 24, 24, 8);
        ctx.method_25294(px, py, px + 24, py + 24, this.argb);
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)("Color Picker for " + new class_1799((class_1935)this.targetItem).method_7964().getString())), this.field_22789 / 2, this.paletteY - 18, 0xFFFFFF);
        super.method_25394(ctx, mouseX, mouseY, delta);
    }

    private void dimOutside(class_332 ctx, int l, int t, int r, int b, int argb) {
        if (t > 0) {
            ctx.method_25294(0, 0, this.field_22789, t, argb);
        }
        if (b < this.field_22790) {
            ctx.method_25294(0, b, this.field_22789, this.field_22790, argb);
        }
        if (l > 0) {
            ctx.method_25294(0, t, l, b, argb);
        }
        if (r < this.field_22789) {
            ctx.method_25294(r, t, this.field_22789, b, argb);
        }
    }

    private void renderSVPalette(class_332 ctx) {
        for (int y = 0; y < 160; ++y) {
            double v = 1.0 - (double)y / 159.0;
            int baseY = this.paletteY + y;
            for (int x = 0; x < 160; ++x) {
                double s = (double)x / 159.0;
                int c = this.hsvToArgb(this.hue, s, v, 1.0f);
                int xx = this.paletteX + x;
                ctx.method_25294(xx, baseY, xx + 1, baseY + 1, c);
            }
        }
        int cx = this.paletteX + (int)Math.round(this.sat * 159.0);
        int cy = this.paletteY + (int)Math.round((1.0 - this.val) * 159.0);
        this.drawCrosshair(ctx, cx, cy);
    }

    private void renderHueBar(class_332 ctx, int hueX) {
        for (int y = 0; y < 160; ++y) {
            double h = (double)y / 159.0;
            int c = this.hsvToArgb(h, 1.0, 1.0, 1.0f);
            int yy = this.paletteY + y;
            ctx.method_25294(hueX, yy, hueX + 12, yy + 1, c);
        }
        int sy = this.paletteY + (int)Math.round(this.hue * 159.0);
        ctx.method_25294(hueX - 2, sy - 1, hueX + 12 + 2, sy + 1, -1);
        ctx.method_25294(hueX - 1, sy, hueX + 12 + 1, sy, -16777216);
    }

    private void renderCheckerboard(class_332 ctx, int x, int y, int w, int h, int cell) {
        int x2 = x + w;
        int y2 = y + h;
        for (int yy = y; yy < y2; yy += cell) {
            for (int xx = x; xx < x2; xx += cell) {
                boolean odd = ((xx - x) / cell + (yy - y) / cell) % 2 == 1;
                int col = odd ? -4210753 : -1052689;
                ctx.method_25294(xx, yy, Math.min(xx + cell, x2), Math.min(yy + cell, y2), col);
            }
        }
        ctx.method_25294(x - 1, y - 1, x + w + 1, y, -14671840);
        ctx.method_25294(x - 1, y + h, x + w + 1, y + h + 1, -14671840);
        ctx.method_25294(x - 1, y, x, y + h, -14671840);
        ctx.method_25294(x + w, y, x + w + 1, y + h, -14671840);
    }

    private void drawCrosshair(class_332 ctx, int cx, int cy) {
        int r = 4;
        int c1 = -1;
        int c2 = -16777216;
        ctx.method_25294(cx - r - 1, cy, cx + r + 2, cy + 1, c2);
        ctx.method_25294(cx, cy - r - 1, cx + 1, cy + r + 2, c2);
        ctx.method_25294(cx - r, cy, cx + r + 1, cy + 1, c1);
        ctx.method_25294(cx, cy - r, cx + 1, cy + r + 1, c1);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isInsideSV(mouseX, mouseY)) {
            this.draggingSV = true;
            this.pickSV(mouseX, mouseY);
            return true;
        }
        if (this.isInsideHue(mouseX, mouseY)) {
            this.draggingHue = true;
            this.pickHue(mouseX, mouseY);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.draggingSV) {
            this.pickSV(mouseX, mouseY);
            return true;
        }
        if (this.draggingHue) {
            this.pickHue(mouseX, mouseY);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dx, dy);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingSV = false;
        this.draggingHue = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(null);
        }
    }

    public boolean method_25421() {
        return false;
    }

    private boolean isInsideSV(double mx, double my) {
        return mx >= (double)this.paletteX && mx < (double)(this.paletteX + 160) && my >= (double)this.paletteY && my < (double)(this.paletteY + 160);
    }

    private boolean isInsideHue(double mx, double my) {
        int hueX = this.paletteX + 160 + 6;
        return mx >= (double)hueX && mx < (double)(hueX + 12) && my >= (double)this.paletteY && my < (double)(this.paletteY + 160);
    }

    private void pickSV(double mx, double my) {
        double rx = ColorPickerScreen.clamp01((mx - (double)this.paletteX) / 160.0);
        double ry = ColorPickerScreen.clamp01((my - (double)this.paletteY) / 160.0);
        this.sat = rx;
        this.val = 1.0 - ry;
        this.argb = this.hsvToArgb(this.hue, this.sat, this.val, this.alpha);
    }

    private void pickHue(double mx, double my) {
        double ry;
        this.hue = ry = ColorPickerScreen.clamp01((my - (double)this.paletteY) / 160.0);
        this.argb = this.hsvToArgb(this.hue, this.sat, this.val, this.alpha);
    }

    private static double clamp01(double v) {
        return v < 0.0 ? 0.0 : Math.min(1.0, v);
    }

    private int hsvToArgb(double hNorm, double s, double v, float a) {
        float[] rgb = this.hsvToRgb((float)(hNorm * 360.0), (float)s, (float)v);
        int ai = (int)(a * 255.0f) & 0xFF;
        int ri = (int)(rgb[0] * 255.0f) & 0xFF;
        int gi = (int)(rgb[1] * 255.0f) & 0xFF;
        int bi = (int)(rgb[2] * 255.0f) & 0xFF;
        return ai << 24 | ri << 16 | gi << 8 | bi;
    }

    private float[] hsvToRgb(float h, float s, float v) {
        float b1;
        float g1;
        float r1;
        float c = v * s;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        float m = v - c;
        if (h < 60.0f) {
            r1 = c;
            g1 = x;
            b1 = 0.0f;
        } else if (h < 120.0f) {
            r1 = x;
            g1 = c;
            b1 = 0.0f;
        } else if (h < 180.0f) {
            r1 = 0.0f;
            g1 = c;
            b1 = x;
        } else if (h < 240.0f) {
            r1 = 0.0f;
            g1 = x;
            b1 = c;
        } else if (h < 300.0f) {
            r1 = x;
            g1 = 0.0f;
            b1 = c;
        } else {
            r1 = c;
            g1 = 0.0f;
            b1 = x;
        }
        return new float[]{r1 + m, g1 + m, b1 + m};
    }
}

