/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.itemcolorizer.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public final class ItemColorRegistry {
    private static final String FILE_NAME = "itemcolorizer.json";
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("itemcolorizer.json");
    private static final Map<class_2960, Entry> COLORS = new HashMap<class_2960, Entry>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Entry.class, (Object)new EntryAdapter()).create();

    private ItemColorRegistry() {
    }

    public static void setColor(class_1792 item, int argb) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        Entry e = COLORS.get(id);
        if (e == null) {
            e = new Entry(argb, true);
            COLORS.put(id, e);
        } else {
            e.argb = argb;
        }
        ItemColorRegistry.save();
    }

    public static void remove(class_1792 item) {
        COLORS.remove(class_7923.field_41178.method_10221((Object)item));
        ItemColorRegistry.save();
    }

    public static void setEnabled(class_1792 item, boolean enabled) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        Entry e = COLORS.get(id);
        if (e != null) {
            e.enabled = enabled;
            ItemColorRegistry.save();
        }
    }

    public static Integer getActiveColor(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return null;
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        Entry e = COLORS.get(id);
        if (e == null || !e.enabled) {
            return null;
        }
        return e.argb;
    }

    public static void load() {
        COLORS.clear();
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            ItemColorRegistry.save();
            return;
        }
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(CONFIG_PATH, new OpenOption[0]), StandardCharsets.UTF_8);){
            JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (root.has("items") && root.get("items").isJsonObject()) {
                JsonObject itemsObj = root.getAsJsonObject("items");
                for (Map.Entry entry : itemsObj.entrySet()) {
                    Entry e;
                    class_2960 id = class_2960.method_12829((String)((String)entry.getKey()));
                    if (id == null || (e = (Entry)GSON.fromJson((JsonElement)entry.getValue(), Entry.class)) == null) continue;
                    COLORS.put(id, e);
                }
            }
            System.out.println("[ItemColorizer] Loaded " + COLORS.size() + " entries");
        }
        catch (Exception e) {
            System.err.println("[ItemColorizer] Failed to load config: " + e.getMessage());
        }
    }

    public static void save() {
        try {
            JsonObject root = new JsonObject();
            JsonObject itemsObj = new JsonObject();
            for (Map.Entry<class_2960, Entry> mapEntry : COLORS.entrySet()) {
                itemsObj.add(mapEntry.getKey().toString(), GSON.toJsonTree((Object)mapEntry.getValue(), Entry.class));
            }
            root.add("items", (JsonElement)itemsObj);
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(CONFIG_PATH, new OpenOption[0]), StandardCharsets.UTF_8);){
                GSON.toJson((JsonElement)root, (Appendable)writer);
            }
            System.out.println("[ItemColorizer] Saved " + COLORS.size() + " entries");
        }
        catch (Exception e) {
            System.err.println("[ItemColorizer] Failed to save config: " + e.getMessage());
        }
    }

    public static class Entry {
        public int argb;
        public boolean enabled;

        public Entry(int argb, boolean enabled) {
            this.argb = argb;
            this.enabled = enabled;
        }
    }

    private static class EntryAdapter
    implements JsonSerializer<Entry>,
    JsonDeserializer<Entry> {
        private EntryAdapter() {
        }

        public JsonElement serialize(Entry src, Type t, JsonSerializationContext c) {
            JsonObject obj = new JsonObject();
            obj.addProperty("color", (Number)src.argb);
            obj.addProperty("enabled", Boolean.valueOf(src.enabled));
            return obj;
        }

        public Entry deserialize(JsonElement json, Type t, JsonDeserializationContext c) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int color = obj.has("color") ? obj.get("color").getAsInt() : -2130771968;
            boolean enabled = !obj.has("enabled") || obj.get("enabled").getAsBoolean();
            return new Entry(color, enabled);
        }
    }
}

