/*
 * Decompiled with CFR 0.152.
 */
package net.legacy.legacies_and_legends.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.legacy.legacies_and_legends.registry.LaLTrimMaterials;
import net.minecraft.class_2960;
import net.ramixin.mixson.inline.EventContext;
import net.ramixin.mixson.inline.Mixson;
import net.ramixin.mixson.inline.MixsonEvent;
import net.ramixin.mixson.inline.ResourceReference;

public final class LaLTrimItemModels {
    private static final List<String> ARMORS = List.of("helmet", "chestplate", "leggings", "boots");
    private static final List<String> ARMOR_MATERIALS = List.of("leather", "chainmail", "iron", "golden", "diamond", "netherite");

    private LaLTrimItemModels() {
    }

    public static void init() {
        ARMORS.forEach(armor -> ARMOR_MATERIALS.forEach(armorMaterial -> LaLTrimItemModels.registerAddTrimsToArmor(armor, armorMaterial)));
        LaLTrimItemModels.registerAddTrimsToArmor("helmet", "turtle");
        LaLTrimItemModels.registerAddTrimsToAtlas("armor_trims");
        LaLTrimItemModels.registerAddTrimsToAtlas("blocks");
    }

    private static void registerAddTrimsToArmor(final String armor, final String armorMaterial) {
        Mixson.registerEvent((int)1000, (String)("minecraft:items/" + armorMaterial + "_" + armor), (String)("legacies_and_legends:add_trims_to_" + armorMaterial + "_" + armor), (MixsonEvent)new MixsonEvent<JsonElement>(){

            public void runEvent(EventContext<JsonElement> context) {
                JsonElement elem = (JsonElement)context.getFile();
                JsonObject root = elem.getAsJsonObject();
                JsonObject model = root.getAsJsonObject("model");
                JsonArray cases = model.getAsJsonArray("cases");
                JsonObject case0 = cases.get(0).getAsJsonObject();
                LaLTrimMaterials.TRIM_MATERIALS.forEach(trim -> {
                    JsonObject newCase = case0.deepCopy();
                    newCase.addProperty("when", LaLTrimItemModels.trimMaterialId(trim).toString());
                    newCase.getAsJsonObject("model").addProperty("model", LaLTrimItemModels.itemModelId(armor, armorMaterial, trim).toString());
                    cases.add((JsonElement)newCase);
                });
            }

            public int ordinal() {
                return 0;
            }
        }, (boolean)false, (ResourceReference[])new ResourceReference[0]);
    }

    private static void registerAddTrimsToAtlas(String name) {
        Mixson.registerEvent((int)1000, (String)("minecraft:atlases/" + name), (String)("legacies_and_legends:add_trims_to_" + name + "_atlas"), (MixsonEvent)new MixsonEvent<JsonElement>(){

            public void runEvent(EventContext<JsonElement> context) {
                JsonElement elem = (JsonElement)context.getFile();
                JsonObject root = elem.getAsJsonObject();
                JsonArray sources = root.getAsJsonArray("sources");
                for (int i = 0; i < sources.size(); ++i) {
                    JsonObject source = sources.get(i).getAsJsonObject();
                    if (!"minecraft:paletted_permutations".equals(source.getAsJsonPrimitive("type").getAsString())) continue;
                    JsonObject permutations = source.getAsJsonObject("permutations");
                    LaLTrimMaterials.TRIM_MATERIALS.forEach(trim -> permutations.addProperty(trim, LaLTrimItemModels.paletteId(trim).toString()));
                    break;
                }
            }

            public int ordinal() {
                return 0;
            }
        }, (boolean)false, (ResourceReference[])new ResourceReference[0]);
    }

    private static class_2960 trimMaterialId(String trim) {
        return class_2960.method_60655((String)"legacies_and_legends", (String)trim);
    }

    private static class_2960 itemModelId(String armor, String armorMaterial, String trim) {
        return class_2960.method_60655((String)"legacies_and_legends", (String)("item/" + armorMaterial + "_" + armor + "_" + trim + "_trim"));
    }

    private static class_2960 paletteId(String trim) {
        return class_2960.method_60655((String)"legacies_and_legends", (String)("trims/color_palettes/" + trim));
    }
}

