/*
 * Decompiled with CFR 0.152.
 */
package io.github.paulem.attackthrough;

import com.google.common.primitives.Doubles;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AttackThrough
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private final int DEFAULT_REACH = 4;
    private final double DEFAULT_RAY_SIZE = 0.2;

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.getLogger().info("Enabled !");
    }

    public void onDisable() {
        this.getLogger().info("Disabled !");
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null) {
            return;
        }
        @Nullable ItemStack itemInHand = event.getItem();
        if (itemInHand == null) {
            itemInHand = new ItemStack(Material.AIR);
        }
        if (this.config.getBoolean("onlyForTools", false) && !EnchantmentTarget.TOOL.includes(itemInHand)) {
            return;
        }
        if (clickedBlock.isPassable() && !clickedBlock.getType().isInteractable()) {
            Player player = event.getPlayer();
            Location clickedBlockLoc = clickedBlock.getLocation();
            Location playerEyeLoc = player.getEyeLocation();
            RayTraceResult result = clickedBlock.getWorld().rayTraceEntities(clickedBlockLoc, playerEyeLoc.getDirection(), Doubles.constrainToRange((double)((double)this.config.getInt("reach", 4) - clickedBlockLoc.distance(playerEyeLoc)), (double)0.0, (double)this.config.getInt("reach", 4)), this.config.getDouble("raySize", 0.2), entity -> entity instanceof Damageable);
            if (result == null) {
                return;
            }
            Entity hitEntity = result.getHitEntity();
            if (hitEntity != null && !hitEntity.equals(player)) {
                boolean sweepin = AttackThrough.isSword(itemInHand);
                if (sweepin) {
                    player.swingMainHand();
                }
                if (!player.hasCooldown(itemInHand.getType())) {
                    player.attack(hitEntity);
                }
                double itemAttackSpeed = 4.0;
                AttributeInstance playerAttackSpeed = player.getAttribute(Attribute.GENERIC_ATTACK_SPEED);
                if (playerAttackSpeed != null) {
                    itemAttackSpeed = playerAttackSpeed.getValue();
                }
                int ticks = AttackThrough.getAttackSpeedTicks(itemAttackSpeed);
                player.setCooldown(itemInHand.getType(), ticks);
                event.setCancelled(true);
            }
        }
    }

    public static int getAttackSpeedTicks(@NotNull Double attackSpeed) {
        return (int)(20.0 / attackSpeed);
    }

    public static boolean isSword(@Nullable ItemStack is) {
        return is != null && is.getType().name().contains("SWORD");
    }
}

