/*
 * Decompiled with CFR 0.152.
 */
package com.thanatoros.betterallay.config;

import com.thanatoros.betterallay.config.ModConfigs;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BetterAllayConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"BetterAllayConfig");
    private final HashMap<String, String> config = new HashMap();
    private final ConfigRequest request;
    private boolean broken = false;

    public static ConfigRequest of(String filename) {
        Path path = Path.of("config", new String[0]);
        return new ConfigRequest(path.resolve(filename + ".properties").toFile(), filename);
    }

    private void createConfig() throws IOException {
        this.request.file.getParentFile().mkdirs();
        Files.createFile(this.request.file.toPath(), new FileAttribute[0]);
        PrintWriter writer = new PrintWriter(this.request.file, "UTF-8");
        writer.write(this.request.getConfig());
        writer.close();
    }

    private void addMissingToConfig() throws IOException {
    }

    private void loadConfig() throws IOException {
        Scanner reader = new Scanner(this.request.file);
        int line = 1;
        while (reader.hasNextLine()) {
            this.parseConfigEntry(reader.nextLine(), line);
            ++line;
        }
    }

    private void parseConfigEntry(String entry, int line) {
        if (!entry.isEmpty() && !entry.startsWith("#")) {
            String[] parts = entry.split("=", 2);
            if (parts.length == 2) {
                String temp = parts[1].split(" #")[0];
                this.config.put(parts[0], temp);
            } else {
                throw new RuntimeException("Syntax error in config file on line " + line + "!");
            }
        }
    }

    private BetterAllayConfig(ConfigRequest request) {
        this.request = request;
        String identifier = "Config '" + request.filename + "'";
        if (!request.file.exists()) {
            LOGGER.info(identifier + " is missing, generating default one...");
            try {
                this.createConfig();
            }
            catch (IOException e) {
                LOGGER.error(identifier + " failed to generate!");
                LOGGER.trace((Object)e);
                this.broken = true;
            }
        }
        if (!this.broken) {
            try {
                this.loadConfig();
            }
            catch (Exception e) {
                LOGGER.error(identifier + " failed to load!");
                LOGGER.trace((Object)e);
                this.broken = true;
            }
        }
    }

    @Deprecated
    public String get(String key) {
        return this.config.get(key);
    }

    public String getOrDefault(String key, String def) throws IOException {
        String val = this.get(key);
        if (val != null) {
            return val;
        }
        PrintWriter writer = new PrintWriter(new FileWriter(this.request.file, true));
        for (String line : ModConfigs.configsStrings) {
            if (!line.contains(key)) continue;
            writer.write(line + "\n");
            writer.close();
            break;
        }
        return def;
    }

    public int getOrDefault(String key, int def) throws IOException {
        try {
            return Integer.parseInt(this.get(key));
        }
        catch (Exception e) {
            String val = this.get(key);
            if (val == null) {
                PrintWriter writer = new PrintWriter(new FileWriter(this.request.file, true));
                for (String line : ModConfigs.configsStrings) {
                    if (!line.contains(key)) continue;
                    writer.write(line + "\n");
                    writer.close();
                    break;
                }
            }
            return def;
        }
    }

    public void checkRepairConfigDescriptions() throws IOException {
        String content = new String(Files.readAllBytes(this.request.file.toPath()));
        content = content.replaceAll("foo", "bar");
        int count = 0;
        for (String line : ModConfigs.descStrings) {
            LOGGER.debug(line);
            if (!content.contains(line)) {
                LOGGER.debug(line);
                int count2 = 0;
                for (String line2 : ModConfigs.oldDescStrings[count]) {
                    if (content.contains(line2)) {
                        LOGGER.debug(line2);
                        content = content.replace(ModConfigs.oldDescStrings[count][count2], line);
                        LOGGER.debug(ModConfigs.oldDescStrings[count][count2]);
                    }
                    ++count2;
                }
            }
            ++count;
        }
        Files.write(this.request.file.toPath(), content.getBytes(), new OpenOption[0]);
    }

    public void commandChange(String oldString, String newString) throws IOException {
        String content = new String(Files.readAllBytes(this.request.file.toPath()));
        if ((content = content.replaceAll("foo", "bar")).contains(oldString)) {
            LOGGER.debug(oldString);
            content = content.replace(oldString, newString);
            LOGGER.debug(newString);
        }
        Files.write(this.request.file.toPath(), content.getBytes(), new OpenOption[0]);
    }

    public Path getFilePath() throws IOException {
        return this.request.file.toPath();
    }

    public boolean getOrDefault(String key, boolean def) throws IOException {
        String val = this.get(key);
        if (val != null) {
            return val.equalsIgnoreCase("true");
        }
        PrintWriter writer = new PrintWriter(new FileWriter(this.request.file, true));
        for (String line : ModConfigs.configsStrings) {
            if (!line.contains(key)) continue;
            writer.write(line + "\n");
            writer.close();
            break;
        }
        return def;
    }

    public double getOrDefault(String key, double def) {
        try {
            return Double.parseDouble(this.get(key));
        }
        catch (Exception e) {
            return def;
        }
    }

    public boolean isBroken() {
        return this.broken;
    }

    public boolean delete() {
        LOGGER.warn("Config '" + this.request.filename + "' was removed from existence! Restart the game to regenerate it.");
        return this.request.file.delete();
    }

    public static class ConfigRequest {
        private final File file;
        private final String filename;
        private DefaultConfig provider;

        private ConfigRequest(File file, String filename) {
            this.file = file;
            this.filename = filename;
            this.provider = DefaultConfig::empty;
        }

        public ConfigRequest provider(DefaultConfig provider) {
            this.provider = provider;
            return this;
        }

        public BetterAllayConfig request() {
            return new BetterAllayConfig(this);
        }

        private String getConfig() {
            return this.provider.get(this.filename) + "\n";
        }
    }

    public static interface DefaultConfig {
        public String get(String var1);

        public static String empty(String namespace) {
            return "";
        }
    }
}

