package archives.tater.offhandhotbar;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_465;
import net.minecraft.class_481.class_483;
import net.minecraft.class_636;
import net.minecraft.class_746;
import eu.midnightdust.lib.config.MidnightConfig;
import org.lwjgl.glfw.GLFW;

import static net.minecraft.class_156.method_646;

public class OffhandHotbar implements ModInitializer, ClientModInitializer {
	public static final String MOD_ID = "offhandhotbar";

	public static int selectedOffhandSlot = 0;
	private static int lastOffhandSlot = selectedOffhandSlot;
	public static boolean swapped = true;
	public static boolean focusSwapped = false;

	public static final int OFFHAND_SWAP_ID = 40;
	public static final int SLOTS_OFFSET = 18;

	public static final int HOTBAR_WIDTH = 91;
	public static final int HOTBAR_GAP = 4;
	public static final int HOTBAR_X_OFFSET = HOTBAR_WIDTH + HOTBAR_GAP / 2;
	public static final int HOTBAR_HEIGHT = 22;
	public static final int HOTBAR_Y_OFFSET = -(HOTBAR_HEIGHT + HOTBAR_GAP);

	private static final int[] forwardSlotOrder = {0, 9, 18, 0};
	private static final int[] backwardSlotOrder = {18, 9, 0, 18};

	public static final class_304.class_11900 KEY_CATEGORY = class_304.class_11900.method_74698(class_2960.method_60655(MOD_ID, "offhandhotbar"));

	public static final class_304 CONTROL_OPPOSITE_KEY = KeyBindingHelper.registerKeyBinding(new class_304(
			method_646("key", class_2960.method_60655(MOD_ID, "control_opposite")),
			class_3675.class_307.field_1668,
			GLFW.GLFW_KEY_LEFT_ALT,
			KEY_CATEGORY
	));

	public static final class_304 SCROLL_INVENTORY_KEY = KeyBindingHelper.registerKeyBinding(new class_304(
			method_646("key", class_2960.method_60655(MOD_ID, "scroll_inventory")),
			class_3675.class_307.field_1668,
			GLFW.GLFW_KEY_R,
			KEY_CATEGORY
	));

	public static int getOffhandHotbarSlot(int selectedSlot) {
		return class_1723.field_30808 + SLOTS_OFFSET + selectedSlot;
	}

	public static int getOffhandHotbarScreenHandlerSlot(int selectedSlot, class_310 client) {
		var player = client.field_1724;
		if (player == null) return -1;
		var playerSlot = getOffhandHotbarSlot(selectedSlot);
		var currentScreenHandler = player.field_7512;
		if (currentScreenHandler == null || currentScreenHandler instanceof class_1723 || currentScreenHandler instanceof class_483)
			return playerSlot;
		return currentScreenHandler.method_37418(player.method_31548(), playerSlot).orElse(-1);
	}

	public static void offhandCycle(class_310 client, int slot1, int slot2) {
		if (slot1 == -1 || slot2 == -1) return;
		var interactionManager = client.field_1761;
		if (interactionManager == null) return;
		var player = client.field_1724;
		if (player == null) return;
		offhandCycle(interactionManager, player, slot1, slot2);
	}

	public static void offhandCycle(class_636 interactionManager, class_746 player, int slot1, int slot2) {
		interactionManager.method_2906(player.field_7498.field_7763, slot1, OFFHAND_SWAP_ID, class_1713.field_7791, player);
		interactionManager.method_2906(player.field_7498.field_7763, slot2, OFFHAND_SWAP_ID, class_1713.field_7791, player);
	}

	public static void swapOffhand(class_310 client) {
		swapOffhand(client, getOffhandHotbarScreenHandlerSlot(selectedOffhandSlot, client));
	}

	public static void swapOffhand(class_310 client, int slot) {
		if (slot == -1) return;
		var interactionManager = client.field_1761;
		if (interactionManager == null) return;
		var player = client.field_1724;
		if (player == null) return;
		swapOffhand(interactionManager, player, slot);
	}

	public static void swapOffhand(class_636 interactionManager, class_746 player, int slot) {
		interactionManager.method_2906(player.field_7512.field_7763, slot, OFFHAND_SWAP_ID, class_1713.field_7791, player);
	}

	public static void updateOffhandSlots(class_310 client) {
        if (selectedOffhandSlot == lastOffhandSlot) return;
		if (client.field_1724 == null) return;

		var focusSwap = focusSwapped;
		if (focusSwap) updateFocusSwap(client, false);

        offhandCycle(client,
                getOffhandHotbarScreenHandlerSlot(lastOffhandSlot, client),
                getOffhandHotbarScreenHandlerSlot(selectedOffhandSlot, client));

		if (focusSwap) updateFocusSwap(client, true);

        lastOffhandSlot = selectedOffhandSlot;
    }

	public static void scrollInventory(class_310 client, boolean forward) {
		if (client.field_1724 == null) return;
		var interactionManager = client.field_1761;
		if (interactionManager == null) return;
		var syncId = client.field_1724.field_7498.field_7763;

		var focusSwap = focusSwapped;
		if (focusSwap) updateFocusSwap(client, false);

		swapOffhand(client);

		for (var i = 0; i < 9; i++) {
			for (var j : forward ? forwardSlotOrder : backwardSlotOrder)
				interactionManager.method_2906(syncId, class_1723.field_30808 + i + j, 0, class_1713.field_7790, client.field_1724);
		}

		swapOffhand(client);

		if (focusSwap) updateFocusSwap(client, true);
	}

	public static void updateFocusSwap(class_310 client, boolean swap) {
        if (swap == focusSwapped) return;
        focusSwapped = !focusSwapped;

        var player = client.field_1724;
        if (player == null) return;
        client.field_1761.method_2906(player.field_7498.field_7763, class_1723.field_30810 + player.method_31548().method_67532(), OFFHAND_SWAP_ID, class_1713.field_7791, player);
    }

	@Override
	public void onInitializeClient() {
		// This entrypoint is suitable for setting up client-specific logic, such as rendering.
		ClientTickEvents.END_CLIENT_TICK.register(client -> {
			updateOffhandSlots(client);

            if (client.field_1724 == null) return;

            if (!(client.field_1755 instanceof class_465<?>) || client.field_1724.field_7512 == null) {
                if (!swapped) {
                    swapOffhand(client);
                    swapped = !swapped;
                }

				updateFocusSwap(client, CONTROL_OPPOSITE_KEY.method_1434());
            } else {
                if (swapped) {
                    swapOffhand(client);
                    swapped = !swapped;
                }
            }
        });
		ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
			swapped = false;
			focusSwapped = false;
			selectedOffhandSlot = 0;
			lastOffhandSlot = 0;
		});
	}

	@Override
	public void onInitialize() {
		MidnightConfig.init(MOD_ID, OffhandHotbarConfig.class);
	}
}