package archives.tater.offhandhotbar.mixin.client;

import archives.tater.offhandhotbar.OffhandHotbar;
import archives.tater.offhandhotbar.OffhandHotbarConfig;
import archives.tater.offhandhotbar.OffhandHotbarConfig.DisplayMode;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static archives.tater.offhandhotbar.OffhandHotbar.getOffhandHotbarSlot;
import static net.minecraft.class_3532.field_29845;

@Mixin(class_329.class)
public abstract class InGameHudMixin {
	@Shadow
    protected abstract @Nullable class_1657 getCameraPlayer();

	@Inject(
			method = "renderMainHud",
			at = @At(value = "HEAD")
	)
	private void shiftHud(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
		if (!OffhandHotbarConfig.displayMode.isStacked()) return;
		context.method_51448().pushMatrix();
		context.method_51448().translate(0, OffhandHotbar.HOTBAR_Y_OFFSET);
	}

	@Inject(
			method = "renderMainHud",
			at = @At("TAIL")
	)
	private void unshiftHud(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
		if (!OffhandHotbarConfig.displayMode.isStacked()) return;
		context.method_51448().popMatrix();
	}

	@Unique
	private void offhandhotbar$hotbarRotate(class_332 context, boolean leftSide) {
		context.method_51448().translate(
				leftSide
						? context.method_51443()
						: context.method_51443() + context.method_51421() - OffhandHotbar.HOTBAR_HEIGHT,
				-(context.method_51421() - context.method_51443()) / 2f
		);
		context.method_51448().rotate(field_29845);
	}

	@WrapMethod(
			method = "renderHotbar"
	)
	private void shiftHotbar(class_332 context, class_9779 tickCounter, Operation<Void> original, @Share("offhand") LocalBooleanRef offhand) {
		var cameraPlayer = getCameraPlayer();
		var mainArm = cameraPlayer == null ? class_1306.field_6183 : cameraPlayer.method_6068();
		var mx = mainArm == class_1306.field_6183 ? 1 : -1;
		var matrices = context.method_51448();

		matrices.pushMatrix();
		switch (OffhandHotbarConfig.displayMode) {
			case SIDE_BY_SIDE -> matrices.translate(mx * OffhandHotbar.HOTBAR_X_OFFSET, 0);
			case STACKED -> {
				matrices.pushMatrix();
				matrices.translate(0, -OffhandHotbar.HOTBAR_Y_OFFSET);
			}
			case VERTICAL_SWAPPED -> {
				matrices.pushMatrix();
				offhandhotbar$hotbarRotate(context, mainArm == class_1306.field_6182);
			}
		}
		offhand.set(false);
		original.call(context, tickCounter);
		switch (OffhandHotbarConfig.displayMode) {
			case SIDE_BY_SIDE -> matrices.translate(-mx * OffhandHotbar.HOTBAR_X_OFFSET * 2, 0);
			case STACKED, VERTICAL_SWAPPED -> matrices.popMatrix();
			case STACKED_SWAPPED -> matrices.translate(0, -OffhandHotbar.HOTBAR_Y_OFFSET);
			case VERTICAL -> {
				offhandhotbar$hotbarRotate(context, mainArm == class_1306.field_6183);
			}
        }
		offhand.set(true);
		original.call(context, tickCounter);
		matrices.popMatrix();
	}

	@WrapOperation(
			method = "renderHotbar",
			slice = @Slice(
					from = @At(value = "FIELD", target = "Lnet/minecraft/client/gui/hud/InGameHud;HOTBAR_SELECTION_TEXTURE:Lnet/minecraft/util/Identifier;")
			),
			at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawGuiTexture(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/util/Identifier;IIII)V", ordinal = 0)
	)
	private void fixSelectionBottomBorder(class_332 instance, RenderPipeline pipeline, class_2960 sprite, int x, int y, int width, int height, Operation<Void> original) {
		original.call(instance, pipeline, sprite, x, y, width, height);
		instance.method_70846(pipeline, sprite, 24, 23, 0, 0, x, y + height, width, 1);
	}

	@WrapOperation(
			method = "renderHotbar",
			at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/hud/InGameHud;renderHotbarItem(Lnet/minecraft/client/gui/DrawContext;IILnet/minecraft/client/render/RenderTickCounter;Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/item/ItemStack;I)V")
	)
	private void rotateHotbarItem(class_329 instance, class_332 context, int x, int y, class_9779 tickCounter, class_1657 player, class_1799 stack, int seed, Operation<Void> original, @Share("offhand") LocalBooleanRef offhand) {
		if (OffhandHotbarConfig.displayMode != (offhand.get() ? DisplayMode.VERTICAL : DisplayMode.VERTICAL_SWAPPED)) {
			original.call(instance, context, x, y, tickCounter, player, stack, seed);
			return;
		}
		context.method_51448().pushMatrix();
		context.method_51448().rotateAbout(-field_29845, x + 8, y + 8);
		original.call(instance, context, x, y, tickCounter, player, stack, seed);
		context.method_51448().popMatrix();
	}

    @SuppressWarnings({"LocalMayBeArgsOnly"}) // Incorrect
    @WrapOperation(
            method = "renderHotbar",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerInventory;getStack(I)Lnet/minecraft/item/ItemStack;")
    )
    private class_1799 modifyDisplayedItem(class_1661 instance, int index, Operation<class_1799> original, @Local class_1799 offhandStack, @Local class_1657 player, @Share("offhand") LocalBooleanRef offhand) {
        if (OffhandHotbar.focusSwapped)
            if (offhand.get()) {
                if (index == OffhandHotbar.selectedOffhandSlot)
                    return original.call(instance, player.method_31548().method_67532());
            } else if (index == player.method_31548().method_67532())
                return offhandStack;
        if (!offhand.get())
            return original.call(instance, index);
        if (OffhandHotbar.swapped && index == OffhandHotbar.selectedOffhandSlot)
            return offhandStack;
        return original.call(instance, getOffhandHotbarSlot(index));
    }

	@ModifyExpressionValue(
			method = "renderHotbar",
			at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;isEmpty()Z")
	)
	private boolean hideVanillaOffhand(boolean original) {
		return true;
	}

	@ModifyExpressionValue(
			method = "renderHotbar",
			at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerInventory;getSelectedSlot()I")
	)
	private int useOffhandSlot(int original, @Share("offhand") LocalBooleanRef offhand) {
		return offhand.get() ? OffhandHotbar.selectedOffhandSlot : original;
	}

	@Inject(
			method = "renderHotbar",
			at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;isEmpty()Z", ordinal = 1),
			cancellable = true
	)
	// Prevents other mixins that inject at TAIL from rendering twice
	private void earlyReturn(class_332 context, class_9779 tickCounter, CallbackInfo ci, @Share("offhand") LocalBooleanRef offhand) {
		if (offhand.get() ^ OffhandHotbarConfig.displayMode.isSwapped())
			ci.cancel();
	}
}