/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.command;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.permission.UtilPermission;
import com.vecoo.extralib.player.UtilPlayer;
import com.vecoo.extraquests.ExtraQuests;
import com.vecoo.extraquests.task.KeyValueTask;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;

public class ExtraQuestsCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"equests").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)"minecraft.command.equests"))).then(class_2170.method_9247((String)"key_value").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (String playerName : ((class_2168)s.getSource()).method_9262()) {
                if (!playerName.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(playerName);
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests((s, builder) -> {
            Iterator iterator = Sets.newHashSet((Object[])new Integer[]{10, 50, 100}).iterator();
            while (iterator.hasNext()) {
                int amount = (Integer)iterator.next();
                builder.suggest(amount);
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"ignore", (ArgumentType)BoolArgumentType.bool()).executes(e -> ExtraQuestsCommand.executeKeyValueAdd((class_2168)e.getSource(), StringArgumentType.getString((CommandContext)e, (String)"player"), StringArgumentType.getString((CommandContext)e, (String)"key"), IntegerArgumentType.getInteger((CommandContext)e, (String)"amount"), BoolArgumentType.getBool((CommandContext)e, (String)"ignore")))))))))).then(class_2170.method_9247((String)"reload").executes(e -> ExtraQuestsCommand.executeReload((class_2168)e.getSource()))));
    }

    private static int executeKeyValueAdd(@NotNull class_2168 source, @NotNull String target, @NotNull String key, int amount, boolean ignore) {
        UUID targetUUID = UtilPlayer.getUUID((String)target);
        if (targetUUID == null) {
            source.method_45068(UtilChat.formatMessage((String)ExtraQuests.getInstance().getLocale().getPlayerNotFound().replace("%player%", target)));
            return 0;
        }
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        TeamData teamData = FTBTeamsAPI.api().getManager().getTeamForPlayerID(targetUUID).map(arg_0 -> ((ServerQuestFile)file).getOrCreateTeamData(arg_0)).orElse(file.getOrCreateTeamData(targetUUID));
        for (KeyValueTask task : ServerQuestFile.INSTANCE.collect(KeyValueTask.class)) {
            task.progress(teamData, key, amount, ignore);
        }
        source.method_45068(UtilChat.formatMessage((String)ExtraQuests.getInstance().getLocale().getAddKeyValue().replace("%player%", target).replace("%key%", key).replace("%value%", String.valueOf(amount))));
        return 1;
    }

    private static int executeReload(@NotNull class_2168 source) {
        ExtraQuests.getInstance().loadConfig();
        source.method_45068(UtilChat.formatMessage((String)ExtraQuests.getInstance().getLocale().getReload()));
        return 1;
    }
}

