/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.reward;

import com.vecoo.extraquests.api.factory.ExtraQuestsFactory;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class TimerReward
extends Reward {
    public static RewardType TYPE;
    private String questID = "";
    private int time = 300;

    public TimerReward(long id, Quest quest) {
        super(id, quest);
    }

    public RewardType getType() {
        return TYPE;
    }

    public void writeData(class_2487 nbt, class_7225.class_7874 provider) {
        super.writeData(nbt, provider);
        nbt.method_10582("quest", this.questID);
        nbt.method_10569("time", this.time);
    }

    public void readData(class_2487 nbt, class_7225.class_7874 provider) {
        super.readData(nbt, provider);
        this.questID = nbt.method_10558("quest");
        this.time = nbt.method_10550("time");
    }

    public void writeNetData(class_9129 buffer) {
        super.writeNetData(buffer);
        buffer.method_10814(this.questID);
        buffer.method_10804(this.time);
    }

    public void readNetData(class_9129 buffer) {
        super.readNetData(buffer);
        this.questID = buffer.method_19772();
        this.time = buffer.method_10816();
    }

    public String getQuestID() {
        return this.questID;
    }

    public int getTime() {
        return this.time;
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return class_2561.method_43469((String)"extraquests.timer.title", (Object[])new Object[]{this.time});
    }

    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("questID", this.questID, value -> {
            this.questID = value;
        }, "").setNameKey("extraquests.timer.questid");
        config.addInt("time", this.time, value -> {
            this.time = value;
        }, 300, 1, Integer.MAX_VALUE).setNameKey("extraquests.timer.time");
    }

    public void claim(class_3222 player, boolean notify) {
        if (this.questID.isEmpty()) {
            ExtraQuestsFactory.TimerProvider.addTimerQuests(player.method_5667(), this.quest.getCodeString(), this.time);
        } else {
            ExtraQuestsFactory.TimerProvider.addTimerQuests(player.method_5667(), this.questID, this.time);
        }
    }
}

