/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests;

import com.mojang.brigadier.CommandDispatcher;
import com.vecoo.extraquests.command.ExtraQuestsCommand;
import com.vecoo.extraquests.config.LocaleConfig;
import com.vecoo.extraquests.config.ServerConfig;
import com.vecoo.extraquests.reward.KeyValueReward;
import com.vecoo.extraquests.reward.TimerReward;
import com.vecoo.extraquests.storage.TimerProvider;
import com.vecoo.extraquests.task.KeyValueTask;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import net.minecraft.command.CommandSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="extraquests")
public class ExtraQuests {
    public static final String MOD_ID = "extraquests";
    private static final Logger LOGGER = LogManager.getLogger();
    private static ExtraQuests instance;
    private ServerConfig config;
    private LocaleConfig locale;
    private TimerProvider timerProvider;
    private MinecraftServer server;

    public ExtraQuests() {
        instance = this;
        this.loadConfig();
        this.registerQuests();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        this.server = event.getServer();
        PermissionAPI.registerNode((String)"minecraft.command.equests", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        ExtraQuestsCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarted(FMLServerStartedEvent event) {
        this.loadStorage();
    }

    @SubscribeEvent
    public void onServerStopping(FMLServerStoppingEvent event) {
        this.timerProvider.write();
    }

    public void loadConfig() {
        try {
            this.config = new ServerConfig();
            this.config.init();
            this.locale = new LocaleConfig();
            this.locale.init();
        }
        catch (Exception e) {
            LOGGER.error("Error load config.", (Throwable)e);
        }
    }

    public void loadStorage() {
        try {
            if (this.timerProvider == null) {
                this.timerProvider = new TimerProvider("/%directory%/storage/ExtraQuests/", this.server);
            }
            this.timerProvider.init();
        }
        catch (Exception e) {
            LOGGER.error("Error load storage.", (Throwable)e);
        }
    }

    private void registerQuests() {
        KeyValueTask.TYPE = TaskTypes.register((ResourceLocation)new ResourceLocation(MOD_ID, "key_value"), KeyValueTask::new, () -> Icon.getIcon((String)"minecraft:item/paper"));
        KeyValueReward.TYPE = RewardTypes.register((ResourceLocation)new ResourceLocation(MOD_ID, "key_value"), KeyValueReward::new, () -> Icon.getIcon((String)"minecraft:item/paper"));
        TimerReward.TYPE = RewardTypes.register((ResourceLocation)new ResourceLocation(MOD_ID, "timer"), TimerReward::new, () -> Icon.getIcon((String)"minecraft:item/clock_07"));
    }

    public static ExtraQuests getInstance() {
        return instance;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public ServerConfig getConfig() {
        return ExtraQuests.instance.config;
    }

    public LocaleConfig getLocale() {
        return ExtraQuests.instance.locale;
    }

    public TimerProvider getTimerProvider() {
        return ExtraQuests.instance.timerProvider;
    }

    public MinecraftServer getServer() {
        return ExtraQuests.instance.server;
    }
}

