/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.command;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.permission.UtilPermission;
import com.vecoo.extralib.player.UtilPlayer;
import com.vecoo.extraquests.ExtraQuests;
import com.vecoo.extraquests.task.KeyValueTask;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import java.util.Iterator;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;

public class ExtraQuestsCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"equests").requires(s -> UtilPermission.hasPermission((CommandSource)s, (String)"minecraft.command.equests"))).then(Commands.func_197057_a((String)"key_value").then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"player", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (String playerName : ((CommandSource)s.getSource()).func_197011_j()) {
                if (!playerName.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(playerName);
            }
            return builder.buildFuture();
        }).then(Commands.func_197056_a((String)"key", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests((s, builder) -> {
            Iterator iterator = Sets.newHashSet((Object[])new Integer[]{10, 50, 100}).iterator();
            while (iterator.hasNext()) {
                int amount = (Integer)iterator.next();
                builder.suggest(amount);
            }
            return builder.buildFuture();
        }).then(Commands.func_197056_a((String)"ignore", (ArgumentType)BoolArgumentType.bool()).executes(e -> ExtraQuestsCommand.executeKeyValueAdd((CommandSource)e.getSource(), StringArgumentType.getString((CommandContext)e, (String)"player"), StringArgumentType.getString((CommandContext)e, (String)"key"), IntegerArgumentType.getInteger((CommandContext)e, (String)"amount"), BoolArgumentType.getBool((CommandContext)e, (String)"ignore")))))))))).then(Commands.func_197057_a((String)"reload").executes(e -> ExtraQuestsCommand.executeReload((CommandSource)e.getSource()))));
    }

    private static int executeKeyValueAdd(@Nonnull CommandSource source, @Nonnull String target, @Nonnull String key, int amount, boolean ignore) {
        UUID targetUUID = UtilPlayer.getUUID((String)target);
        if (targetUUID == null) {
            source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)ExtraQuests.getInstance().getLocale().getPlayerNotFound().replace("%player%", target)), false);
            return 0;
        }
        for (KeyValueTask task : ServerQuestFile.INSTANCE.collect(KeyValueTask.class)) {
            task.progress(ServerQuestFile.INSTANCE.getData(FTBTeamsAPI.getPlayerTeamID((UUID)targetUUID)), key, amount, ignore);
        }
        source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)ExtraQuests.getInstance().getLocale().getAddKeyValue().replace("%player%", target).replace("%key%", key).replace("%value%", String.valueOf(amount))), false);
        return 1;
    }

    private static int executeReload(@Nonnull CommandSource source) {
        ExtraQuests.getInstance().loadConfig();
        source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)ExtraQuests.getInstance().getLocale().getReload()), false);
        return 1;
    }
}

