/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.reward;

import com.vecoo.extraquests.task.KeyValueTask;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class KeyValueReward
extends Reward {
    public static RewardType TYPE;
    private String key = "key";
    private long value = 5L;
    private boolean ignore = false;

    public KeyValueReward(Quest quest) {
        super(quest);
    }

    public RewardType getType() {
        return TYPE;
    }

    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("key", this.key);
        nbt.func_74772_a("value", this.value);
        nbt.func_74757_a("ignore", this.ignore);
    }

    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.key = nbt.func_74779_i("key");
        this.value = nbt.func_74763_f("value");
        this.ignore = nbt.func_74767_n("ignore");
    }

    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_211400_a(this.key, Short.MAX_VALUE);
        buffer.func_179254_b(this.value);
        buffer.writeBoolean(this.ignore);
    }

    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.key = buffer.func_150789_c(Short.MAX_VALUE);
        this.value = buffer.func_179260_f();
        this.ignore = buffer.readBoolean();
    }

    public String getKey() {
        return this.key;
    }

    public long getValue() {
        return this.value;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent("extraquests.key_value.title", new Object[]{this.key, this.value});
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getButtonText() {
        return "+" + this.value;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("key", this.key, value -> {
            this.key = value;
        }, this.key).setNameKey("extraquests.key_value.key");
        config.addLong("value", this.value, value -> {
            this.value = value;
        }, 5L, 1L, Long.MAX_VALUE).setNameKey("extraquests.key_value.value");
        config.addBool("ignore", this.ignore, value -> {
            this.ignore = value;
        }, false).setNameKey("extraquests.key_value.ignore");
    }

    public void claim(ServerPlayerEntity player, boolean notify) {
        for (KeyValueTask task : ServerQuestFile.INSTANCE.collect(KeyValueTask.class)) {
            task.progress(ServerQuestFile.INSTANCE.getData((Entity)player), this.key, this.value, this.ignore);
        }
    }
}

