/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.reward;

import com.vecoo.extraquests.api.factory.ExtraQuestsFactory;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TimerReward
extends Reward {
    public static RewardType TYPE;
    private String questID = "";
    private int time = 300;

    public TimerReward(Quest quest) {
        super(quest);
    }

    public RewardType getType() {
        return TYPE;
    }

    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("quest", this.questID);
        nbt.func_74768_a("time", this.time);
    }

    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.questID = nbt.func_74779_i("quest");
        this.time = nbt.func_74762_e("time");
    }

    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_180714_a(this.questID);
        buffer.func_150787_b(this.time);
    }

    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.questID = buffer.func_218666_n();
        this.time = buffer.func_150792_a();
    }

    public String getQuestID() {
        return this.questID;
    }

    public int getTime() {
        return this.time;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent("extraquests.timer.title", new Object[]{this.time});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("questID", this.questID, value -> {
            this.questID = value;
        }, "").setNameKey("extraquests.timer.questid");
        config.addInt("time", this.time, value -> {
            this.time = value;
        }, 300, 1, Integer.MAX_VALUE).setNameKey("extraquests.timer.time");
    }

    public void claim(ServerPlayerEntity player, boolean notify) {
        if (this.questID.isEmpty()) {
            ExtraQuestsFactory.TimerProvider.addTimerQuests(player.func_110124_au(), this.quest.getCodeString(), this.time);
        } else {
            ExtraQuestsFactory.TimerProvider.addTimerQuests(player.func_110124_au(), this.questID, this.time);
        }
    }
}

