/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.storage;

import com.vecoo.extralib.gson.UtilGson;
import com.vecoo.extralib.task.TaskTimer;
import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.extraquests.ExtraQuests;
import com.vecoo.extraquests.storage.TimerStorage;
import com.vecoo.extraquests.util.Utils;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.server.MinecraftServer;

public class TimerProvider {
    private final transient String filePath;
    private final Set<TimerStorage> timers;
    private transient boolean intervalStarted = false;
    private volatile transient boolean dirty = false;

    public TimerProvider(@Nonnull String filePath, @Nonnull MinecraftServer server) {
        this.filePath = UtilWorld.worldDirectory((String)filePath, (MinecraftServer)server);
        this.timers = new HashSet<TimerStorage>();
    }

    @Nonnull
    public Set<TimerStorage> getStorage() {
        return this.timers;
    }

    public boolean addTimer(@Nonnull TimerStorage timer) {
        if (!this.timers.add(timer)) {
            ExtraQuests.getLogger().error("Failed to add timer " + timer.getQuestID());
            return false;
        }
        this.dirty = true;
        return true;
    }

    public boolean removeTimer(@Nonnull TimerStorage timer) {
        if (!this.timers.remove(timer)) {
            ExtraQuests.getLogger().error("Failed to remove timer " + timer.getQuestID());
            return false;
        }
        this.dirty = true;
        return true;
    }

    public void write() {
        UtilGson.writeFileAsync((String)this.filePath, (String)"TimerStorage.json", (String)UtilGson.newGson().toJson((Object)this)).join();
    }

    private void writeInterval() {
        if (!this.intervalStarted) {
            TaskTimer.builder().withoutDelay().interval(600L).infinite().consume(task -> {
                if (ExtraQuests.getInstance().getServer().func_71278_l() && this.dirty) {
                    UtilGson.writeFileAsync((String)this.filePath, (String)"TimerStorage.json", (String)UtilGson.newGson().toJson((Object)this)).thenRun(() -> {
                        this.dirty = false;
                    });
                }
            }).build();
            this.intervalStarted = true;
        }
    }

    public void init() {
        UtilGson.readFileAsync((String)this.filePath, (String)"TimerStorage.json", el -> {
            TimerProvider provider = (TimerProvider)UtilGson.newGson().fromJson(el, TimerProvider.class);
            long time = System.currentTimeMillis();
            for (TimerStorage timer : provider.getStorage()) {
                if (timer.getEndTime() > time) {
                    this.timers.add(timer);
                    Utils.startTimer(timer);
                    continue;
                }
                Utils.questReset(timer);
            }
        }).join();
        this.write();
        this.writeInterval();
    }
}

