/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.storage;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;

public class TimerStorage {
    private final UUID playerUUID;
    private final String questID;
    private final long endTime;

    public TimerStorage(@Nonnull UUID playerUUID, @Nonnull String questID, int secondsTimer) {
        this.playerUUID = playerUUID;
        this.questID = questID;
        this.endTime = System.currentTimeMillis() + (long)secondsTimer * 1000L;
    }

    @Nonnull
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @Nonnull
    public String getQuestID() {
        return this.questID;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TimerStorage timerStorage = (TimerStorage)object;
        return Objects.equals(this.playerUUID, timerStorage.playerUUID) && Objects.equals(this.questID, timerStorage.questID);
    }

    public int hashCode() {
        return Objects.hash(this.playerUUID, this.questID);
    }
}

