/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class KeyValueTask
extends Task {
    public static TaskType TYPE;
    private String key = "key";
    private long value = 100L;

    public KeyValueTask(Quest quest) {
        super(quest);
    }

    public TaskType getType() {
        return TYPE;
    }

    public long getMaxProgress() {
        return this.value;
    }

    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("key", this.key);
        nbt.func_74772_a("value", this.value);
    }

    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.key = nbt.func_74779_i("key");
        this.value = nbt.func_74763_f("value");
    }

    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_211400_a(this.key, Short.MAX_VALUE);
        buffer.func_179254_b(this.value);
    }

    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.key = buffer.func_150789_c(Short.MAX_VALUE);
        this.value = buffer.func_179260_f();
    }

    public String getKey() {
        return this.key;
    }

    public long getValue() {
        return this.value;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent("extraquests.key_value.title", new Object[]{this.key, this.value});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("key", this.key, value -> {
            this.key = value;
        }, this.key).setNameKey("extraquests.key_value.key");
        config.addLong("value", this.value, value -> {
            this.value = value;
        }, 100L, 1L, Long.MAX_VALUE).setNameKey("extraquests.key_value.value");
    }

    public void progress(TeamData teamData, String key, long value, boolean ignore) {
        if (this.key.equals(key) && !teamData.isCompleted((QuestObject)this)) {
            if (ignore) {
                teamData.addProgress((Task)this, value);
            } else if (teamData.canStartTasks(this.quest)) {
                teamData.addProgress((Task)this, value);
            }
        }
    }
}

