/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.mixin;

import com.vecoo.extraquests.ExtraQuests;
import com.vecoo.extraquests.config.ServerConfig;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.sixik.sdmshop.shop.entry_types.CommandEntryType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={CommandEntryType.class}, remap=false)
public abstract class SDMShopMixin {
    @Unique
    private boolean console;

    @Inject(method={"serialize()Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void serialize(CallbackInfoReturnable<CompoundTag> cir, CompoundTag nbt) {
        if (this.console) {
            nbt.m_128379_("console", true);
        }
    }

    @Inject(method={"deserialize(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void deserialize(CompoundTag nbt, CallbackInfo ci) {
        this.console = nbt.m_128471_("console");
    }

    @Inject(method={"getConfig"}, at={@At(value="INVOKE", target="Ldev/ftb/mods/ftblibrary/config/ConfigGroup;addInt(Ljava/lang/String;ILjava/util/function/Consumer;III)Ldev/ftb/mods/ftblibrary/config/IntConfig;")})
    public void fillConfigGroup(ConfigGroup config, CallbackInfo ci) {
        config.addBool("console", this.console, v -> {
            this.console = v;
        }, false).setNameKey("extraquests.reward.command.console");
    }

    @Redirect(method={"onBuy"}, at=@At(value="INVOKE", target="Lnet/minecraft/commands/Commands;performPrefixedCommand(Lnet/minecraft/commands/CommandSourceStack;Ljava/lang/String;)I"), remap=true)
    public int onBuy(Commands instance, CommandSourceStack source, String command) {
        if (this.console) {
            ServerConfig config = ExtraQuests.instance().config();
            if (config.isBlacklistConsole()) {
                for (String blacklistCommand : config.blacklistConsoleList()) {
                    if (!command.contains(blacklistCommand)) continue;
                    return 0;
                }
            }
            instance.m_230957_(source.m_81377_().m_129893_(), command);
        } else {
            instance.m_230957_(source, command);
        }
        return 1;
    }
}

