/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.reward;

import com.vecoo.extraquests.api.factory.ExtraQuestsFactory;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TimerReward
extends Reward {
    public static RewardType TYPE;
    private String questID = "";
    private int time = 300;

    public TimerReward(long id, Quest quest) {
        super(id, quest);
    }

    public RewardType getType() {
        return TYPE;
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("quest", this.questID);
        nbt.m_128405_("time", this.time);
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.questID = nbt.m_128461_("quest");
        this.time = nbt.m_128451_("time");
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130070_(this.questID);
        buffer.m_130130_(this.time);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.questID = buffer.m_130277_();
        this.time = buffer.m_130242_();
    }

    public String questID() {
        return this.questID;
    }

    public int time() {
        return this.time;
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.m_237110_((String)"extraquests.timer.title", (Object[])new Object[]{this.time});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("questID", this.questID, value -> {
            this.questID = value;
        }, "").setNameKey("extraquests.timer.questid");
        config.addInt("time", this.time, value -> {
            this.time = value;
        }, 300, 1, Integer.MAX_VALUE).setNameKey("extraquests.timer.time");
    }

    public void claim(ServerPlayer player, boolean notify) {
        if (this.questID.isEmpty()) {
            ExtraQuestsFactory.TimerProvider.addTimerQuests(player.m_20148_(), this.quest.getCodeString(), this.time);
        } else {
            ExtraQuestsFactory.TimerProvider.addTimerQuests(player.m_20148_(), this.questID, this.time);
        }
    }
}

