/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.vecoo.extraquests.command.ExtraQuestsCommand;
import com.vecoo.extraquests.config.LocaleConfig;
import com.vecoo.extraquests.config.ServerConfig;
import com.vecoo.extraquests.reward.KeyValueReward;
import com.vecoo.extraquests.task.KeyValueTask;
import com.vecoo.extraquests.util.PermissionNodes;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import org.slf4j.Logger;

@Mod(value="extraquests")
public class ExtraQuests {
    public static final String MOD_ID = "extraquests";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static ExtraQuests instance;
    private ServerConfig config;
    private LocaleConfig locale;
    private MinecraftServer server;

    public ExtraQuests() {
        instance = this;
        this.loadConfig();
        this.registerQuests();
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPermissionGather(PermissionGatherEvent.Nodes event) {
        PermissionNodes.registerPermission(event);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        this.server = event.getServer();
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        ExtraQuestsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public void loadConfig() {
        try {
            this.config = new ServerConfig();
            this.config.init();
            this.locale = new LocaleConfig();
            this.locale.init();
        }
        catch (Exception e) {
            LOGGER.error("Error load config.", (Throwable)e);
        }
    }

    private void registerQuests() {
        KeyValueTask.TYPE = TaskTypes.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"key_value"), KeyValueTask::new, () -> Icon.getIcon((String)"minecraft:item/paper"));
        KeyValueReward.TYPE = RewardTypes.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"key_value"), KeyValueReward::new, () -> Icon.getIcon((String)"minecraft:item/paper"));
    }

    public static ExtraQuests getInstance() {
        return instance;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public ServerConfig getConfig() {
        return ExtraQuests.instance.config;
    }

    public LocaleConfig getLocale() {
        return ExtraQuests.instance.locale;
    }

    public MinecraftServer getServer() {
        return ExtraQuests.instance.server;
    }
}

