/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.command;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.permission.UtilPermission;
import com.vecoo.extralib.player.UtilPlayer;
import com.vecoo.extralib.server.UtilCommand;
import com.vecoo.extraquests.ExtraQuests;
import com.vecoo.extraquests.task.KeyValueTask;
import com.vecoo.extraquests.util.PermissionNodes;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import org.jetbrains.annotations.NotNull;

public class ExtraQuestsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"equests").requires(s -> UtilPermission.hasPermission((CommandSourceStack)s, PermissionNodes.EXTRAQUESTS_COMMAND))).then(Commands.literal((String)"key_value").then(Commands.literal((String)"add").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(UtilCommand.suggestOnlinePlayers()).then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests(UtilCommand.suggestAmount((Collection)Sets.newHashSet((Object[])new Integer[]{10, 50, 100}))).then(Commands.argument((String)"ignore", (ArgumentType)BoolArgumentType.bool()).executes(e -> ExtraQuestsCommand.executeKeyValueAdd((CommandSourceStack)e.getSource(), StringArgumentType.getString((CommandContext)e, (String)"player"), StringArgumentType.getString((CommandContext)e, (String)"key"), IntegerArgumentType.getInteger((CommandContext)e, (String)"amount"), BoolArgumentType.getBool((CommandContext)e, (String)"ignore")))))))))).then(Commands.literal((String)"reload").executes(e -> ExtraQuestsCommand.executeReload((CommandSourceStack)e.getSource()))));
    }

    private static int executeKeyValueAdd(@NotNull CommandSourceStack source, @NotNull String target, @NotNull String key, int amount, boolean ignore) {
        UUID targetUUID = UtilPlayer.getUUID((String)target);
        if (targetUUID == null) {
            source.sendSystemMessage(UtilChat.formatMessage((String)ExtraQuests.getInstance().getLocale().getPlayerNotFound().replace("%player%", target)));
            return 0;
        }
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        TeamData teamData = FTBTeamsAPI.api().getManager().getTeamForPlayerID(targetUUID).map(arg_0 -> ((ServerQuestFile)file).getOrCreateTeamData(arg_0)).orElse(file.getOrCreateTeamData(targetUUID));
        for (KeyValueTask task : ServerQuestFile.INSTANCE.collect(KeyValueTask.class)) {
            task.progress(teamData, key, amount, ignore);
        }
        source.sendSystemMessage(UtilChat.formatMessage((String)ExtraQuests.getInstance().getLocale().getAddKeyValue().replace("%player%", target).replace("%key%", key).replace("%value%", String.valueOf(amount))));
        return 1;
    }

    private static int executeReload(@NotNull CommandSourceStack source) {
        ExtraQuests.getInstance().loadConfig();
        source.sendSystemMessage(UtilChat.formatMessage((String)ExtraQuests.getInstance().getLocale().getReload()));
        return 1;
    }
}

