/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.vecoo.extraquests.command.ExtraQuestsCommand;
import com.vecoo.extraquests.config.LocaleConfig;
import com.vecoo.extraquests.config.ServerConfig;
import com.vecoo.extraquests.reward.KeyValueReward;
import com.vecoo.extraquests.reward.TimerReward;
import com.vecoo.extraquests.storage.QuestTimerProvider;
import com.vecoo.extraquests.task.KeyValueTask;
import com.vecoo.extraquests.util.PermissionNodes;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import org.slf4j.Logger;

@Mod(value="extraquests")
public class ExtraQuests {
    public static final String MOD_ID = "extraquests";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static ExtraQuests instance;
    private ServerConfig config;
    private LocaleConfig localeConfig;
    private QuestTimerProvider questTimerProvider;
    private MinecraftServer server;

    public ExtraQuests() {
        instance = this;
        this.loadConfig();
        this.registerQuests();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPermissionGather(PermissionGatherEvent.Nodes event) {
        PermissionNodes.registerPermission(event);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        this.server = event.getServer();
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        ExtraQuestsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        this.loadStorage();
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        this.questTimerProvider.write();
    }

    public void loadConfig() {
        try {
            this.config = new ServerConfig();
            this.config.init();
            this.localeConfig = new LocaleConfig();
            this.localeConfig.init();
        }
        catch (Exception e) {
            LOGGER.error("Error load config.", (Throwable)e);
        }
    }

    public void loadStorage() {
        try {
            if (this.questTimerProvider == null) {
                this.questTimerProvider = new QuestTimerProvider("/%directory%/storage/ExtraQuests/", this.server);
            }
            this.questTimerProvider.init();
        }
        catch (Exception e) {
            LOGGER.error("Error load storage.", (Throwable)e);
        }
    }

    private void registerQuests() {
        KeyValueTask.TYPE = TaskTypes.register((ResourceLocation)new ResourceLocation(MOD_ID, "key_value"), KeyValueTask::new, () -> Icon.getIcon((String)"minecraft:item/paper"));
        KeyValueReward.TYPE = RewardTypes.register((ResourceLocation)new ResourceLocation(MOD_ID, "key_value"), KeyValueReward::new, () -> Icon.getIcon((String)"minecraft:item/paper"));
        TimerReward.TYPE = RewardTypes.register((ResourceLocation)new ResourceLocation(MOD_ID, "timer"), TimerReward::new, () -> Icon.getIcon((String)"minecraft:item/clock_07"));
    }

    public static ExtraQuests instance() {
        return instance;
    }

    public static Logger logger() {
        return LOGGER;
    }

    public ServerConfig config() {
        return ExtraQuests.instance.config;
    }

    public LocaleConfig localeConfig() {
        return ExtraQuests.instance.localeConfig;
    }

    public QuestTimerProvider questTimerProvider() {
        return ExtraQuests.instance.questTimerProvider;
    }

    public MinecraftServer server() {
        return ExtraQuests.instance.server;
    }
}

