/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.storage;

import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class QuestTimer {
    private final UUID playerUUID;
    private final String questID;
    private final long endTime;

    public QuestTimer(@NotNull UUID playerUUID, @NotNull String questID, int secondsTimer) {
        this.playerUUID = playerUUID;
        this.questID = questID;
        this.endTime = System.currentTimeMillis() + (long)secondsTimer * 1000L;
    }

    @NotNull
    public UUID playerUUID() {
        return this.playerUUID;
    }

    @NotNull
    public String questID() {
        return this.questID;
    }

    public long endTime() {
        return this.endTime;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        QuestTimer timerStorage = (QuestTimer)object;
        return Objects.equals(this.playerUUID, timerStorage.playerUUID) && Objects.equals(this.questID, timerStorage.questID);
    }

    public int hashCode() {
        return Objects.hash(this.playerUUID, this.questID);
    }
}

