/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.storage;

import com.vecoo.extralib.gson.UtilGson;
import com.vecoo.extralib.task.TaskTimer;
import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.extraquests.ExtraQuests;
import com.vecoo.extraquests.storage.QuestTimer;
import com.vecoo.extraquests.util.Utils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class QuestTimerProvider {
    private final transient String filePath;
    private final Set<QuestTimer> questTimers;
    private transient boolean intervalStarted = false;
    private volatile transient boolean dirty = false;

    public QuestTimerProvider(@NotNull String filePath, @NotNull MinecraftServer server) {
        this.filePath = UtilWorld.resolveWorldDirectory((String)filePath, (MinecraftServer)server);
        this.questTimers = new HashSet<QuestTimer>();
    }

    @NotNull
    public Set<QuestTimer> storage() {
        return this.questTimers;
    }

    public boolean add(@NotNull QuestTimer questTimer) {
        if (!this.questTimers.add(questTimer)) {
            ExtraQuests.logger().error("Failed to add timer {}.", (Object)questTimer.questID());
            return false;
        }
        this.dirty = true;
        return true;
    }

    public boolean remove(@NotNull QuestTimer questTimer) {
        if (!this.questTimers.remove(questTimer)) {
            ExtraQuests.logger().error("Failed to remove timer {}.", (Object)questTimer.questID());
            return false;
        }
        this.dirty = true;
        return true;
    }

    public void write() {
        UtilGson.writeFileAsync((String)this.filePath, (String)"Timers.json", (String)UtilGson.gson().toJson((Object)this)).join();
    }

    private void writeInterval() {
        if (!this.intervalStarted) {
            TaskTimer.builder().withoutDelay().interval(600L).infinite().consume(task -> {
                if (ExtraQuests.instance().server().m_130010_() && this.dirty) {
                    UtilGson.writeFileAsync((String)this.filePath, (String)"Timers.json", (String)UtilGson.gson().toJson((Object)this)).thenRun(() -> {
                        this.dirty = false;
                    });
                }
            }).build();
            this.intervalStarted = true;
        }
    }

    public void init() {
        this.questTimers.clear();
        UtilGson.readFileAsync((String)this.filePath, (String)"Timers.json", el -> {
            QuestTimerProvider provider = (QuestTimerProvider)UtilGson.gson().fromJson(el, QuestTimerProvider.class);
            long time = System.currentTimeMillis();
            for (QuestTimer questTimer : provider.storage()) {
                if (questTimer.endTime() > time) {
                    this.questTimers.add(questTimer);
                    Utils.startQuestTimer(questTimer);
                    continue;
                }
                Utils.questReset(questTimer);
            }
        }).join();
        this.write();
        this.writeInterval();
    }
}

