/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.storage;

import com.vecoo.extralib.gson.UtilGson;
import com.vecoo.extralib.task.TaskTimer;
import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.extraquests.ExtraQuests;
import com.vecoo.extraquests.storage.TimerStorage;
import com.vecoo.extraquests.util.Utils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class TimerProvider {
    private final transient String filePath;
    private final Set<TimerStorage> timers;
    private transient boolean intervalStarted = false;
    private volatile transient boolean dirty = false;

    public TimerProvider(@NotNull String filePath, @NotNull MinecraftServer server) {
        this.filePath = UtilWorld.resolveWorldDirectory((String)filePath, (MinecraftServer)server);
        this.timers = new HashSet<TimerStorage>();
    }

    @NotNull
    public Set<TimerStorage> storage() {
        return this.timers;
    }

    public boolean addTimer(@NotNull TimerStorage timerStorage) {
        if (!this.timers.add(timerStorage)) {
            ExtraQuests.logger().error("Failed to add timer {}.", (Object)timerStorage.questID());
            return false;
        }
        this.dirty = true;
        return true;
    }

    public boolean removeTimer(@NotNull TimerStorage timerStorage) {
        if (!this.timers.remove(timerStorage)) {
            ExtraQuests.logger().error("Failed to remove timer {}.", (Object)timerStorage.questID());
            return false;
        }
        this.dirty = true;
        return true;
    }

    public void write() {
        UtilGson.writeFileAsync((String)this.filePath, (String)"TimerStorage.json", (String)UtilGson.gson().toJson((Object)this)).join();
    }

    private void writeInterval() {
        if (!this.intervalStarted) {
            TaskTimer.builder().withoutDelay().interval(600L).infinite().consume(task -> {
                if (ExtraQuests.instance().server().m_130010_() && this.dirty) {
                    UtilGson.writeFileAsync((String)this.filePath, (String)"TimerStorage.json", (String)UtilGson.gson().toJson((Object)this)).thenRun(() -> {
                        this.dirty = false;
                    });
                }
            }).build();
            this.intervalStarted = true;
        }
    }

    public void init() {
        this.timers.clear();
        UtilGson.readFileAsync((String)this.filePath, (String)"TimerStorage.json", el -> {
            TimerProvider provider = (TimerProvider)UtilGson.gson().fromJson(el, TimerProvider.class);
            long time = System.currentTimeMillis();
            for (TimerStorage timer : provider.storage()) {
                if (timer.endTime() > time) {
                    this.timers.add(timer);
                    Utils.startQuestTimer(timer);
                    continue;
                }
                Utils.questReset(timer);
            }
        }).join();
        this.write();
        this.writeInterval();
    }
}

