/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class KeyValueTask
extends Task {
    public static TaskType TYPE;
    private String key = "key";
    private long value = 100L;

    public KeyValueTask(Quest quest) {
        super(quest);
    }

    public TaskType getType() {
        return TYPE;
    }

    public long getMaxProgress() {
        return this.value;
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("key", this.key);
        nbt.m_128356_("value", this.value);
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.key = nbt.m_128461_("key");
        this.value = nbt.m_128454_("value");
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130072_(this.key, Short.MAX_VALUE);
        buffer.m_130103_(this.value);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.key = buffer.m_130136_(Short.MAX_VALUE);
        this.value = buffer.m_130258_();
    }

    public String getKey() {
        return this.key;
    }

    public long getValue() {
        return this.value;
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.m_237110_((String)"extraquests.key_value.title", (Object[])new Object[]{this.key, this.value});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("key", this.key, value -> {
            this.key = value;
        }, this.key).setNameKey("extraquests.key_value.key");
        config.addLong("value", this.value, value -> {
            this.value = value;
        }, 100L, 1L, Long.MAX_VALUE).setNameKey("extraquests.key_value.value");
    }

    public void progress(TeamData teamData, String key, long value, boolean ignore) {
        if (this.key.equals(key) && !teamData.isCompleted((QuestObject)this)) {
            if (ignore) {
                teamData.addProgress((Task)this, value);
            } else if (teamData.canStartTasks(this.quest)) {
                teamData.addProgress((Task)this, value);
            }
        }
    }
}

