/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests;

import com.mojang.logging.LogUtils;
import com.vecoo.extraquests.command.ExtraQuestsCommand;
import com.vecoo.extraquests.config.LocaleConfig;
import com.vecoo.extraquests.config.ServerConfig;
import com.vecoo.extraquests.reward.KeyValueReward;
import com.vecoo.extraquests.task.KeyValueTask;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class ExtraQuests
implements ModInitializer {
    public static final String MOD_ID = "extraquests";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static ExtraQuests instance;
    private ServerConfig config;
    private LocaleConfig locale;
    private MinecraftServer server;

    public void onInitialize() {
        instance = this;
        this.loadConfig();
        this.registerQuests();
        CommandRegistrationCallback.EVENT.register(ExtraQuestsCommand::register);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            this.server = server;
        });
    }

    public void loadConfig() {
        try {
            this.config = new ServerConfig();
            this.config.init();
            this.locale = new LocaleConfig();
            this.locale.init();
        }
        catch (Exception e) {
            LOGGER.error("Error load config.", (Throwable)e);
        }
    }

    private void registerQuests() {
        KeyValueTask.TYPE = TaskTypes.register((class_2960)class_2960.method_60655((String)MOD_ID, (String)"key_value"), KeyValueTask::new, () -> Icon.getIcon((String)"minecraft:item/paper"));
        KeyValueReward.TYPE = RewardTypes.register((class_2960)class_2960.method_60655((String)MOD_ID, (String)"key_value"), KeyValueReward::new, () -> Icon.getIcon((String)"minecraft:item/paper"));
    }

    public static ExtraQuests getInstance() {
        return instance;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public ServerConfig getConfig() {
        return ExtraQuests.instance.config;
    }

    public LocaleConfig getLocale() {
        return ExtraQuests.instance.locale;
    }

    public MinecraftServer getServer() {
        return ExtraQuests.instance.server;
    }
}

