/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.reward;

import com.vecoo.extraquests.task.KeyValueTask;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class KeyValueReward
extends Reward {
    public static RewardType TYPE;
    private String key = "key";
    private long value = 5L;
    private boolean ignore = false;

    public KeyValueReward(long id, Quest quest) {
        super(id, quest);
    }

    public RewardType getType() {
        return TYPE;
    }

    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putString("key", this.key);
        nbt.putLong("value", this.value);
        nbt.putBoolean("ignore", this.ignore);
    }

    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.key = nbt.getString("key");
        this.value = nbt.getLong("value");
        this.ignore = nbt.getBoolean("ignore");
    }

    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeUtf(this.key, Short.MAX_VALUE);
        buffer.writeVarLong(this.value);
        buffer.writeBoolean(this.ignore);
    }

    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.key = buffer.readUtf(Short.MAX_VALUE);
        this.value = buffer.readVarLong();
        this.ignore = buffer.readBoolean();
    }

    public String getKey() {
        return this.key;
    }

    public long getValue() {
        return this.value;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.translatable((String)"extraquests.key_value.title", (Object[])new Object[]{this.key, this.value});
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getButtonText() {
        return "+" + this.value;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("key", this.key, value -> {
            this.key = value;
        }, this.key).setNameKey("extraquests.key_value.key");
        config.addLong("value", this.value, value -> {
            this.value = value;
        }, 5L, 1L, Long.MAX_VALUE).setNameKey("extraquests.key_value.value");
        config.addBool("ignore", this.ignore, value -> {
            this.ignore = value;
        }, false).setNameKey("extraquests.key_value.ignore");
    }

    public void claim(ServerPlayer player, boolean notify) {
        for (KeyValueTask task : ServerQuestFile.INSTANCE.collect(KeyValueTask.class)) {
            task.progress(ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)player), this.key, this.value, this.ignore);
        }
    }
}

