/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.util;

import com.vecoo.extralib.task.TaskTimer;
import com.vecoo.extraquests.ExtraQuests;
import com.vecoo.extraquests.api.factory.ExtraQuestsFactory;
import com.vecoo.extraquests.storage.TimerStorage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import org.jetbrains.annotations.NotNull;

public class Utils {
    public static boolean questReset(@NotNull TimerStorage timer) {
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        Quest quest = file.getQuest(file.getID((Object)timer.getQuestID()));
        if (quest == null) {
            ExtraQuests.getLogger().error("No quest found for " + timer.getQuestID());
            ExtraQuestsFactory.TimerProvider.removeTimerQuests(timer);
            return false;
        }
        TeamData teamData = FTBTeamsAPI.api().getManager().getTeamForPlayerID(timer.getPlayerUUID()).map(arg_0 -> ((ServerQuestFile)file).getOrCreateTeamData(arg_0)).orElse(file.getOrCreateTeamData(timer.getPlayerUUID()));
        quest.forceProgress(teamData, new ProgressChange((QuestObjectBase)quest, timer.getPlayerUUID()).setReset(true));
        return true;
    }

    public static void startTimer(@NotNull TimerStorage timer) {
        TaskTimer.builder().delay((timer.getEndTime() - System.currentTimeMillis()) / 50L).consume(task -> {
            if (!Utils.questReset(timer)) {
                task.cancel();
                return;
            }
            ExtraQuestsFactory.TimerProvider.removeTimerQuests(timer);
        }).build();
    }
}

