/*
 * Decompiled with CFR 0.152.
 */
package com.mars.consistentexpcost.mixin;

import com.mars.consistentexpcost.CommonClass;
import com.mars.consistentexpcost.ConfigOptions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin {
    @Shadow
    public AbstractContainerMenu containerMenu;
    @Shadow
    public int experienceLevel;
    @Shadow
    public float experienceProgress;
    @Shadow
    public int totalExperience;

    @Shadow
    public abstract void giveExperiencePoints(int var1);

    @Inject(at={@At(value="TAIL")}, method={"onEnchantmentPerformed"})
    public void onEnchantmentPerformed(ItemStack enchantedItem, int levelCost, CallbackInfo ci) {
        this.experienceLevel += levelCost;
        if (ConfigOptions.use_minimal_exp_cost) {
            int[] costs = ((EnchantmentMenu)this.containerMenu).costs;
            int minLvl = costs[levelCost - 1];
            int expCost = CommonClass.getTotalXpAtLevel(minLvl - levelCost) - CommonClass.getTotalXpAtLevel(minLvl);
            this.giveExperiencePoints(expCost);
        } else {
            this.giveExperiencePoints(-levelCost * ConfigOptions.set_level_cost);
        }
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
            this.experienceProgress = 0.0f;
            this.totalExperience = 0;
        }
    }
}

