/*
 * Decompiled with CFR 0.152.
 */
package ch.thbo.rpc;

import ch.thbo.ThboRpcMod;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jagrosh.discordipc.IPCClient;
import com.jagrosh.discordipc.IPCListener;
import com.jagrosh.discordipc.entities.ActivityType;
import com.jagrosh.discordipc.entities.DiscordBuild;
import com.jagrosh.discordipc.entities.Packet;
import com.jagrosh.discordipc.entities.PartyPrivacy;
import com.jagrosh.discordipc.entities.RichPresence;
import com.jagrosh.discordipc.entities.User;
import com.jagrosh.discordipc.exceptions.NoDiscordClientException;
import java.time.OffsetDateTime;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_310;
import net.minecraft.class_3468;
import net.minecraft.class_634;

public final class RpcManager {
    private static final long APP_ID = 917057416946942083L;
    private static final long UPDATE_PERIOD_SECONDS = 20L;
    private static IPCClient client;
    private static final ScheduledExecutorService scheduler;
    private static final AtomicBoolean connected;
    private static volatile int onlineCount;
    private static volatile int maxCount;
    private static volatile long gameStartTimestamp;
    private static volatile long serverJoinTimestamp;

    public static void init() {
        ThboRpcMod.LOGGER.info("Initialisation Discord RPC");
        gameStartTimestamp = OffsetDateTime.now().toEpochSecond();
        try {
            client = new IPCClient(917057416946942083L);
            client.setListener(new IPCListener(){

                public void onPacketSent(IPCClient client, Packet packet) {
                }

                public void onPacketReceived(IPCClient client, Packet packet) {
                }

                public void onActivityJoin(IPCClient client, String secret) {
                }

                public void onActivitySpectate(IPCClient client, String secret) {
                }

                public void onActivityJoinRequest(IPCClient client, String secret, User user) {
                }

                public void onReady(IPCClient c) {
                    connected.set(true);
                    ThboRpcMod.LOGGER.info("\u2713 Discord RPC connect\u00e9");
                    RpcManager.pushSnapshot();
                }

                public void onClose(IPCClient c, JsonObject json) {
                    connected.set(false);
                }

                public void onDisconnect(IPCClient c, Throwable t) {
                    connected.set(false);
                }
            });
            client.connect(new DiscordBuild[0]);
        }
        catch (NoDiscordClientException e) {
            ThboRpcMod.LOGGER.warn("Discord n'est pas lanc\u00e9 - RPC d\u00e9sactiv\u00e9");
        }
        catch (Exception e) {
            ThboRpcMod.LOGGER.error("Erreur lors de l'initialisation Discord RPC", (Throwable)e);
        }
        scheduler.scheduleAtFixedRate(() -> {
            try {
                RpcManager.pushSnapshot();
            }
            catch (Exception e) {
                ThboRpcMod.LOGGER.error("Erreur lors de la mise \u00e0 jour RPC", (Throwable)e);
            }
        }, 2L, 20L, TimeUnit.SECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(RpcManager::shutdown, "THBO-RPC-Shutdown"));
    }

    private static void pushSnapshot() {
        String details;
        String state;
        if (client == null || !connected.get()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        int online = 0;
        int max = 16;
        boolean onServer = false;
        long timestampToUse = gameStartTimestamp;
        if (mc == null || mc.field_1687 == null) {
            state = "Dans les menus";
            details = "Pr\u00eat \u00e0 jouer";
            timestampToUse = gameStartTimestamp;
        } else {
            String dimension = "Monde inconnu";
            try {
                String dimensionId = mc.field_1687.method_27983().method_29177().toString();
                dimension = dimensionId.contains("overworld") ? "Dans l'Overworld" : (dimensionId.contains("the_nether") || dimensionId.contains("nether") ? "Dans le Nether" : (dimensionId.contains("the_end") || dimensionId.contains("end") ? "Dans l'End" : "Dimension custom"));
            }
            catch (Exception dimensionId) {
                // empty catch block
            }
            class_634 nh = mc.method_1562();
            if (nh != null && mc.method_1558() != null) {
                String serverAddress = mc.method_1558().field_3761;
                if (!serverAddress.toLowerCase().contains("reg-mc.fr")) {
                    try {
                        client.sendRichPresence(null);
                        ThboRpcMod.LOGGER.info("\ud83d\udd12 Rich Presence masqu\u00e9 (serveur : {})", (Object)serverAddress);
                    }
                    catch (Exception e) {
                        ThboRpcMod.LOGGER.error("Erreur lors du masquage du Rich Presence", (Throwable)e);
                    }
                    return;
                }
                onServer = true;
                state = dimension;
                details = serverAddress;
                timestampToUse = serverJoinTimestamp > 0L ? serverJoinTimestamp : gameStartTimestamp;
                int n = online = nh.method_2880() != null ? nh.method_2880().size() : 1;
                if (mc.method_1558().field_3753 != null) {
                    try {
                        String[] parts;
                        String countLabel = mc.method_1558().field_3753.getString();
                        if (countLabel.contains("/") && (parts = countLabel.split("/")).length == 2) {
                            max = Integer.parseInt(parts[1].trim());
                        }
                    }
                    catch (Exception countLabel) {
                        // empty catch block
                    }
                }
                if (maxCount > 0) {
                    max = maxCount;
                }
                if (onlineCount > 0) {
                    online = onlineCount;
                }
            } else {
                state = "Exploration solo";
                details = "Partie solo";
                timestampToUse = gameStartTimestamp;
            }
        }
        try {
            RichPresence.Builder builder = new RichPresence.Builder();
            builder.setActivityType(ActivityType.Playing);
            builder.setStartTimestamp(timestampToUse);
            builder.setState(state);
            builder.setDetails(details);
            builder.setLargeImage("logo_serveur", "Serveur Vanilla Whitelist\u00e9");
            if (mc.field_1724 != null) {
                int deaths = mc.field_1724.method_3143().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15421));
                int level = mc.field_1724.field_7520;
                if (deaths > 0) {
                    builder.setSmallImage("minecraft", "\ud83d\udc80 " + deaths + " mort" + (deaths > 1 ? "s" : "") + " | Niveau " + level);
                } else {
                    builder.setSmallImage("minecraft", "Niveau " + level);
                }
            } else {
                String minecraftVersion = "1.21.10";
                try {
                    minecraftVersion = mc.method_1515();
                }
                catch (Exception level) {
                    // empty catch block
                }
                builder.setSmallImage("minecraft", "Minecraft " + minecraftVersion);
            }
            JsonArray buttons = new JsonArray();
            JsonObject button1 = new JsonObject();
            button1.addProperty("label", "Rejoindre le Discord");
            button1.addProperty("url", "https://discord.gg/DmkSuEt");
            buttons.add((JsonElement)button1);
            JsonObject button2 = new JsonObject();
            button2.addProperty("label", "Site web");
            button2.addProperty("url", "https://reg-mc.fr/");
            buttons.add((JsonElement)button2);
            builder.setButtons(buttons);
            if (onServer && online > 0) {
                builder.setParty("srv", online, max, PartyPrivacy.Public);
            }
            client.sendRichPresence(builder.build());
        }
        catch (Exception e) {
            ThboRpcMod.LOGGER.error("Erreur lors de l'envoi de la pr\u00e9sence", (Throwable)e);
        }
    }

    public static void updatePlayerCount(int online, int max) {
        onlineCount = online;
        maxCount = max;
    }

    public static void forceUpdate() {
        RpcManager.pushSnapshot();
    }

    public static void onWorldJoin() {
        serverJoinTimestamp = OffsetDateTime.now().toEpochSecond();
        RpcManager.pushSnapshot();
    }

    public static void onWorldLeave() {
        serverJoinTimestamp = 0L;
        RpcManager.pushSnapshot();
    }

    public static void onDimensionChange() {
        RpcManager.pushSnapshot();
    }

    public static void onPlayerDeath() {
        RpcManager.pushSnapshot();
    }

    public static void onExperienceChange() {
        RpcManager.pushSnapshot();
    }

    public static void shutdown() {
        try {
            if (client != null) {
                client.close();
            }
        }
        catch (Exception e) {
            ThboRpcMod.LOGGER.error("Erreur lors de la fermeture RPC", (Throwable)e);
        }
        scheduler.shutdownNow();
    }

    static {
        scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "THBO-RPC");
            t.setDaemon(true);
            return t;
        });
        connected = new AtomicBoolean(false);
        onlineCount = 0;
        maxCount = 0;
        gameStartTimestamp = 0L;
        serverJoinTimestamp = 0L;
    }
}

