/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.charge;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;

public interface ChargeStorage
extends EnergyHandler {
    public BlockPos getBlockPos();

    public int getMaxDraw();

    default public int getPotentialDraw() {
        return Mth.clamp((int)this.getMaxDraw(), (int)0, (int)this.getAmountAsInt());
    }

    default public int getAvailableCharge() {
        return this.getAmountAsInt();
    }

    default public float getEfficiency() {
        return 1.0f;
    }

    default public boolean isFull() {
        return this.getAmountAsLong() >= this.getCapacityAsLong();
    }

    default public State getState() {
        return State.RECHARGEABLE;
    }

    default public void setState(State state) {
    }

    public static enum State {
        INFINITE,
        SOURCE,
        RECHARGEABLE,
        DISPOSABLE,
        DISABLED;

    }

    public record Spec(State initialState, int capacity, int maxDraw, float efficiency) {
    }
}

