/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signal;

import com.mojang.logging.LogUtils;
import java.util.function.Consumer;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.api.signal.SignalController;
import mods.railcraft.api.signal.SingleSignalReceiver;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import org.slf4j.Logger;

public class DualSignalReceiver
extends SingleSignalReceiver {
    private static final Logger logger = LogUtils.getLogger();
    private final SingleSignalReceiver.SignalClient secondarySignalClient;

    public DualSignalReceiver(BlockEntity blockEntity, Runnable syncListener, Consumer<SignalAspect> primarySignalAspectListener, Consumer<SignalAspect> secondarySignalAspectListener) {
        super(blockEntity, syncListener, primarySignalAspectListener);
        this.secondarySignalClient = new SingleSignalReceiver.SignalClient(this, secondarySignalAspectListener);
    }

    public SignalAspect getSecondarySignalAspect() {
        return this.secondarySignalClient.getSignalAspect();
    }

    @Override
    public void linked(SignalController signalController) {
        if (this.primarySignalClient.getSignalController() == null) {
            super.linked(signalController);
            return;
        }
        if (this.secondarySignalClient.getSignalController() == null) {
            this.secondarySignalClient.linked(signalController);
            return;
        }
        this.primarySignalClient.unlinked();
        this.secondarySignalClient.unlinked();
        super.linked(signalController);
    }

    @Override
    public void unlinked(SignalController signalController) {
        if (signalController.blockPos().equals((Object)this.primarySignalClient.getSignalControllerBlockPos())) {
            this.primarySignalClient.unlinked();
        } else if (signalController.blockPos().equals((Object)this.secondarySignalClient.getSignalControllerBlockPos())) {
            this.secondarySignalClient.unlinked();
        } else {
            logger.warn("Signal controller @ [{}] tried to unlink with signal receiver @ [{}] without initially being linked", (Object)signalController.blockPos(), (Object)this.blockEntity.getBlockPos());
        }
    }

    @Override
    public void receiveSignalAspect(SignalController signalController, SignalAspect signalAspect) {
        if (signalController == this.primarySignalClient.getSignalController()) {
            super.receiveSignalAspect(signalController, signalAspect);
        } else if (signalController == this.secondarySignalClient.getSignalController()) {
            this.secondarySignalClient.setSignalAspect(signalAspect);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.secondarySignalClient.refresh();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.secondarySignalClient.unlink();
    }

    @Override
    public void serialize(ValueOutput valueOutput) {
        super.serialize(valueOutput);
        valueOutput.putChild("secondarySignalClient", (ValueIOSerializable)this.secondarySignalClient);
    }

    @Override
    public void deserialize(ValueInput valueInput) {
        super.deserialize(valueInput);
        valueInput.readChild("secondarySignalClient", (ValueIOSerializable)this.secondarySignalClient);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf data) {
        super.writeToBuf(data);
        data.writeEnum((Enum)this.secondarySignalClient.getSignalAspect());
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        super.readFromBuf(data);
        this.secondarySignalClient.setSignalAspect((SignalAspect)data.readEnum(SignalAspect.class));
    }
}

