/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.advancements.RailcraftCriteriaTriggers;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.attachment.RailcraftAttachmentTypes;
import mods.railcraft.charge.ChargeCartStorageImpl;
import mods.railcraft.charge.ChargeProviderImpl;
import mods.railcraft.charge.ZapEffectProviderImpl;
import mods.railcraft.client.ClientManager;
import mods.railcraft.data.RailcraftDataMapProvider;
import mods.railcraft.data.RailcraftLanguageProvider;
import mods.railcraft.data.RailcraftParticleProvider;
import mods.railcraft.data.RailcraftSoundsProvider;
import mods.railcraft.data.RailcraftSpriteSourceProvider;
import mods.railcraft.data.advancements.RailcraftAdvancementProvider;
import mods.railcraft.data.gametest.RailcraftGameTestInstances;
import mods.railcraft.data.gametest.RailcraftTestEnvironments;
import mods.railcraft.data.loot.RailcraftLootModifierProvider;
import mods.railcraft.data.loot.RailcraftLootTableProvider;
import mods.railcraft.data.models.RailcraftModelProvider;
import mods.railcraft.data.recipes.RailcraftRecipeProvider;
import mods.railcraft.data.recipes.providers.BlastFurnaceRecipeProvider;
import mods.railcraft.data.recipes.providers.CokeOvenRecipeProvider;
import mods.railcraft.data.recipes.providers.CrusherRecipeProvider;
import mods.railcraft.data.recipes.providers.RollingRecipeProvider;
import mods.railcraft.data.tags.RailcraftBlockTagsProvider;
import mods.railcraft.data.tags.RailcraftDamageTypeTagsProvider;
import mods.railcraft.data.tags.RailcraftFluidTagsProvider;
import mods.railcraft.data.tags.RailcraftItemTagsProvider;
import mods.railcraft.data.tags.RailcraftPoiTypeTagsProvider;
import mods.railcraft.data.worldgen.RailcraftBiomeModifiers;
import mods.railcraft.data.worldgen.RailcraftStructureSets;
import mods.railcraft.data.worldgen.RailcraftStructures;
import mods.railcraft.data.worldgen.features.RailcraftOreFeatures;
import mods.railcraft.data.worldgen.placements.RailcraftOrePlacements;
import mods.railcraft.datamaps.RailcraftDataMaps;
import mods.railcraft.loot.RailcraftLootModifiers;
import mods.railcraft.network.PacketHandler;
import mods.railcraft.network.RailcraftDataSerializers;
import mods.railcraft.network.to_client.LinkedCartsMessage;
import mods.railcraft.particle.RailcraftParticleTypes;
import mods.railcraft.sounds.RailcraftSoundEvents;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.world.damagesource.RailcraftDamageSources;
import mods.railcraft.world.damagesource.RailcraftDamageType;
import mods.railcraft.world.effect.RailcraftMobEffects;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.ai.village.poi.RailcraftPoiTypes;
import mods.railcraft.world.entity.npc.RailcraftVillagerProfession;
import mods.railcraft.world.entity.npc.RailcraftVillagerTrades;
import mods.railcraft.world.entity.vehicle.MinecartHandler;
import mods.railcraft.world.inventory.RailcraftMenuTypes;
import mods.railcraft.world.item.ChargeMeterItem;
import mods.railcraft.world.item.CrowbarHandler;
import mods.railcraft.world.item.RailcraftCreativeModeTabs;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.item.enchantment.RailcraftEnchantments;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.entity.BlastFurnaceBlockEntity;
import mods.railcraft.world.level.block.entity.CokeOvenBlockEntity;
import mods.railcraft.world.level.block.entity.ContainerBlockEntity;
import mods.railcraft.world.level.block.entity.CrusherBlockEntity;
import mods.railcraft.world.level.block.entity.PoweredRollingMachineBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.SteamOvenBlockEntity;
import mods.railcraft.world.level.block.entity.SteamTurbineBlockEntity;
import mods.railcraft.world.level.block.entity.WaterTankSidingBlockEntity;
import mods.railcraft.world.level.block.entity.manipulator.FluidManipulatorBlockEntity;
import mods.railcraft.world.level.block.entity.steamboiler.SteamBoilerBlockEntity;
import mods.railcraft.world.level.block.entity.tank.TankBlockEntity;
import mods.railcraft.world.level.block.entity.worldspike.WorldSpikeBlockEntity;
import mods.railcraft.world.level.block.track.TrackTypes;
import mods.railcraft.world.level.gameevent.RailcraftGameEvents;
import mods.railcraft.world.level.levelgen.feature.RailcraftFeatures;
import mods.railcraft.world.level.levelgen.structure.ComponentWorkshop;
import mods.railcraft.world.level.levelgen.structure.RailcraftStructurePieces;
import mods.railcraft.world.level.levelgen.structure.RailcraftStructureTypes;
import mods.railcraft.world.level.material.RailcraftFluidTypes;
import mods.railcraft.world.level.material.RailcraftFluids;
import mods.railcraft.world.signal.TokenRingManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.world.chunk.LoadingValidationCallback;
import net.neoforged.neoforge.common.world.chunk.RegisterTicketControllersEvent;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.fluid.BucketResourceHandler;

@Mod(value="railcraft")
public class Railcraft {
    public static final boolean BETA = true;
    public static final TicketController CHUNK_CONTROLLER = new TicketController(RailcraftConstants.rl("ticket_controller"), (LoadingValidationCallback)new WorldSpikeBlockEntity.RailcraftValidationTicket());
    private final MinecartHandler minecartHandler = new MinecartHandler();

    public Railcraft(ModContainer modContainer, Dist dist) {
        NeoForge.EVENT_BUS.register((Object)this);
        RailcraftConfig.registerConfig(modContainer);
        IEventBus modEventBus = modContainer.getEventBus();
        modEventBus.addListener(this::handleRegisterCapabilities);
        modEventBus.addListener(this::buildContents);
        modEventBus.addListener(this::handleGatherData);
        modEventBus.addListener(this::registerChunkControllers);
        if (dist.isClient()) {
            ClientManager.init(modEventBus);
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        PacketHandler.register(modEventBus);
        RailcraftEntityTypes.register(modEventBus);
        RailcraftBlocks.register(modEventBus);
        RailcraftItems.register(modEventBus);
        RailcraftMobEffects.register(modEventBus);
        RailcraftCreativeModeTabs.register(modEventBus);
        RailcraftBlockEntityTypes.register(modEventBus);
        TrackTypes.register(modEventBus);
        RailcraftFluids.register(modEventBus);
        RailcraftFluidTypes.register(modEventBus);
        RailcraftMenuTypes.register(modEventBus);
        RailcraftSoundEvents.register(modEventBus);
        RailcraftParticleTypes.register(modEventBus);
        RailcraftRecipeSerializers.register(modEventBus);
        RailcraftRecipeTypes.register(modEventBus);
        RailcraftGameEvents.register(modEventBus);
        RailcraftDataSerializers.register(modEventBus);
        RailcraftPoiTypes.register(modEventBus);
        RailcraftVillagerProfession.register(modEventBus);
        RailcraftLootModifiers.register(modEventBus);
        RailcraftFeatures.register(modEventBus);
        RailcraftStructureTypes.register(modEventBus);
        RailcraftStructurePieces.register(modEventBus);
        RailcraftCriteriaTriggers.register(modEventBus);
        RailcraftAttachmentTypes.register(modEventBus);
        RailcraftDataMaps.register(modEventBus);
        RailcraftDataComponents.register(modEventBus);
        RailcraftGameTestInstances.register(modEventBus);
    }

    private void handleRegisterCapabilities(RegisterCapabilitiesEvent event) {
        for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
            event.registerEntity(RollingStock.CAPABILITY, entityType, (entity, ctx) -> entity instanceof AbstractMinecart ? (RollingStock)entity.getData((AttachmentType)RailcraftAttachmentTypes.MINECART_ROLLING_STOCK.get()) : null);
        }
        event.registerEntity(Capabilities.Fluid.ENTITY, (EntityType)RailcraftEntityTypes.TANK_MINECART.get(), (e, side) -> e.getTankManager());
        event.registerEntity(Capabilities.Energy.ENTITY, (EntityType)RailcraftEntityTypes.ENERGY_MINECART.get(), (e, side) -> e.getBatteryCart());
        event.registerEntity(Capabilities.Energy.ENTITY, (EntityType)RailcraftEntityTypes.ELECTRIC_LOCOMOTIVE.get(), (e, side) -> e.getBatteryCart());
        event.registerEntity(Capabilities.Fluid.ENTITY, (EntityType)RailcraftEntityTypes.STEAM_LOCOMOTIVE.get(), (e, side) -> e.getTankManager());
        event.registerEntity(Capabilities.Item.ENTITY_AUTOMATION, (EntityType)RailcraftEntityTypes.STEAM_LOCOMOTIVE.get(), (e, side) -> e.getFuelContainer());
        event.registerBlockEntity(Capabilities.Fluid.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.WATER_TANK_SIDING.get(), WaterTankSidingBlockEntity::getFluidCap);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.COKE_OVEN.get(), CokeOvenBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.Fluid.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.COKE_OVEN.get(), CokeOvenBlockEntity::getFluidCap);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.STEAM_OVEN.get(), SteamOvenBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.Fluid.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.STEAM_OVEN.get(), SteamOvenBlockEntity::getFluidCap);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.CRUSHER.get(), CrusherBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.Energy.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.CRUSHER.get(), CrusherBlockEntity::getEnergyCap);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.BLAST_FURNACE.get(), BlastFurnaceBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.Fluid.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.STEAM_TURBINE.get(), SteamTurbineBlockEntity::getFluidCap);
        event.registerBlockEntity(Capabilities.Energy.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.STEAM_TURBINE.get(), SteamTurbineBlockEntity::getEnergyCap);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.STEAM_BOILER.get(), SteamBoilerBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.Fluid.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.STEAM_BOILER.get(), SteamBoilerBlockEntity::getFluidCap);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.POWERED_ROLLING_MACHINE.get(), PoweredRollingMachineBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.Fluid.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.IRON_TANK.get(), TankBlockEntity::getFluidCap);
        event.registerBlockEntity(Capabilities.Fluid.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.STEEL_TANK.get(), TankBlockEntity::getFluidCap);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.CART_DISPENSER.get(), ContainerBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.TRAIN_DISPENSER.get(), ContainerBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.FEED_STATION.get(), ContainerBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.FLUID_LOADER.get(), ContainerBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.Fluid.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.FLUID_LOADER.get(), FluidManipulatorBlockEntity::getFluidCap);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.FLUID_UNLOADER.get(), ContainerBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.Fluid.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.FLUID_UNLOADER.get(), FluidManipulatorBlockEntity::getFluidCap);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.ITEM_LOADER.get(), ContainerBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.ITEM_UNLOADER.get(), ContainerBlockEntity::getItemCap);
        event.registerItem(Capabilities.Fluid.ITEM, (stack, ctx) -> new BucketResourceHandler(Objects.requireNonNull(ctx)), new ItemLike[]{RailcraftItems.CREOSOTE_BUCKET});
        event.registerBlock(Capabilities.Energy.BLOCK, (IBlockCapabilityProvider)Charge.distribution, new Block[]{(Block)RailcraftBlocks.FORCE_TRACK_EMITTER.get(), (Block)RailcraftBlocks.NICKEL_ZINC_BATTERY.get(), (Block)RailcraftBlocks.NICKEL_IRON_BATTERY.get(), (Block)RailcraftBlocks.ZINC_CARBON_BATTERY.get(), (Block)RailcraftBlocks.ZINC_CARBON_BATTERY_EMPTY.get(), (Block)RailcraftBlocks.ZINC_SILVER_BATTERY.get(), (Block)RailcraftBlocks.ZINC_SILVER_BATTERY_EMPTY.get(), (Block)RailcraftBlocks.FRAME.get(), (Block)RailcraftBlocks.POWERED_ROLLING_MACHINE.get()});
    }

    private void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            RailcraftCreativeModeTabs.addToolsAndUtilities(event);
        } else if (event.getTabKey() == CreativeModeTabs.COMBAT) {
            RailcraftCreativeModeTabs.addCombat(event);
        }
    }

    private void handleGatherData(GatherDataEvent.Client event) {
        event.createBlockAndItemTags(RailcraftBlockTagsProvider::new, RailcraftItemTagsProvider::new);
        event.createProvider(RailcraftFluidTagsProvider::new);
        event.createProvider(RailcraftLootTableProvider::new);
        event.createProvider(RailcraftAdvancementProvider::new);
        event.createProvider(RailcraftRecipeProvider.Runner::new);
        event.createProvider(BlastFurnaceRecipeProvider.Runner::new);
        event.createProvider(CokeOvenRecipeProvider.Runner::new);
        event.createProvider(CrusherRecipeProvider.Runner::new);
        event.createProvider(RollingRecipeProvider.Runner::new);
        event.createProvider(RailcraftPoiTypeTagsProvider::new);
        event.createProvider(RailcraftLootModifierProvider::new);
        event.createProvider(RailcraftDamageTypeTagsProvider::new);
        event.createProvider(RailcraftDataMapProvider::new);
        event.createProvider(RailcraftModelProvider::new);
        event.createProvider(RailcraftLanguageProvider::new);
        event.createProvider(RailcraftSoundsProvider::new);
        event.createProvider(RailcraftSpriteSourceProvider::new);
        event.createProvider(RailcraftParticleProvider::new);
        event.createDatapackRegistryObjects(new RegistrySetBuilder().add(Registries.CONFIGURED_FEATURE, RailcraftOreFeatures::bootstrap).add(Registries.PLACED_FEATURE, RailcraftOrePlacements::bootstrap).add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, RailcraftBiomeModifiers::bootstrap).add(Registries.DAMAGE_TYPE, RailcraftDamageType::bootstrap).add(Registries.STRUCTURE, RailcraftStructures::bootstrap).add(Registries.STRUCTURE_SET, RailcraftStructureSets::bootstrap).add(Registries.ENCHANTMENT, RailcraftEnchantments::bootstrap).add(Registries.TEST_INSTANCE, RailcraftGameTestInstances::bootstrap).add(Registries.TEST_ENVIRONMENT, RailcraftTestEnvironments::bootstrap));
    }

    private void registerChunkControllers(RegisterTicketControllersEvent event) {
        event.register(CHUNK_CONTROLLER);
    }

    @SubscribeEvent
    public void handleServerAboutToStart(ServerAboutToStartEvent event) {
        ComponentWorkshop.addVillageStructures(event.getServer().registryAccess());
    }

    @SubscribeEvent
    public void handleServerStarted(ServerStartedEvent event) {
        if (((Boolean)RailcraftConfig.SERVER.solidCarts.get()).booleanValue()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void handleLevelTick(LevelTickEvent.Post event) {
        ChargeProviderImpl[] chargeProviderImplArray = event.getLevel();
        if (chargeProviderImplArray instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)chargeProviderImplArray;
            for (ChargeProviderImpl provider : ChargeProviderImpl.values()) {
                provider.network(level).tick();
            }
            TokenRingManager.get(level).tick(level);
        }
    }

    @SubscribeEvent
    public void handlePlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.tickCount % 20 == 0) {
                List<LinkedCartsMessage.LinkedCart> linkedCarts = EntitySearcher.findMinecarts().around((Entity)player2).inflate(32.0).stream((Level)player2.level()).map(RollingStock::getOrThrow).map(LinkedCartsMessage.LinkedCart::new).toList();
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new LinkedCartsMessage(linkedCarts), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public void handleEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof AbstractMinecart) {
            AbstractMinecart cart = (AbstractMinecart)entity;
            Player player = event.getEntity();
            InteractionHand hand = event.getHand();
            ItemStack stack = event.getItemStack();
            if (!stack.isEmpty() && stack.is((Item)RailcraftItems.CHARGE_METER.get())) {
                player.swing(hand);
                if (!player.level().isClientSide()) {
                    Optional.ofNullable((EnergyHandler)cart.getCapability(Capabilities.Energy.ENTITY, null)).filter(ChargeCartStorageImpl.class::isInstance).map(ChargeCartStorageImpl.class::cast).ifPresent(battery -> {
                        ChargeMeterItem.sendCartStat(player, cart.getDisplayName(), battery);
                        event.setCanceled(true);
                        event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
                    });
                }
            } else {
                event.setCanceled(this.minecartHandler.handleInteract(cart, player));
                InteractionResult crowbarActionResult = CrowbarHandler.handleInteract(cart, player, hand);
                if (crowbarActionResult.consumesAction()) {
                    event.setCanceled(true);
                    event.setCancellationResult(crowbarActionResult);
                }
            }
        }
    }

    @SubscribeEvent
    public void handleEntityLeaveWorld(EntityLeaveLevelEvent event) {
        AbstractMinecart cart;
        Entity entity = event.getEntity();
        if (entity instanceof AbstractMinecart && !(cart = (AbstractMinecart)entity).level().isClientSide() && cart.isRemoved()) {
            RollingStock.getOrThrow(cart).removed(cart.getRemovalReason());
        }
    }

    @SubscribeEvent
    public void handleLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            ChargeProviderImpl.DISTRIBUTION.removeChargeNetwork(level);
        }
    }

    @SubscribeEvent
    public void modifyDrops(LivingDropsEvent event) {
        ServerLevel level = (ServerLevel)event.getEntity().level();
        RegistryAccess registryAccess = level.registryAccess();
        if (event.getSource().equals((Object)RailcraftDamageSources.steam(registryAccess))) {
            RecipeManager recipeManager = level.recipeAccess();
            for (ItemEntity entityItem : event.getDrops()) {
                ItemStack drop = entityItem.getItem();
                ItemStack cooked = recipeManager.getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(drop), (Level)level).map(x -> ((SmeltingRecipe)x.value()).assemble(null, (HolderLookup.Provider)registryAccess)).orElse(ItemStack.EMPTY);
                if (cooked.isEmpty() || !level.getRandom().nextBoolean()) continue;
                entityItem.setItem(new ItemStack((ItemLike)cooked.getItem(), drop.getCount()));
            }
        }
    }

    @SubscribeEvent
    public void addCustomTrades(VillagerTradesEvent event) {
        if (event.getType() == RailcraftVillagerProfession.TRACKMAN.getKey()) {
            RailcraftVillagerTrades.addTradeForTrackman((Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
        } else if (event.getType() == RailcraftVillagerProfession.CARTMAN.getKey()) {
            RailcraftVillagerTrades.addTradeForCartman((Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
        } else if (event.getType() == VillagerProfession.ARMORER) {
            RailcraftVillagerTrades.addTradeForArmorer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
        } else if (event.getType() == VillagerProfession.TOOLSMITH) {
            RailcraftVillagerTrades.addTradeForToolSmith((Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
        }
    }

    @SubscribeEvent
    public void handleNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        event.getLevel().gameEvent(null, RailcraftGameEvents.NEIGHBOR_NOTIFY, event.getPos());
    }

    @SubscribeEvent
    public void handleDatapackSync(OnDatapackSyncEvent event) {
        event.sendRecipes(new RecipeType[]{(RecipeType)RailcraftRecipeTypes.BLASTING.get()});
        event.sendRecipes(new RecipeType[]{(RecipeType)RailcraftRecipeTypes.ROLLING.get()});
        event.sendRecipes(new RecipeType[]{(RecipeType)RailcraftRecipeTypes.CRUSHING.get()});
        event.sendRecipes(new RecipeType[]{(RecipeType)RailcraftRecipeTypes.COKING.get()});
    }

    static {
        Charge._setZapEffectProvider(new ZapEffectProviderImpl());
        for (ChargeProviderImpl value : ChargeProviderImpl.values()) {
            value.getCharge()._setProvider(value);
        }
    }
}

