/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.carts;

import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.carts.Side;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;

public interface Train {
    public UUID id();

    public RollingStock front();

    public void copyTo(Train var1);

    default public Stream<RollingStock> stream() {
        return this.front().traverseTrainWithSelf(Side.BACK);
    }

    default public Stream<? extends AbstractMinecart> entities() {
        return this.stream().map(RollingStock::entity);
    }

    default public Stream<Entity> passengers() {
        return this.entities().flatMap(minecart -> minecart.getPassengers().stream());
    }

    public int getNumRunningLocomotives();

    default public int size() {
        return (int)this.stream().count();
    }

    public State state();

    public void setState(State var1);

    default public void setStateIfHigherPriority(State state) {
        if (state.ordinal() < this.state().ordinal()) {
            this.setState(state);
        }
    }

    public void addLock(UUID var1);

    public void removeLock(UUID var1);

    public boolean isLocked();

    default public boolean isIdle() {
        return this.state() == State.IDLE || this.isLocked();
    }

    public Optional<ResourceHandler<ItemResource>> itemHandler();

    public Optional<ResourceHandler<FluidResource>> fluidHandler();

    public static enum State implements StringRepresentable
    {
        STOPPED("stopped"),
        IDLE("idle"),
        NORMAL("normal");

        public static final StringRepresentable.EnumCodec<State> CODEC;
        private final String name;

        private State(String name) {
            this.name = name;
        }

        public boolean isStopped() {
            return this == STOPPED;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(State::values);
        }
    }
}

