/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.container.manipulator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mods.railcraft.api.container.manipulator.ContainerSlotAccessor;
import mods.railcraft.api.container.manipulator.ItemHandlerSlotAccessor;
import mods.railcraft.api.container.manipulator.ModifiableSlotAccessor;
import mods.railcraft.api.container.manipulator.SlotAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;

public interface ContainerManipulator<T extends SlotAccessor> {
    public static <T extends SlotAccessor> ContainerManipulator<T> empty() {
        return Stream::empty;
    }

    public static ContainerManipulator<ModifiableSlotAccessor> of(Container container) {
        List<ModifiableSlotAccessor> slots = ContainerSlotAccessor.createSlots(container).toList();
        return slots::stream;
    }

    public static ContainerManipulator<ModifiableSlotAccessor> of(WorldlyContainer container, Direction face) {
        List<ModifiableSlotAccessor> slots = ContainerSlotAccessor.createSlots(container, face).toList();
        return slots::stream;
    }

    public static ContainerManipulator<SlotAccessor> of(ResourceHandler<ItemResource> itemHandler) {
        List<SlotAccessor> slots = ItemHandlerSlotAccessor.createSlots(itemHandler).toList();
        return slots::stream;
    }

    public static ContainerManipulator<?> findAdjacent(Level level, BlockPos blockPos) {
        return ContainerManipulator.findAdjacent(level, blockPos, blockEntity -> true);
    }

    public static ContainerManipulator<?> findAdjacent(Level level, BlockPos blockPos, Predicate<BlockEntity> filter) {
        return () -> Arrays.stream(Direction.values()).flatMap(direction -> Stream.ofNullable(level.getBlockEntity(blockPos.relative(direction))).filter(filter).flatMap(blockEntity -> Optional.ofNullable((ResourceHandler)level.getCapability(Capabilities.Item.BLOCK, blockEntity.getBlockPos(), (Object)direction.getOpposite())).map(ContainerManipulator::of).stream())).flatMap(ContainerManipulator::stream);
    }

    @SafeVarargs
    public static <T extends SlotAccessor> ContainerManipulator<T> of(ContainerManipulator<? extends T> ... containers) {
        return () -> Arrays.stream(containers).flatMap(ContainerManipulator::stream);
    }

    public static <T extends SlotAccessor> ContainerManipulator<T> of(Collection<? extends ContainerManipulator<? extends T>> containers) {
        return () -> containers.stream().flatMap(ContainerManipulator::stream);
    }

    public Stream<T> stream();

    default public Iterator<T> containerIterator() {
        return this.stream().iterator();
    }

    default public Stream<ItemStack> streamItems() {
        return this.stream().filter(SlotAccessor::hasItem).map(SlotAccessor::item);
    }

    default public ItemStack insert(ItemStack stack) {
        return this.insert(stack, false);
    }

    default public ItemStack insert(ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Iterator it = this.stream().sorted(Comparator.comparingInt(SlotAccessor::count).reversed()).iterator();
        ItemStack remainder = stack;
        while (it.hasNext()) {
            SlotAccessor slot = (SlotAccessor)it.next();
            remainder = slot.insert(remainder, simulate);
            if (!remainder.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return remainder;
    }

    default public ItemStack extract() {
        return this.extract((ItemStack __) -> true);
    }

    default public ItemStack extract(ItemStack ... filter) {
        return this.extract(ContainerManipulator.anyOf(Arrays.asList(filter)));
    }

    default public ItemStack extract(Predicate<ItemStack> filter) {
        return this.extract(1, filter, false);
    }

    default public ItemStack extract(int maxAmount, Predicate<ItemStack> filter, boolean simulate) {
        return this.stream().filter(slot -> slot.matches(filter)).map(slot -> slot.extract(maxAmount, simulate)).filter(item -> !item.isEmpty()).findFirst().orElse(ItemStack.EMPTY);
    }

    default public ItemStack moveOneItemTo(ContainerManipulator<?> dest) {
        return this.moveOneItemTo(dest, itemStack -> true);
    }

    default public ItemStack moveOneItemTo(ContainerManipulator<?> dest, Predicate<ItemStack> filter) {
        return this.stream().filter(slot -> slot.matches(filter)).filter(slot -> !slot.simulateExtract().isEmpty()).filter(slot -> dest.insert(slot.simulateExtract(), true).isEmpty()).map(slot -> {
            dest.insert(slot.simulateExtract(), false);
            return slot.extract();
        }).findFirst().orElse(ItemStack.EMPTY);
    }

    default public ItemStack moveOneItemStackTo(ContainerManipulator<?> dest) {
        return this.moveOneItemStackTo(dest, itemStack -> true);
    }

    default public ItemStack moveOneItemStackTo(ContainerManipulator<?> dest, Predicate<ItemStack> filter) {
        return this.stream().filter(slot -> slot.matches(filter)).filter(slot -> !slot.simulateExtract(64).isEmpty()).filter(slot -> dest.insert(slot.simulateExtract(64), true).isEmpty()).map(slot -> {
            dest.insert(slot.simulateExtract(64), false);
            return slot.extract(64, false);
        }).findFirst().orElse(ItemStack.EMPTY);
    }

    default public boolean willAcceptAny(List<ItemStack> stacks) {
        return stacks.stream().anyMatch(this::willAccept);
    }

    default public boolean willAccept(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        ItemStack newStack = stack.copyWithCount(1);
        return this.stream().anyMatch(slot -> slot.isValid(newStack));
    }

    default public boolean canFit(ItemStack stack) {
        return this.insert(stack, true).isEmpty();
    }

    default public Optional<T> findFirstExtractable(Predicate<ItemStack> filter) {
        return this.stream().filter(slot -> slot.matches(filter) && !slot.simulateExtract().isEmpty()).findFirst();
    }

    default public boolean contains(Predicate<ItemStack> filter) {
        return this.streamItems().anyMatch(filter);
    }

    default public int countStacks() {
        return (int)this.streamItems().count();
    }

    default public int countStacks(Predicate<ItemStack> filter) {
        return (int)this.streamItems().filter(filter).count();
    }

    default public boolean contains(ItemStack ... items) {
        return this.contains(ContainerManipulator.anyOf(Arrays.asList(items)));
    }

    default public int countItems(Predicate<ItemStack> filter) {
        return this.streamItems().filter(filter).mapToInt(ItemStack::getCount).sum();
    }

    default public int countItems() {
        return this.countItems((ItemStack __) -> true);
    }

    default public int countItems(ItemStack ... filters) {
        return this.countItems(ContainerManipulator.anyOf(Arrays.asList(filters)));
    }

    default public boolean hasItems() {
        return this.streamItems().findAny().isPresent();
    }

    default public boolean hasNoItems() {
        return !this.hasItems();
    }

    default public boolean isFull() {
        return this.stream().allMatch(SlotAccessor::hasItem);
    }

    default public boolean hasEmptySlot() {
        return !this.isFull();
    }

    default public int countMaxItemStackSize() {
        return this.streamItems().mapToInt(ItemStack::getMaxStackSize).sum();
    }

    default public Stream<T> findAll(Predicate<ItemStack> filter) {
        return this.stream().filter(slot -> slot.matches(filter));
    }

    default public double calculateFullness() {
        return this.stream().mapToDouble(slot -> (double)slot.item().getCount() / (double)slot.maxStackSize()).average().orElse(0.0);
    }

    default public int getRedstoneSignal() {
        double average = this.calculateFullness();
        return Mth.floor((double)(average * 14.0)) + (this.hasNoItems() ? 0 : 1);
    }

    public static Predicate<ItemStack> anyOf(Collection<ItemStack> items) {
        return itemStack -> items.isEmpty() || items.stream().allMatch(ItemStack::isEmpty) || items.stream().anyMatch(match -> ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)match));
    }
}

